/*
 * Decompiled with CFR 0.152.
 */
package fan.sys;

import fan.sys.ArgErr;
import fan.sys.Buf;
import fan.sys.FanInt;
import fan.sys.IOErr;
import fan.sys.InStream;
import fan.sys.OutStream;
import fan.sys.Sys;
import fan.sys.Type;
import fan.sys.UnsupportedErr;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class MemBuf
extends Buf {
    public byte[] buf;
    public int pos;
    public int size;

    public MemBuf(int n) {
        this(new byte[n], 0);
    }

    public MemBuf(byte[] byArray) {
        this(byArray, byArray.length);
    }

    public MemBuf(byte[] byArray, int n) {
        this.buf = byArray;
        this.pos = 0;
        this.size = n;
        this.out = new MemBufOutStream();
        this.in = new MemBufInStream();
    }

    public Type typeof() {
        return Sys.MemBufType;
    }

    public final long size() {
        return this.size;
    }

    public final void size(long l) {
        int n = (int)l;
        if (n > this.buf.length) {
            byte[] byArray = new byte[n];
            System.arraycopy(this.buf, 0, byArray, 0, this.buf.length);
            this.buf = byArray;
        }
        this.size = n;
    }

    public final long pos() {
        return this.pos;
    }

    final void pos(long l) {
        this.pos = (int)l;
    }

    public final int getByte(long l) {
        return this.buf[(int)l] & 0xFF;
    }

    public final void setByte(long l, int n) {
        this.buf[(int)l] = (byte)n;
    }

    public final void getBytes(long l, byte[] byArray, int n, int n2) {
        System.arraycopy(this.buf, (int)l, byArray, n, n2);
    }

    public final void pipeTo(byte[] byArray, int n, int n2) {
        if (this.pos + n2 > this.size) {
            throw IOErr.make("Not enough bytes to write");
        }
        System.arraycopy(this.buf, this.pos, byArray, n, n2);
        this.pos += n2;
    }

    public final void pipeTo(OutputStream outputStream, long l) throws IOException {
        int n = (int)l;
        if (this.pos + n > this.size) {
            throw IOErr.make("Not enough bytes to write");
        }
        outputStream.write(this.buf, this.pos, n);
        this.pos += n;
    }

    public final void pipeTo(RandomAccessFile randomAccessFile, long l) throws IOException {
        int n = (int)l;
        if (this.pos + n > this.size) {
            throw IOErr.make("Not enough bytes to write");
        }
        randomAccessFile.write(this.buf, this.pos, n);
        this.pos += n;
    }

    public final void pipeTo(ByteBuffer byteBuffer, int n) {
        if (this.pos + n > this.size) {
            throw IOErr.make("Not enough bytes to write");
        }
        byteBuffer.put(this.buf, this.pos, n);
        this.pos += n;
    }

    public final void pipeFrom(byte[] byArray, int n, int n2) {
        this.grow(this.pos + n2);
        System.arraycopy(byArray, n, this.buf, this.pos, n2);
        this.pos += n2;
        this.size = this.pos;
    }

    public final long pipeFrom(InputStream inputStream, long l) throws IOException {
        int n = (int)l;
        this.grow(this.pos + n);
        int n2 = inputStream.read(this.buf, this.pos, n);
        if (n2 < 0) {
            return -1L;
        }
        this.pos += n2;
        this.size = this.pos;
        return n2;
    }

    public final long pipeFrom(RandomAccessFile randomAccessFile, long l) throws IOException {
        int n = (int)l;
        this.grow(this.pos + n);
        int n2 = randomAccessFile.read(this.buf, this.pos, n);
        if (n2 < 0) {
            return -1L;
        }
        this.pos += n2;
        this.size = this.pos;
        return n2;
    }

    public final int pipeFrom(ByteBuffer byteBuffer, int n) {
        this.grow(this.pos + n);
        byteBuffer.get(this.buf, this.pos, n);
        this.pos += n;
        this.size = this.pos;
        return n;
    }

    public final long capacity() {
        return this.buf.length;
    }

    public final void capacity(long l) {
        int n = (int)l;
        if (n < this.size) {
            throw ArgErr.make("capacity < size");
        }
        byte[] byArray = new byte[n];
        System.arraycopy(this.buf, 0, byArray, 0, Math.min(this.size, n));
        this.buf = byArray;
    }

    public Buf trim() {
        if (this.size == this.buf.length) {
            return this;
        }
        byte[] byArray = new byte[this.size];
        System.arraycopy(this.buf, 0, byArray, 0, this.size);
        this.buf = byArray;
        return this;
    }

    public String toHex() {
        byte[] byArray = this.buf;
        int n = this.size;
        char[] cArray = Buf.hexChars;
        StringBuilder stringBuilder = new StringBuilder(n * 2);
        for (int i = 0; i < n; ++i) {
            int n2 = byArray[i] & 0xFF;
            stringBuilder.append(cArray[n2 >> 4]).append(cArray[n2 & 0xF]);
        }
        return stringBuilder.toString();
    }

    public String toBase64() {
        int n;
        int n2;
        byte[] byArray = this.buf;
        int n3 = this.size;
        StringBuilder stringBuilder = new StringBuilder(n3 * 2);
        char[] cArray = Buf.base64chars;
        int n4 = n3 - 2;
        for (n2 = 0; n2 < n4; n2 += 3) {
            n = ((byArray[n2] & 0xFF) << 16) + ((byArray[n2 + 1] & 0xFF) << 8) + (byArray[n2 + 2] & 0xFF);
            stringBuilder.append(cArray[n >>> 18 & 0x3F]);
            stringBuilder.append(cArray[n >>> 12 & 0x3F]);
            stringBuilder.append(cArray[n >>> 6 & 0x3F]);
            stringBuilder.append(cArray[n & 0x3F]);
        }
        n = n3 - n2;
        if (n > 0) {
            int n5 = (byArray[n2] & 0xFF) << 10 | (n == 2 ? (byArray[n3 - 1] & 0xFF) << 2 : 0);
            stringBuilder.append(cArray[n5 >>> 12 & 0x3F]);
            stringBuilder.append(cArray[n5 >>> 6 & 0x3F]);
            stringBuilder.append(n == 2 ? cArray[n5 & 0x3F] : (char)'=');
            stringBuilder.append('=');
        }
        return stringBuilder.toString();
    }

    public Buf toDigest(String string) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(string);
            messageDigest.update(this.buf, 0, this.size);
            return new MemBuf(messageDigest.digest());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw ArgErr.make("Unknown digest algorthm: " + string);
        }
    }

    public Buf hmac(String string, Buf buf) {
        MessageDigest messageDigest = null;
        int n = 64;
        try {
            messageDigest = MessageDigest.getInstance(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw ArgErr.make("Unknown digest algorthm: " + string);
        }
        byte[] byArray = null;
        int n2 = 0;
        try {
            MemBuf memBuf = (MemBuf)buf;
            byArray = memBuf.buf;
            n2 = memBuf.size;
            if (n2 > n) {
                messageDigest.update(byArray, 0, n2);
                byArray = messageDigest.digest();
                n2 = byArray.length;
                messageDigest.reset();
            }
        }
        catch (ClassCastException classCastException) {
            throw UnsupportedErr.make("key parameter must be memory buffer");
        }
        for (int i = 0; i < n; ++i) {
            if (i < n2) {
                messageDigest.update((byte)(byArray[i] ^ 0x36));
                continue;
            }
            messageDigest.update((byte)54);
        }
        messageDigest.update(this.buf, 0, this.size);
        byte[] byArray2 = messageDigest.digest();
        messageDigest.reset();
        for (int i = 0; i < n; ++i) {
            if (i < n2) {
                messageDigest.update((byte)(byArray[i] ^ 0x5C));
                continue;
            }
            messageDigest.update((byte)92);
        }
        messageDigest.update(byArray2);
        return new MemBuf(messageDigest.digest());
    }

    public final byte[] bytes() {
        byte[] byArray = new byte[this.size];
        System.arraycopy(this.buf, 0, byArray, 0, this.size);
        return byArray;
    }

    public final void grow(int n) {
        if (this.buf.length >= n) {
            return;
        }
        byte[] byArray = new byte[Math.max(n, this.size * 2)];
        System.arraycopy(this.buf, 0, byArray, 0, this.size);
        this.buf = byArray;
    }

    class MemBufInStream
    extends InStream {
        MemBufInStream() {
        }

        public Long read() {
            int n = this.r();
            return n < 0 ? null : FanInt.pos[n];
        }

        public int r() {
            if (MemBuf.this.pos >= MemBuf.this.size) {
                return -1;
            }
            return MemBuf.this.buf[MemBuf.this.pos++] & 0xFF;
        }

        public Long readBuf(Buf buf, long l) {
            if (MemBuf.this.pos >= MemBuf.this.size) {
                return null;
            }
            int n = Math.min(MemBuf.this.size - MemBuf.this.pos, (int)l);
            buf.pipeFrom(MemBuf.this.buf, MemBuf.this.pos, n);
            MemBuf.this.pos += n;
            return n;
        }

        public InStream unread(long l) {
            return this.unread((int)l);
        }

        public InStream unread(int n) {
            if (MemBuf.this.pos > 0 && MemBuf.this.buf[MemBuf.this.pos - 1] == (byte)n) {
                --MemBuf.this.pos;
            } else {
                if (MemBuf.this.size + 1 >= MemBuf.this.buf.length) {
                    MemBuf.this.grow(MemBuf.this.size + 1);
                }
                System.arraycopy(MemBuf.this.buf, MemBuf.this.pos, MemBuf.this.buf, MemBuf.this.pos + 1, MemBuf.this.size);
                MemBuf.this.buf[MemBuf.this.pos] = (byte)n;
                ++MemBuf.this.size;
            }
            return this;
        }

        public Long peek() {
            if (MemBuf.this.pos >= MemBuf.this.size) {
                return null;
            }
            return FanInt.pos[MemBuf.this.buf[MemBuf.this.pos] & 0xFF];
        }

        public long skip(long l) {
            int n = MemBuf.this.pos;
            MemBuf.this.pos = (int)((long)MemBuf.this.pos + l);
            if (MemBuf.this.pos < MemBuf.this.size) {
                return l;
            }
            MemBuf.this.pos = MemBuf.this.size;
            return MemBuf.this.pos - n;
        }
    }

    class MemBufOutStream
    extends OutStream {
        MemBufOutStream() {
        }

        public final OutStream write(long l) {
            return this.w((int)l);
        }

        public final OutStream w(int n) {
            if (MemBuf.this.pos + 1 >= MemBuf.this.buf.length) {
                MemBuf.this.grow(MemBuf.this.pos + 1);
            }
            MemBuf.this.buf[MemBuf.this.pos++] = (byte)n;
            if (MemBuf.this.pos > MemBuf.this.size) {
                MemBuf.this.size = MemBuf.this.pos;
            }
            return this;
        }

        public OutStream writeBuf(Buf buf, long l) {
            int n = (int)l;
            MemBuf.this.grow(MemBuf.this.pos + n);
            buf.pipeTo(MemBuf.this.buf, MemBuf.this.pos, n);
            MemBuf.this.pos += n;
            if (MemBuf.this.pos > MemBuf.this.size) {
                MemBuf.this.size = MemBuf.this.pos;
            }
            return this;
        }

        public OutStream writeChar(long l) {
            this.charsetEncoder.encode((char)l, this);
            return this;
        }

        public OutStream writeChar(char c) {
            this.charsetEncoder.encode(c, this);
            return this;
        }
    }
}

