#!/bin/sh

# This script is for use with CLIs on Unix, e.g. Mono
gacutil -i bin/FSharp.Core.dll
gacutil -i bin/FSharp.Core10.dll
gacutil -i bin/FSharp.Compatibility.dll
gacutil -i bin/FSharp.Compatibility10.dll
gacutil -i bin/FSharp.Compiler.dll
gacutil -i bin/FSharp.Compiler10.dll

chmod u+x bin/fscp10.exe
chmod u+x bin/fsi10.exe
chmod u+x bin/fslexp10.exe
chmod u+x bin/fsyaccp10.exe

chmod u+x bin/fscp.exe
chmod u+x bin/fsi.exe
chmod u+x bin/fslexp.exe
chmod u+x bin/fsyaccp.exe

echo 'You may invoke the F# compiler using'
echo '     mono bin\fscp.exe'
echo ''
echo 'You may invoke F# interactive using'
echo '     mono bin\fsi.exe'
echo ''
echo 'Note: Faster compiler startup times require use of Mono's AOT feature.'
echo '      However, Mono 1.9 only supports AOT on the .NET 1.x profile.'
echo '      Do this using:'
echo '          mono --aot bin/FSharp.Core10.dll'
echo '          mono --aot bin/FSharp.Compatibility10.dll'
echo '          mono --aot bin/FSharp.Compiler10.dll'
echo ''
echo '      and invoke the F# compiler using'
echo '          mono bin\fscp10.exe <inputs>'
echo ''
echo '      If you use this version then some functionality in the compiler '
echo '      will be disabled as it will be configured to generate non-generic code'
