// (c) Microsoft Corporation 2005-2007. 

module Microsoft.FSharp.Collections.Array2
open Microsoft.FSharp.Collections
open Microsoft.FSharp.Core
open Microsoft.FSharp.Core.LanguagePrimitives.IntrinsicOperators
open Microsoft.FSharp.Core.Operators

#if CLI_AT_LEAST_2_0

let cast x = unbox(box x)
(* Define the primitive operations. *)
(* Note: the "type" syntax is for the type parameter for inline *)
(* polymorphic IL. This helps the compiler inline these fragments, *)
(* i.e. work out the correspondence between IL and F# type variables. *)
let length1 (arr: 'a[,]) =  (# "ldlen.multi 2 0" arr : int #)  
let length2 (arr: 'a[,]) =  (# "ldlen.multi 2 1" arr : int #)  
let base1 (arr: 'a[,]) = arr.GetLowerBound(0)  
let base2 (arr: 'a[,]) = arr.GetLowerBound(1) 
let get (arr: 'a[,]) (n:int) (m:int) =  (# "ldelem.multi 2 !0" type ('a) arr n m : 'a #)  
let set (arr: 'a[,]) (n:int) (m:int) (x:'a) =  (# "stelem.multi 2 !0" type ('a) arr n m x #)  
let zero_create (n:int) (m:int) = (# "newarr.multi 2 !0" type ('a) n m : 'a[,] #)
let zero_create_based b1 b2 n1 n2 = 
   (System.Array.CreateInstance((type 'a), [|n1;n2|],[|b1;b2|]) :?> 'a[,])

let create_based b1 b2 n m (x:'a) = 
  let arr = (zero_create_based b1 b2 n m : 'a[,]) in 
  for i = b1 to b1+n - 1 do 
    for j = b2 to b2+m - 1 do 
      (set arr i j x)
    done;
  done;
  arr

let init_based b1 b2 n m f = 
  let arr = (zero_create_based b1 b2 n m : 'a[,])  in 
  for i = b1 to b1+n - 1 do 
    for j = b2 to b2+m - 1 do 
      set arr i j (f i j)
    done;
  done;
  arr

let create n m (x:'a) = create_based 0 0 n m x
let init n m f = init_based 0 0 n m f
let make  n m x = create n m x

let iter f arr = 
  let len1 = length1 arr in 
  let len2 = length2 arr in 
  let b1 = base1 arr in 
  let b2 = base2 arr in 
  for i = b1 to b1+len1 - 1 do 
    for j = b1 to b2+len2 - 1 do 
      f (get arr i j)
    done;
  done

let iteri (f : int -> int -> 'a -> unit) (arr:'a[,]) =
  let len1 = length1 arr in 
  let len2 = length2 arr in 
  let b1 = base1 arr in 
  let b2 = base2 arr in 
  for i = b1 to b1+len1 - 1 do 
    for j = b1 to b2+len2 - 1 do 
      f i j (get arr i j)
    done;
  done

let map f arr = init_based (base1 arr) (base2 arr) (length1 arr) (length2 arr) (fun i j -> f (get arr i j))
let mapi f arr = init_based (base1 arr) (base2 arr) (length1 arr) (length2 arr) (fun i j -> f i j (get arr i j))
let copy arr = init_based (base1 arr) (base2 arr) (length1 arr) (length2 arr) (get arr) 
let rebase arr = 
   let b1 = (base1 arr) in
   let b2 = (base2 arr) in
   init (length1 arr) (length2 arr) (fun i j -> get arr (b1+i) (b2+j))

#endif
let inline geta (arr: 'a[,]) (n:int) (m:int) : 'a nativeptr = (# "ldelema.multi 2 !0" type('a) arr n m : 'a nativeptr #)

let inline pin (arr: 'a [,]) (f : 'a nativeptr -> 'b) = 
    Microsoft.FSharp.Primitives.Basics.NativeOps.pinAny (box arr) (fun _ -> f (geta arr 0 0))
let inline pin_unscoped (arr: 'a [,]) : 'a nativeptr * _ = 
    let gch = Microsoft.FSharp.Primitives.Basics.NativeOps.pinUnscoped (box arr) in 
    geta arr 0 0, gch

