// (c) Microsoft Corporation 2005-2007.

#light

namespace Microsoft.FSharp.Compatibility.OCaml

open Microsoft.FSharp.Core
open Microsoft.FSharp.Core.LanguagePrimitives.IntrinsicOperators
open Microsoft.FSharp.Core.Operators
open Microsoft.FSharp.Collections
#if CLI_AT_MOST_1_1
open Microsoft.FSharp.Compatibility
#else
open System.Collections.Generic
#endif

module Map = 


    type Provider<'key,'a,'tag> 
     when 'tag :> IComparer<'key> =
        { empty: Tagged.Map<'key,'a,'tag>;
          add: 'key -> 'a -> Tagged.Map<'key,'a,'tag> -> Tagged.Map<'key,'a,'tag>;
          find: 'key -> Tagged.Map<'key,'a,'tag> -> 'a;
          first: 'b. ('key -> 'a -> 'b option) -> Tagged.Map<'key,'a,'tag> -> 'b option;
          tryfind: 'key -> Tagged.Map<'key,'a,'tag> -> 'a option;
          remove: 'key -> Tagged.Map<'key,'a,'tag> -> Tagged.Map<'key,'a,'tag>;
          mem: 'key -> Tagged.Map<'key,'a,'tag> -> bool;
          iter: ('key -> 'a -> unit) -> Tagged.Map<'key,'a,'tag> -> unit;
          map:  'b. ('a -> 'b) -> Tagged.Map<'key,'a,'tag> -> Tagged.Map<'key,'b,'tag>;
          mapi: 'b. ('key -> 'a -> 'b) -> Tagged.Map<'key,'a,'tag> -> Tagged.Map<'key,'b,'tag>;
          fold: 'b. ('key -> 'a -> 'b -> 'b) -> Tagged.Map<'key,'a,'tag> -> 'b -> 'b }


    let gen_empty cf = Tagged.Map.Empty (cf)
    let gen_add k v (m:Tagged.Map<_,_,_>) = m.Add(k,v)
    let gen_find k (m:Tagged.Map<_,_,_>) = m.[k]
    let gen_tryfind k (m:Tagged.Map<_,_,_>) = m.TryFind(k)
    let gen_remove k (m:Tagged.Map<_,_,_>) = m.Remove(k)
    let gen_mem k (m:Tagged.Map<_,_,_>) = m.ContainsKey(k)
    let gen_iter f (m:Tagged.Map<_,_,_>) = m.Iterate(f)
    let gen_first f (m:Tagged.Map<_,_,_>) = m.First(f)
    let gen_map f (m:Tagged.Map<_,_,_>) = m.MapRange(f)
    let gen_mapi f (m:Tagged.Map<_,_,_>) = m.Map(f)
    let gen_fold f (m:Tagged.Map<_,_,_>) x = m.Fold f x
    
    let MakeTagged  (cf : 'tag :> IComparer<'key>) : Provider<'key,'a,'tag> =
      { empty =Tagged.Map<'key,'a,'tag>.Empty (cf);
        add =gen_add ;
        find=gen_find;
        first=gen_first;
        tryfind=gen_tryfind ;
        remove= gen_remove ;
        mem =gen_mem ;
        iter =gen_iter; 
        map=gen_map; 
        mapi=gen_mapi;
        fold=gen_fold }

    type Provider<'key,'a> = Provider<'key,'a,IComparer<'key>>
    let Make cf  = MakeTagged (ComparisonIdentity.FromFunction cf)

    type CMap<'key,'a> = Tagged.Map<'key,'a>
    type CMapOps<'key,'a> = Provider<'key,'a>



