
//-----------------------------------------------------------------------------
// This is a translation of the Managed DirectX Tutorial 1 into F#
// File: CreateDevice.fs
//
// Copyright (c) Microsoft Corporation 2005-2006.
// This sample code is provided "as is" without warranty of any kind. 
// We disclaim all warranties, either express or implied, including the 
// warranties of merchantability and fitness for a particular purpose. 
//-----------------------------------------------------------------------------

#light

open System
open System.Drawing
open System.Windows.Forms
open Microsoft.DirectX
open Microsoft.DirectX.Direct3D

let rec device : Device =
    let presentParams = new PresentParameters(Windowed = true, SwapEffect = SwapEffect.Discard)
    new Device(0, DeviceType.Hardware, form,
               CreateFlags.SoftwareVertexProcessing, 
               Idioms.ParamArray [presentParams])

and form : Form =
    { new Form() 
      with OnPaint(e) = 
          device.Clear(ClearFlags.Target, System.Drawing.Color.Blue, 1.0f, 0);
          device.BeginScene();
          device.EndScene();
          device.Present() }

form.Text <- "F# 2.0 D3D Tutorial 01: CreateDevice"
form.ClientSize <- new Size(400, 300)

let main() = Application.Run(form)

// Run the main code. The attribute marks the startup application thread as "Single 
// Thread Apartment" mode, which is necessary for GUI applications. 
[<STAThread>]    
let _ = main()
