// Copyright (c) Microsoft Corporation 2005-2006.
// This sample code is provided "as is" without warranty of any kind. 
// We disclaim all warranties, either express or implied, including the 
// warranties of merchantability and fitness for a particular purpose. 

#light

// Echo Server: opens a service on the localhost which bounces data straight back  

open System.Net
open System.Net.Sockets
open System.Threading

let spawn f = 
    (new Thread(new ThreadStart(f))).Start()

printfn "server starting up..."
let sock = 
    new Socket(AddressFamily.InterNetwork, SocketType.Stream, ProtocolType.IP) 
 
let addr = IPAddress.Parse("127.0.0.1")
sock.Bind(new IPEndPoint(addr, 0))

let backlog = 2 // number of incoming connections that can be queued for acceptance
sock.Listen(backlog)

let port = (sock.LocalEndPoint :?> IPEndPoint).Port 
printfn "server accepting on port %d..." port

while (true) do
    let csock = sock.Accept() 
    printfn "the server has accepted a client on port %d..." port;
    spawn(fun () -> 
        let total = ref 0 
        try 
            let buf = Bytearray.create 64
            let stream = new NetworkStream(csock) 
            while true do
                printfn "server reading...";
                let nread = stream.Read(buf,0,64) 
                printfn "server read %d..." nread;
                stream.Write(buf,0,nread);
                total := !total + nread;
            done;
        with 
            | :? Sockets.SocketException 
            | :? System.IO.IOException -> 
                printfn "client gone: server read %d bytes from that client" !total;
                stdout.Flush()
    )
done


