(* (c) Microsoft Corporation. All rights reserved *)
(* module Sreflect *)

(*F# 
module Microsoft.FSharp.Compiler.Sreflect
open Microsoft.Research.AbstractIL 
open Microsoft.Research.AbstractIL.Internal 
open Microsoft.FSharp.Compiler 
F#*)

open Lib
open Nums
open Bytes

(*IF-OCAML*) 
type float32 =  ieee32 
type sbyte = i8
type byte = u8
type int16 = i16
type uint16 = u16
type int32 = i32
type uint32 = u32
type int64 = i64
type uint64 = u64
(*ENDIF-OCAML*)

module Raw : sig
    type ('a,'b) family  = 'a -> 'b
    type dtype 
    type dtycon 
    type dtypeVarIdx = int
    type dtypeVar =  { tvName: string }
    type dtyconNamed = { tcName: string; tcAssembly:  string }
    val mkVarTy : dtypeVarIdx -> dtype 
    val mkFunTy : (dtype * dtype) -> dtype
    val mkArrayTy : (int    * dtype ) -> dtype 
    val mkNamedTy : (dtyconNamed * dtype list) -> dtype 

    type expr
    type exprConstr 
    type exprVarName 
    type exprVar = { vName: exprVarName; }
    type topDefPath = string list * string
    type topDefData =   { topDefAssembly: string; topDefPath: topDefPath; topDefTypeScheme: dtype }
    type ctorSpec = { ctorParent: dtyconNamed; ctorArgTypes: dtype list; }
    type methSpec = 
     { methParent: dtyconNamed;
       methName: string;
       methArgTypes: dtype list;
       methRetType: dtype; }
    type 'a exprFamilyGN1 = ('a   * dtype list * expr ) -> expr
    type 'a exprFamilyGN2 = ('a   * dtype list * (expr * expr)) -> expr
    type 'a exprFamilyGNN = ('a   * dtype list * expr list) -> expr
                                                                                                                                                   
    val mkVar    : exprVarName -> expr 
    val mkHole   : dtype -> expr 
    val mkApp    : expr * expr -> expr 
    val mkLambda : exprVar * expr -> expr 
    val mkQuote  : expr -> expr 
    val mkCond   : expr * expr * expr -> expr 
    val mkAnyTopDefn : topDefData * dtype list -> expr 
    val mkLetRec : (exprVar * expr) list * expr -> expr 
    val mkLet : (exprVar * expr) * expr -> expr
    val mkRecdMk : dtyconNamed exprFamilyGNN 
    val mkRecdGet : (dtyconNamed * string) exprFamilyGN1 
    val mkRecdSet : (dtyconNamed * string) exprFamilyGN2 
    val mkSum : (dtyconNamed * string) exprFamilyGNN 
    val mkSumFieldGet : (dtyconNamed * string * int) exprFamilyGN1 
    val mkSumTagTest : (dtyconNamed * string) exprFamilyGN1 
    val mkTuple : dtype * expr list -> expr 
    val mkTupleGet : dtype * int * expr -> expr
    val mkEquality : expr * expr -> expr 
    val mkCoerce : dtype * expr -> expr 
    val mkArrayMk : dtype * expr list -> expr 
    val mkUnit : unit -> expr 
    val mkNull : dtype -> expr 
    val mkBool : bool -> expr 
    val mkString : string -> expr 
    val mkSingle : float32 -> expr 
    val mkDouble : float -> expr 
    val mkChar : (*F# char F#*) (*IF-OCAML*) unichar (*ENDIF-OCAML*) -> expr 
    val mkSByte : sbyte -> expr 
    val mkByte : byte -> expr 
    val mkInt16 : int16 -> expr 
    val mkUInt16 : uint16 -> expr 
    val mkInt32 : int32 -> expr 
    val mkUInt32 : uint32 -> expr 
    val mkInt64 : int64 -> expr 
    val mkUInt64 : uint64 -> expr 
    val mkGetAddr : (expr -> expr) 
    val mkSeq : expr * expr -> expr 
    val mkEncodedForLoop : expr * expr * expr -> expr 
    val mkEncodedWhileLoop : expr * expr -> expr 
    val mkDelegate : dtype * expr -> expr 
    val mkPropGet : (dtyconNamed * string) exprFamilyGN1 
    val mkFieldGet : (dtyconNamed * string) exprFamilyGN1 
    val mkCtorCall : ctorSpec exprFamilyGNN 
    val mkMethodCall : methSpec exprFamilyGNN 
    val pickle : (expr -> bytes) 
    val pickleDefns : (((string list * string) * dtypeVar list * dtype * expr) list -> bytes) 
    val pickledDefinitionsResourceNameBase : string
    val freshExprVarName : (string -> dtype -> exprVarName)

end 
