/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali.Adaptors;

import java.io.IOException;
import org.jf.baksmali.baksmali;
import org.jf.dexlib.CodeItem;
import org.jf.dexlib.Util.AccessFlags;
import org.jf.util.IndentingWriter;

public class RegisterFormatter {
    public static void writeRegisterRange(IndentingWriter writer, CodeItem codeItem, int startRegister, int lastRegister) throws IOException {
        assert (lastRegister >= startRegister);
        if (!baksmali.noParameterRegisters) {
            int parameterRegisterCount = codeItem.getParent().method.getPrototype().getParameterRegisterCount() + ((codeItem.getParent().accessFlags & AccessFlags.STATIC.getValue()) == 0 ? 1 : 0);
            int registerCount = codeItem.getRegisterCount();
            assert (startRegister <= lastRegister);
            if (startRegister >= registerCount - parameterRegisterCount) {
                writer.write("{p");
                writer.printSignedIntAsDec(startRegister - (registerCount - parameterRegisterCount));
                writer.write(" .. p");
                writer.printSignedIntAsDec(lastRegister - (registerCount - parameterRegisterCount));
                writer.write(125);
                return;
            }
        }
        writer.write("{v");
        writer.printSignedIntAsDec(startRegister);
        writer.write(" .. v");
        writer.printSignedIntAsDec(lastRegister);
        writer.write(125);
    }

    public static void writeTo(IndentingWriter writer, CodeItem codeItem, int register) throws IOException {
        if (!baksmali.noParameterRegisters) {
            int parameterRegisterCount = codeItem.getParent().method.getPrototype().getParameterRegisterCount() + ((codeItem.getParent().accessFlags & AccessFlags.STATIC.getValue()) == 0 ? 1 : 0);
            int registerCount = codeItem.getRegisterCount();
            if (register >= registerCount - parameterRegisterCount) {
                writer.write(112);
                writer.printSignedIntAsDec(register - (registerCount - parameterRegisterCount));
                return;
            }
        }
        writer.write(118);
        writer.printSignedIntAsDec(register);
    }
}

