/*
 * Decompiled with CFR 0.152.
 */
package docking.dnd;

import docking.dnd.Draggable;
import java.awt.Cursor;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;

public class DragSrcAdapter
implements DragSourceListener {
    protected Draggable dragComponent;
    private Cursor currentCursor;
    private Cursor copyDropCursor = DragSource.DefaultCopyDrop;
    private Cursor copyNoDropCursor = DragSource.DefaultCopyNoDrop;
    private Cursor moveDropCursor = DragSource.DefaultMoveDrop;
    private Cursor moveNoDropCursor = DragSource.DefaultMoveNoDrop;
    private Cursor linkDropCursor = DragSource.DefaultLinkDrop;
    private Cursor linkNoDropCursor = DragSource.DefaultLinkNoDrop;

    public DragSrcAdapter(Draggable dragComponent) {
        this.dragComponent = dragComponent;
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent e) {
        if (!e.getDropSuccess()) {
            this.dragComponent.dragCanceled(e);
            return;
        }
        int dropOp = e.getDropAction();
        int dragAction = this.dragComponent.getDragAction();
        if ((dropOp & 2) == 2 && (dragAction & 2) != 0) {
            this.dragComponent.move();
        }
    }

    @Override
    public void dragEnter(DragSourceDragEvent e) {
        this.setDragOverFeedback(e);
    }

    @Override
    public void dragOver(DragSourceDragEvent e) {
        this.setDragOverFeedback(e);
    }

    @Override
    public void dragExit(DragSourceEvent e) {
        DragSourceContext context = e.getDragSourceContext();
        context.setCursor(null);
        this.currentCursor = this.copyNoDropCursor;
        context.setCursor(this.currentCursor);
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent e) {
        this.setDragOverFeedback(e);
    }

    protected void setDragOverFeedback(DragSourceDragEvent e) {
        DragSourceContext context = e.getDragSourceContext();
        int dropOp = e.getDropAction();
        int targetAction = e.getTargetActions();
        int action = dropOp & targetAction;
        Cursor c = null;
        c = action == 0 ? ((dropOp & 0x40000000) == 0x40000000 ? this.linkNoDropCursor : ((dropOp & 2) == 2 ? this.moveNoDropCursor : this.copyNoDropCursor)) : this.getDropOkCursor(action);
        context.setCursor(null);
        this.currentCursor = c;
        context.setCursor(c);
    }

    protected Cursor getDropOkCursor(int action) {
        Cursor c = (action & 0x40000000) == 0x40000000 ? this.linkDropCursor : ((action & 2) == 2 ? this.moveDropCursor : this.copyDropCursor);
        return c;
    }
}

