/*
 * Decompiled with CFR 0.152.
 */
package docking.menu;

import docking.ActionContext;
import docking.DockingWindowManager;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.action.MultiActionDockingActionIf;
import docking.action.ToggleDockingAction;
import docking.action.ToolBarData;
import docking.menu.ActionState;
import docking.menu.MultipleActionDockingToolbarButton;
import docking.widgets.EventTrigger;
import ghidra.util.HelpLocation;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.AssertException;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import resources.icons.EmptyIcon;

public abstract class MultiStateDockingAction<T>
extends DockingAction {
    private static Icon EMPTY_ICON = new EmptyIcon(16, 16);
    private List<ActionState<T>> actionStates = new ArrayList<ActionState<T>>();
    private int currentStateIndex = -1;
    private MultiActionDockingActionIf multiActionGenerator;
    private MultipleActionDockingToolbarButton multipleButton;
    private boolean performActionOnPrimaryButtonClick = true;
    private Icon defaultIcon;
    private boolean useCheckboxForIcons;
    private ActionListener clickListener = e -> {};

    public MultiStateDockingAction(String name, String owner) {
        this(name, owner, false);
    }

    protected MultiStateDockingAction(String name, String owner, boolean isToolbarAction) {
        super(name, owner);
        this.multiActionGenerator = context -> this.getStateActions();
        super.setToolBarData(new ToolBarData(null));
        if (!isToolbarAction) {
            this.clickListener = e -> this.actionPerformed(this.getActionContext());
        }
    }

    public abstract void actionStateChanged(ActionState<T> var1, EventTrigger var2);

    public void setPerformActionOnPrimaryButtonClick(boolean doPerformAction) {
        this.performActionOnPrimaryButtonClick = doPerformAction;
        if (this.multipleButton == null) {
            return;
        }
        this.multipleButton.setPerformActionOnButtonClick(this.performActionOnPrimaryButtonClick);
        this.multipleButton.removeActionListener(this.clickListener);
        if (this.performActionOnPrimaryButtonClick) {
            this.multipleButton.addActionListener(this.clickListener);
        }
    }

    public void setUseCheckboxForIcons(boolean useCheckboxForIcons) {
        this.useCheckboxForIcons = useCheckboxForIcons;
    }

    public void setDefaultIcon(Icon icon) {
        this.defaultIcon = icon;
    }

    @Override
    public final void actionPerformed(ActionContext context) {
        if (!this.performActionOnPrimaryButtonClick) {
            SystemUtilities.runSwingLater(() -> this.multipleButton.showPopup(null));
            return;
        }
        this.doActionPerformed(context);
    }

    protected void doActionPerformed(ActionContext context) {
    }

    private ActionContext getActionContext() {
        DockingWindowManager manager = DockingWindowManager.getActiveInstance();
        ActionContext context = manager.getActionContext(this);
        if (context == null) {
            context = new ActionContext();
        }
        return context;
    }

    protected List<DockingActionIf> getStateActions() {
        ActionState<T> selectedState = this.actionStates.get(this.currentStateIndex);
        ArrayList<DockingActionIf> actions = new ArrayList<DockingActionIf>(this.actionStates.size());
        for (ActionState<T> actionState : this.actionStates) {
            boolean isSelected = actionState == selectedState;
            DockingAction a = this.useCheckboxForIcons ? new ActionStateToggleAction(actionState, isSelected) : new ActionStateAction(actionState, isSelected);
            actions.add(a);
        }
        return actions;
    }

    public void setGroup(String group) {
        ToolBarData tbd = this.getToolBarData();
        tbd.setToolBarGroup(group);
    }

    public void setSubGroup(String subGroup) {
        ToolBarData tbd = this.getToolBarData();
        tbd.setToolBarSubGroup(subGroup);
    }

    public void addActionState(ActionState<T> actionState) {
        this.actionStates.add(actionState);
        if (this.actionStates.size() == 1) {
            this.setCurrentActionState(actionState);
        }
    }

    public void setActionStates(List<ActionState<T>> newStates) {
        if (newStates.isEmpty()) {
            throw new IllegalArgumentException("You must provide at least one ActionState");
        }
        this.actionStates = new ArrayList<ActionState<T>>(newStates);
        this.setCurrentActionState(this.actionStates.get(0));
    }

    public T getCurrentUserData() {
        return this.actionStates.get(this.currentStateIndex).getUserData();
    }

    public ActionState<T> getCurrentState() {
        return this.actionStates.get(this.currentStateIndex);
    }

    public List<ActionState<T>> getAllActionStates() {
        return new ArrayList<ActionState<T>>(this.actionStates);
    }

    public void setCurrentActionStateByUserData(T t) {
        for (ActionState<T> actionState : this.actionStates) {
            if (!actionState.getUserData().equals(t)) continue;
            this.setCurrentActionState(actionState);
            return;
        }
        throw new AssertException("Attempted to set an action state by a user type not contained herein: " + t);
    }

    public void setCurrentActionState(ActionState<T> actionState) {
        this.setCurrentActionStateWithTrigger(actionState, EventTrigger.API_CALL);
    }

    public void setCurrentActionStateWithTrigger(ActionState<T> actionState, EventTrigger trigger) {
        int indexOf = this.actionStates.indexOf(actionState);
        if (indexOf < 0) {
            throw new IllegalArgumentException("Attempted to set actionState to unknown ActionState.");
        }
        this.currentStateIndex = indexOf;
        this.setButtonState(actionState);
        ToolBarData tbd = this.getToolBarData();
        tbd.setIcon(this.getIcon(actionState));
        this.setDescription(this.getToolTipText());
        this.actionStateChanged(actionState, trigger);
    }

    private Icon getIcon(ActionState<T> actionState) {
        Icon icon = actionState.getIcon();
        if (icon != null) {
            return icon;
        }
        if (this.defaultIcon != null) {
            return this.defaultIcon;
        }
        return EMPTY_ICON;
    }

    @Override
    public JButton doCreateButton() {
        this.multipleButton = new MultipleActionDockingToolbarButton(this.multiActionGenerator);
        this.multipleButton.setPerformActionOnButtonClick(this.performActionOnPrimaryButtonClick);
        if (this.performActionOnPrimaryButtonClick) {
            this.multipleButton.addActionListener(this.clickListener);
        } else {
            this.multipleButton.removeActionListener(this.clickListener);
        }
        if (this.currentStateIndex >= 0) {
            ActionState<T> actionState = this.actionStates.get(this.currentStateIndex);
            this.setButtonState(actionState);
        }
        return this.multipleButton;
    }

    private void setButtonState(ActionState<T> actionState) {
        if (this.multipleButton == null) {
            return;
        }
        if (actionState == null) {
            this.multipleButton.setIcon(null);
            this.multipleButton.setToolTipText(null);
            return;
        }
        Icon icon = this.getIcon(actionState);
        this.multipleButton.setIcon(icon);
        this.multipleButton.setToolTipText(actionState.getName());
    }

    @Override
    public void setMenuBarData(MenuData newMenuData) {
        throw new UnsupportedOperationException();
    }

    protected void superSetMenuBarData(MenuData newMenuData) {
        super.setMenuBarData(newMenuData);
    }

    @Override
    public void setPopupMenuData(MenuData newMenuData) {
        throw new UnsupportedOperationException();
    }

    public String getToolTipText() {
        if (this.actionStates.isEmpty()) {
            return this.getName() + ": <no action states installed>";
        }
        return this.getName() + ": " + this.getCurrentState().getName();
    }

    private class ActionStateAction
    extends DockingAction {
        private final ActionState<T> actionState;

        private ActionStateAction(ActionState<T> actionState, boolean isSelected) {
            super(actionState.getName(), "multiStateAction");
            this.actionState = actionState;
            this.setMenuBarData(new MenuData(new String[]{actionState.getName()}, actionState.getIcon()));
            HelpLocation helpLocation = actionState.getHelpLocation();
            if (helpLocation != null) {
                this.setHelpLocation(helpLocation);
            }
        }

        @Override
        public String getInceptionInformation() {
            return MultiStateDockingAction.this.getInceptionInformation();
        }

        @Override
        public void actionPerformed(ActionContext context) {
            MultiStateDockingAction.this.setCurrentActionStateWithTrigger(this.actionState, EventTrigger.GUI_ACTION);
        }
    }

    private class ActionStateToggleAction
    extends ToggleDockingAction {
        private final ActionState<T> actionState;

        private ActionStateToggleAction(ActionState<T> actionState, boolean isSelected) {
            super(actionState.getName(), "multiStateAction");
            this.actionState = actionState;
            this.setSelected(isSelected);
            this.setMenuBarData(new MenuData(new String[]{actionState.getName()}));
            HelpLocation helpLocation = actionState.getHelpLocation();
            if (helpLocation != null) {
                this.setHelpLocation(helpLocation);
            }
        }

        @Override
        public String getInceptionInformation() {
            return MultiStateDockingAction.this.getInceptionInformation();
        }

        @Override
        public void actionPerformed(ActionContext context) {
            MultiStateDockingAction.this.setCurrentActionStateWithTrigger(this.actionState, EventTrigger.GUI_ACTION);
        }
    }
}

