/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.fieldpanel.field;

import docking.widgets.fieldpanel.field.Field;
import docking.widgets.fieldpanel.internal.FieldBackgroundColorManager;
import docking.widgets.fieldpanel.internal.PaintContext;
import docking.widgets.fieldpanel.support.DefaultRowColLocation;
import docking.widgets.fieldpanel.support.RowColLocation;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class SimpleImageField
implements Field {
    protected ImageIcon icon;
    protected FontMetrics metrics;
    protected int startX;
    protected int width;
    protected int height;
    protected boolean center;
    protected boolean isPrimary;
    protected int heightAbove;

    public SimpleImageField(ImageIcon icon, FontMetrics metrics, int startX, int startY, int width) {
        this(icon, metrics, startX, startY, width, false);
    }

    public SimpleImageField(ImageIcon icon, FontMetrics metrics, int startX, int startY, int width, boolean center) {
        this.heightAbove = metrics.getMaxAscent() + metrics.getLeading();
        this.height = this.heightAbove + metrics.getMaxDescent();
        this.icon = icon;
        this.metrics = metrics;
        this.startX = startX;
        this.width = width;
        this.center = center;
        if (icon != null && this.height < icon.getIconHeight()) {
            this.height = this.width < icon.getIconWidth() ? width * icon.getIconHeight() / icon.getIconWidth() : icon.getIconHeight();
        }
    }

    @Override
    public boolean contains(int x, int y) {
        return x >= this.startX && x < this.startX + this.width && y >= -this.heightAbove && y < this.height - this.heightAbove;
    }

    @Override
    public int getCol(int row, int x) {
        return 0;
    }

    @Override
    public Rectangle getCursorBounds(int row, int col) {
        if (row != 0) {
            return null;
        }
        return new Rectangle(this.startX, -this.heightAbove, this.width, this.height);
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getNumDataRows() {
        return 1;
    }

    @Override
    public int getNumRows() {
        return 1;
    }

    @Override
    public int getNumCols(int row) {
        return 1;
    }

    @Override
    public int getRow(int y) {
        return 0;
    }

    @Override
    public int getScrollableUnitIncrement(int topOfScreen, int direction, int max) {
        if (topOfScreen < -this.heightAbove || topOfScreen > this.height - this.heightAbove) {
            return max;
        }
        if (direction > 0) {
            return this.height - topOfScreen - this.heightAbove;
        }
        return -this.heightAbove - topOfScreen;
    }

    @Override
    public int getStartX() {
        return this.startX;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getPreferredWidth() {
        return this.icon.getIconWidth();
    }

    @Override
    public int getX(int row, int col) {
        return 0;
    }

    @Override
    public int getY(int row) {
        return -this.heightAbove;
    }

    @Override
    public boolean isValid(int row, int col) {
        if (row != 0) {
            return false;
        }
        return col == 0;
    }

    @Override
    public void paint(JComponent c, Graphics g, PaintContext context, Rectangle clip, FieldBackgroundColorManager map, RowColLocation cursorLoc, int rowHeight) {
        if (this.icon == null) {
            return;
        }
        int tmpWidth = this.icon.getIconWidth();
        int tmpHeight = this.icon.getIconHeight();
        int xoffset = 0;
        int yoffset = 0;
        if (this.center) {
            if (this.width > this.icon.getIconWidth()) {
                xoffset = this.width / 2 - this.icon.getIconWidth() / 2;
            }
            if (this.height > this.icon.getIconHeight()) {
                yoffset = this.height / 2 - this.icon.getIconHeight() / 2;
            }
        }
        if (tmpWidth > this.width) {
            tmpWidth = this.width;
        }
        if (tmpHeight > this.height) {
            tmpHeight = this.height;
        }
        g.drawImage(this.icon.getImage(), this.startX + xoffset, -this.heightAbove + yoffset, tmpWidth, tmpHeight, this.icon.getImageObserver());
        if (cursorLoc != null) {
            g.setColor(context.getCursorColor());
            Rectangle rect = this.getCursorBounds(cursorLoc.row(), cursorLoc.col());
            g.drawRect(rect.x, rect.y, tmpWidth - 1, tmpHeight - 1);
        }
    }

    @Override
    public boolean isPrimary() {
        return this.isPrimary;
    }

    public void setPrimary(boolean state) {
        this.isPrimary = state;
    }

    @Override
    public int getHeightAbove() {
        return this.heightAbove;
    }

    @Override
    public int getHeightBelow() {
        return this.height - this.heightAbove;
    }

    @Override
    public void rowHeightChanged(int newHeightAbove, int newHeightBelow) {
    }

    @Override
    public String getText() {
        return "";
    }

    @Override
    public String getTextWithLineSeparators() {
        return "";
    }

    @Override
    public RowColLocation textOffsetToScreenLocation(int textOffset) {
        return new DefaultRowColLocation();
    }

    @Override
    public int screenLocationToTextOffset(int row, int col) {
        return 0;
    }
}

