/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.fieldpanel.internal;

import docking.widgets.fieldpanel.FieldPanel;
import docking.widgets.fieldpanel.internal.FieldPanelCoordinator;
import ghidra.util.exception.AssertException;
import java.math.BigInteger;
import java.util.ArrayList;

public class LineLockedFieldPanelCoordinator
extends FieldPanelCoordinator {
    protected BigInteger[] lockedLineNumbers;

    public LineLockedFieldPanelCoordinator(FieldPanel[] panels) {
        super(panels);
        this.resetLockedLines();
    }

    public void resetLockedLines() {
        this.lockedLineNumbers = new BigInteger[this.panels.length];
        for (int i = 0; i < this.lockedLineNumbers.length; ++i) {
            this.lockedLineNumbers[i] = BigInteger.ZERO;
        }
    }

    public void setLockedLines(BigInteger[] lockedLineNumbers) {
        int i;
        if (lockedLineNumbers.length != this.lockedLineNumbers.length) {
            throw new AssertException("The number of lines(" + lockedLineNumbers.length + ") must exactly match the number of panels(" + this.lockedLineNumbers.length + ").");
        }
        for (i = 0; i < lockedLineNumbers.length; ++i) {
            if (lockedLineNumbers[i] != null) continue;
            lockedLineNumbers[i] = BigInteger.ZERO;
        }
        for (i = 0; i < lockedLineNumbers.length; ++i) {
            if (this.lockedLineNumbers[i].equals(lockedLineNumbers[i])) continue;
            this.lockedLineNumbers[i] = lockedLineNumbers[i];
        }
    }

    @Override
    public void add(FieldPanel fp) {
        BigInteger[] newLineNumbers = new BigInteger[this.lockedLineNumbers.length + 1];
        System.arraycopy(this.lockedLineNumbers, 0, newLineNumbers, 0, this.lockedLineNumbers.length);
        newLineNumbers[this.panels.length] = BigInteger.valueOf(0L);
        this.lockedLineNumbers = newLineNumbers;
        super.add(fp);
    }

    @Override
    public void remove(FieldPanel fp) {
        ArrayList<BigInteger> lineNumberList = new ArrayList<BigInteger>(this.panels.length);
        int length = this.panels.length;
        for (int i = 0; i < length; ++i) {
            if (this.panels[i] == fp) continue;
            lineNumberList.add(this.lockedLineNumbers[i]);
        }
        this.lockedLineNumbers = lineNumberList.toArray(new BigInteger[lineNumberList.size()]);
        super.remove(fp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void viewChanged(FieldPanel fp, BigInteger index, int xPos, int yPos) {
        if (this.valuesChanging) {
            return;
        }
        try {
            this.valuesChanging = true;
            BigInteger fpLineNumber = this.getLockedLineForPanel(fp);
            if (fpLineNumber == null) {
                throw new AssertException("Couldn't find line number for indicated field panel.");
            }
            for (int i = 0; i < this.panels.length; ++i) {
                if (this.panels[i] == fp) continue;
                BigInteger adjustment = this.lockedLineNumbers[i].subtract(fpLineNumber);
                BigInteger panelIndex = index.add(adjustment);
                if (panelIndex.longValue() < 0L) {
                    panelIndex = BigInteger.valueOf(0L);
                }
                this.panels[i].setViewerPosition(panelIndex, xPos, yPos);
            }
        }
        finally {
            this.valuesChanging = false;
        }
    }

    protected BigInteger getLockedLineForPanel(FieldPanel fp) {
        for (int i = 0; i < this.lockedLineNumbers.length; ++i) {
            if (this.panels[i] != fp) continue;
            return this.lockedLineNumbers[i];
        }
        return null;
    }
}

