/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table;

import docking.widgets.AbstractGCellRenderer;
import docking.widgets.table.GTable;
import docking.widgets.table.GTableCellRenderingData;
import docking.widgets.table.RowObjectTableModel;
import ghidra.docking.settings.FloatingPointPrecisionSettingsDefinition;
import ghidra.docking.settings.FormatSettingsDefinition;
import ghidra.docking.settings.IntegerSignednessFormattingModeSettingsDefinition;
import ghidra.docking.settings.Settings;
import ghidra.util.NumericUtilities;
import ghidra.util.SignednessFormatMode;
import ghidra.util.StringUtilities;
import ghidra.util.exception.AssertException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class GTableCellRenderer
extends AbstractGCellRenderer
implements TableCellRenderer {
    protected static final FormatSettingsDefinition INTEGER_RADIX_SETTING = FormatSettingsDefinition.DEF_DECIMAL;
    protected static final IntegerSignednessFormattingModeSettingsDefinition INTEGER_SIGNEDNESS_MODE_SETTING = IntegerSignednessFormattingModeSettingsDefinition.DEF;
    protected static final FloatingPointPrecisionSettingsDefinition FLOATING_POINT_PRECISION_SETTING = FloatingPointPrecisionSettingsDefinition.DEF;
    private static DecimalFormat decimalFormat;
    private static Map<Integer, DecimalFormat> decimalFormatCache;

    public GTableCellRenderer() {
    }

    public GTableCellRenderer(Font f) {
        this();
        this.setFont(f);
    }

    protected String getText(Object value) {
        return value == null ? "" : value.toString();
    }

    @Override
    public final Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (!(table instanceof GTable)) {
            throw new AssertException("Using a GTableCellRenderer in a non-GTable table. (Model class: " + table.getModel().getClass().getName() + ")");
        }
        GTable gTable = (GTable)table;
        GTableCellRenderingData data = gTable.getRenderingData(column);
        Object rowObject = null;
        if (gTable.getModel() instanceof RowObjectTableModel) {
            rowObject = ((RowObjectTableModel)gTable.getModel()).getRowObject(row);
        }
        data.setRowData(row, rowObject);
        data.setCellData(value, column, isSelected, hasFocus);
        Component renderComponent = this.getTableCellRendererComponent(data);
        data.resetRowData();
        return renderComponent;
    }

    public Component getTableCellRendererComponent(GTableCellRenderingData data) {
        Object value = data.getValue();
        JTable table = data.getTable();
        int row = data.getRowViewIndex();
        int column = data.getColumnViewIndex();
        boolean isSelected = data.isSelected();
        boolean hasFocus = data.hasFocus();
        Settings settings = data.getColumnSettings();
        if (value instanceof Number) {
            this.setHorizontalAlignment(4);
            this.setText(this.formatNumber((Number)value, settings));
        } else {
            this.setText(this.getText(value));
            this.setHorizontalAlignment(2);
        }
        TableModel model = table.getModel();
        this.configureFont(table, model, column);
        if (isSelected) {
            this.setForeground(table.getSelectionForeground());
            this.setBackground(table.getSelectionBackground());
            this.setOpaque(true);
        } else {
            this.setForegroundColor(table, model, value);
            if (row == this.dropRow) {
                this.setBackground(Color.CYAN);
            } else {
                this.setBackground(this.getOSDependentBackgroundColor(table, row));
            }
        }
        this.setBorder(hasFocus ? this.focusBorder : this.noFocusBorder);
        return this;
    }

    protected void setForegroundColor(JTable table, TableModel model, Object value) {
        this.setForeground(table.getForeground());
    }

    protected void configureFont(JTable table, TableModel model, int column) {
        this.setFont(this.defaultFont);
    }

    protected String formatNumber(Number value, Settings settings) {
        String numberString = value.toString();
        if (NumericUtilities.isIntegerType((Number)value)) {
            int radix = INTEGER_RADIX_SETTING.getRadix(settings);
            SignednessFormatMode signMode = INTEGER_SIGNEDNESS_MODE_SETTING.getFormatMode(settings);
            long number = value.longValue();
            numberString = NumericUtilities.formatNumber((long)number, (int)radix, (SignednessFormatMode)signMode);
        } else if (NumericUtilities.isFloatingPointType((Number)value)) {
            Double number = value.doubleValue();
            if (number.isNaN() || number.isInfinite()) {
                numberString = Character.toString('\u221e');
            } else {
                int digitsPrecision = FLOATING_POINT_PRECISION_SETTING.getPrecision(settings);
                numberString = this.getFormatter(digitsPrecision).format(number);
            }
        } else if (value instanceof BigInteger) {
            int radix = INTEGER_RADIX_SETTING.getRadix(settings);
            numberString = ((BigInteger)value).toString(radix);
        } else if (value instanceof BigDecimal) {
            numberString = ((BigDecimal)value).toPlainString();
        }
        return numberString;
    }

    private DecimalFormat getFormatter(int digitsPrecision) {
        if (decimalFormat == null) {
            GTableCellRenderer.initFormatCache();
        }
        digitsPrecision = Math.max(0, Math.min(digitsPrecision, FloatingPointPrecisionSettingsDefinition.MAX_PRECISION));
        return decimalFormatCache.get(digitsPrecision);
    }

    private static void initFormatCache() {
        decimalFormatCache = new HashMap<Integer, DecimalFormat>(FloatingPointPrecisionSettingsDefinition.MAX_PRECISION);
        for (int i = 0; i <= FloatingPointPrecisionSettingsDefinition.MAX_PRECISION; ++i) {
            decimalFormatCache.put(i, new DecimalFormat(GTableCellRenderer.createDecimalFormat(i)));
        }
    }

    private static String createDecimalFormat(int digitsPrecision) {
        if (digitsPrecision <= 0) {
            return "0";
        }
        return "0." + StringUtilities.pad((String)"", (char)'0', (int)digitsPrecision);
    }
}

