/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.jdi.model;

import com.sun.jdi.ClassType;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.Mirror;
import com.sun.jdi.ReferenceType;
import ghidra.dbg.agent.AbstractDebuggerObjectModel;
import ghidra.dbg.agent.SpiTargetObject;
import ghidra.dbg.jdi.manager.JdiManager;
import ghidra.dbg.jdi.model.JdiModelTargetReferenceType;
import ghidra.dbg.jdi.model.JdiModelTargetRoot;
import ghidra.dbg.jdi.model.JdiModelTargetSectionContainer;
import ghidra.dbg.jdi.model.JdiModelTargetVM;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.AnnotatedSchemaContext;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.address.DefaultAddressFactory;
import ghidra.program.model.address.GenericAddressSpace;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class JdiModelImpl
extends AbstractDebuggerObjectModel {
    protected JdiModelTargetRoot root;
    protected final CompletableFuture<JdiModelTargetRoot> completedRoot;
    public static final long BLOCK_SIZE = 4096L;
    public static final long DEFAULT_SECTION = 0L;
    protected static final AnnotatedSchemaContext SCHEMA_CTX = new AnnotatedSchemaContext();
    protected static final TargetObjectSchema ROOT_SCHEMA = SCHEMA_CTX.getSchemaForClass(JdiModelTargetRoot.class);
    protected JdiManager jdi;
    protected final AddressSpace ram = new GenericAddressSpace("ram", 64, 1, 0);
    protected Long ramIndex = 4096L;
    protected final AddressSpace pool = new GenericAddressSpace("constantPool", 64, 1, 0);
    protected Long poolIndex = 0L;
    protected final AddressFactory addressFactory = new DefaultAddressFactory(new AddressSpace[]{this.ram, this.pool});
    public AddressRangeImpl defaultRange;
    private Map<String, AddressRange> addressRangeByMethod = new HashMap<String, AddressRange>();
    private Map<String, Method> methodsByKey = new HashMap<String, Method>();
    private Map<JdiModelTargetReferenceType, AddressRange> addressRangeByClass = new HashMap<JdiModelTargetReferenceType, AddressRange>();

    public JdiModelImpl() {
        this.jdi = JdiManager.newInstance();
        this.root = new JdiModelTargetRoot(this, ROOT_SCHEMA);
        this.completedRoot = CompletableFuture.completedFuture(this.root);
        Address start = this.ram.getAddress(0L);
        this.defaultRange = new AddressRangeImpl(start, start.add(4096L));
        this.addModelRoot((SpiTargetObject)this.root);
    }

    public CompletableFuture<? extends TargetObject> fetchModelRoot() {
        return this.completedRoot;
    }

    public String getBrief() {
        return "JDI@" + Integer.toHexString(System.identityHashCode((Object)this));
    }

    public AddressSpace getAddressSpace(String name) {
        switch (name) {
            case "ram": {
                return this.ram;
            }
            case "constantPool": {
                return this.pool;
            }
        }
        return null;
    }

    public CompletableFuture<Void> close() {
        this.jdi.terminate();
        return super.close();
    }

    public JdiModelTargetRoot getRoot() {
        return this.root;
    }

    public JdiManager getManager() {
        return this.jdi;
    }

    public static String methodToKey(Method method) {
        return method.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerMethod(Method method) {
        JdiModelTargetVM targetVM;
        JdiModelTargetReferenceType classRef;
        ReferenceType declaringType;
        if (method == null) {
            return;
        }
        if (!this.methodsByKey.containsValue(method)) {
            this.methodsByKey.put(JdiModelImpl.methodToKey(method), method);
        }
        if (!this.addressRangeByMethod.containsKey(JdiModelImpl.methodToKey(method)) && (declaringType = method.declaringType()) instanceof ClassType && (classRef = (JdiModelTargetReferenceType)(targetVM = this.getTargetVM(declaringType)).getTargetObject(declaringType)) != null) {
            JdiModelTargetSectionContainer sectionContainer = classRef.sections;
            for (Method m : declaringType.methods()) {
                if (m.location() == null || !targetVM.vm.canGetBytecodes()) continue;
                byte[] bytecodes = m.bytecodes();
                int length = bytecodes.length;
                if (length > 0) {
                    Long l = this.ramIndex;
                    synchronized (l) {
                        Address start = this.ram.getAddress(this.ramIndex.longValue());
                        AddressRangeImpl range = new AddressRangeImpl(start, start.add(4095L));
                        String key = JdiModelImpl.methodToKey(m);
                        if (this.addressRangeByMethod.containsKey(key)) {
                            System.err.println("non-null location: " + m.location() + " with " + length + " bytes");
                        }
                        this.addressRangeByMethod.put(key, (AddressRange)range);
                        if (sectionContainer != null) {
                            sectionContainer.addSection(m);
                        } else {
                            System.err.println("null sectionContainer");
                        }
                        this.ramIndex = this.ramIndex + 4096L;
                        continue;
                    }
                }
                Address start = this.ram.getAddress(0L);
                AddressRangeImpl range = new AddressRangeImpl(start, start.add(4095L));
                String key = JdiModelImpl.methodToKey(m);
                if (this.addressRangeByMethod.containsKey(key)) {
                    throw new RuntimeException("non-null location: " + m.location() + " with " + length + " bytes");
                }
                this.addressRangeByMethod.put(key, (AddressRange)range);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerConstantPool(JdiModelTargetReferenceType classType, int size) {
        ReferenceType declaringType;
        if (!this.addressRangeByClass.containsKey(classType) && (declaringType = classType.reftype) instanceof ClassType) {
            long length;
            JdiModelTargetVM targetVM = this.getTargetVM(declaringType);
            if (targetVM.vm.canGetConstantPool() && (length = (long)size) > 0L) {
                Long l = this.poolIndex;
                synchronized (l) {
                    Address start = this.pool.getAddress(this.poolIndex.longValue());
                    length = (length % 4096L + 1L) * 4096L;
                    AddressRangeImpl range = new AddressRangeImpl(start, start.add(length - 1L));
                    if (this.addressRangeByClass.containsKey(classType)) {
                        System.err.println("non-null location: " + classType + " with " + length + " bytes");
                    }
                    this.addressRangeByClass.put(classType, (AddressRange)range);
                    this.poolIndex = this.poolIndex + length;
                }
            }
        }
    }

    public JdiModelTargetVM getTargetVM(Mirror mirror) {
        return this.root.vms.getTargetVM(mirror.virtualMachine());
    }

    public AddressRange getAddressRange(Method method) {
        if (method == null) {
            return this.defaultRange;
        }
        AddressRange range = this.addressRangeByMethod.get(JdiModelImpl.methodToKey(method));
        if (range == null) {
            this.registerMethod(method);
            range = this.addressRangeByMethod.get(JdiModelImpl.methodToKey(method));
        }
        return range;
    }

    public Method getMethodForAddress(Address address) {
        for (String methodName : this.addressRangeByMethod.keySet()) {
            AddressRange range = this.addressRangeByMethod.get(methodName);
            if (!range.contains(address)) continue;
            return this.methodsByKey.get(methodName);
        }
        return null;
    }

    public Location getLocation(Address address) {
        Method method = this.getMethodForAddress(address);
        long codeIndex = address.subtract(this.getAddressRange(method).getMinAddress());
        return method.locationOfCodeIndex(codeIndex);
    }

    public AddressRange getAddressRange(JdiModelTargetReferenceType classType, int sz) {
        AddressRange range = this.addressRangeByClass.get(classType);
        if (range == null) {
            this.registerConstantPool(classType, sz);
            range = this.addressRangeByClass.get(classType);
        }
        return range;
    }

    public AddressFactory getAddressFactory() {
        return this.addressFactory;
    }
}

