/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.jdi.model;

import com.sun.jdi.ReferenceType;
import ghidra.async.AsyncFence;
import ghidra.async.AsyncUtils;
import ghidra.dbg.jdi.model.JdiModelTargetObjectImpl;
import ghidra.dbg.jdi.model.JdiModelTargetReferenceType;
import ghidra.dbg.jdi.model.JdiModelTargetVM;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.util.Msg;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

@TargetObjectSchemaInfo(name="ClassContainer", elements={@TargetElementType(type=JdiModelTargetReferenceType.class)}, attributes={@TargetAttributeType(type=Void.class)}, canonicalContainer=true)
public class JdiModelTargetClassContainer
extends JdiModelTargetObjectImpl {
    protected final JdiModelTargetVM vm;
    private final Map<String, JdiModelTargetReferenceType> classesByName = new HashMap<String, JdiModelTargetReferenceType>();

    public JdiModelTargetClassContainer(JdiModelTargetVM vm) {
        super(vm, "Classes");
        this.vm = vm;
        this.requestElements(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CompletableFuture<Void> updateUsingClasses(Map<String, ReferenceType> byName) {
        List classes;
        JdiModelTargetClassContainer jdiModelTargetClassContainer = this;
        synchronized (jdiModelTargetClassContainer) {
            classes = byName.values().stream().map(this::getTargetClass).collect(Collectors.toList());
        }
        AsyncFence fence = new AsyncFence();
        for (JdiModelTargetReferenceType c : classes) {
            fence.include(c.init());
        }
        return fence.ready().thenAccept(__ -> this.changeElements(List.of(), classes, Map.of(), "Refreshed"));
    }

    protected CompletableFuture<Void> requestElements(boolean refresh) {
        return this.doRefresh();
    }

    protected CompletableFuture<Void> doRefresh() {
        HashMap<String, ReferenceType> map = new HashMap<String, ReferenceType>();
        List<ReferenceType> allClasses = this.vm.vm.allClasses();
        for (ReferenceType ref : allClasses) {
            map.put(ref.name(), ref);
        }
        this.getClassesByName().keySet().retainAll(map.keySet());
        return this.updateUsingClasses(map);
    }

    protected synchronized JdiModelTargetReferenceType getTargetClass(ReferenceType reftype) {
        return this.getClassesByName().computeIfAbsent(reftype.name(), n -> (JdiModelTargetReferenceType)this.getInstance(reftype));
    }

    public synchronized JdiModelTargetReferenceType getTargetModuleIfPresent(String name) {
        return this.getClassesByName().get(name);
    }

    public CompletableFuture<?> refreshInternal() {
        if (!this.isObserved()) {
            return AsyncUtils.NIL;
        }
        return this.doRefresh().exceptionally(ex -> {
            Msg.error((Object)this, (Object)"Problem refreshing vm's classes", (Throwable)ex);
            return null;
        });
    }

    public Map<String, JdiModelTargetReferenceType> getClassesByName() {
        return this.classesByName;
    }
}

