/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.jdi.model;

import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.LocalVariable;
import ghidra.dbg.jdi.model.JdiModelTargetAttributesContainer;
import ghidra.dbg.jdi.model.JdiModelTargetLocalVariableContainer;
import ghidra.dbg.jdi.model.JdiModelTargetObjectImpl;
import ghidra.dbg.jdi.model.JdiModelTargetType;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

@TargetObjectSchemaInfo(name="LocalVariable", elements={@TargetElementType(type=Void.class)}, attributes={@TargetAttributeType(name="Attributes", type=JdiModelTargetAttributesContainer.class), @TargetAttributeType(name="Generic Signature", type=String.class), @TargetAttributeType(name="Signature", type=String.class), @TargetAttributeType(name="Type", type=String.class, required=true), @TargetAttributeType(type=Void.class)})
public class JdiModelTargetLocalVariable
extends JdiModelTargetObjectImpl {
    String IS_ARGUMENT_ATTRIBUTE_NAME = "IsArg";
    String VISIBLE_TYPE_ATTRIBUTE_NAME = "Type";
    protected final LocalVariable var;
    private JdiModelTargetAttributesContainer addedAttributes;

    public JdiModelTargetLocalVariable(JdiModelTargetLocalVariableContainer variables, LocalVariable var, boolean isElement) {
        super(variables, var.name(), var, isElement);
        this.var = var;
        this.changeAttributes(List.of(), List.of(), Map.of("_display", var.name(), this.VISIBLE_TYPE_ATTRIBUTE_NAME, var.typeName()), "Initialized");
    }

    private void populateAttributes() {
        this.addedAttributes = new JdiModelTargetAttributesContainer(this, "Attributes");
        HashMap<String, Boolean> attrs = new HashMap<String, Boolean>();
        attrs.put("isArgument", this.var.isArgument());
        this.addedAttributes.addAttributes(attrs);
    }

    public CompletableFuture<Void> requestAttributes(boolean refresh) {
        this.populateAttributes();
        this.changeAttributes(List.of(), List.of(this.addedAttributes), Map.of("Signature", this.var.signature()), "Initialized");
        try {
            JdiModelTargetType type = (JdiModelTargetType)this.getInstance(this.var.type());
            this.changeAttributes(List.of(), List.of(), Map.of("Type", type), "Initialized");
        }
        catch (ClassNotLoadedException type) {
            // empty catch block
        }
        String genericSignature = this.var.genericSignature();
        if (genericSignature != null) {
            this.changeAttributes(List.of(), List.of(), Map.of("Generic Signature", genericSignature), "Initialized");
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> init() {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public String getDisplay() {
        return this.var == null ? super.getDisplay() : this.var.name();
    }
}

