/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.jdi.model;

import com.sun.jdi.LocalVariable;
import com.sun.jdi.Value;
import ghidra.async.AsyncFence;
import ghidra.dbg.jdi.model.JdiModelTargetObjectImpl;
import ghidra.dbg.jdi.model.JdiModelTargetValue;
import ghidra.dbg.jdi.model.iface2.JdiModelTargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

@TargetObjectSchemaInfo(name="TargetValueMap", elements={@TargetElementType(type=Void.class)}, elementResync=TargetObjectSchema.ResyncMode.ONCE, attributes={@TargetAttributeType(type=JdiModelTargetValue.class)}, canonicalContainer=true)
public class JdiModelTargetValueMap
extends JdiModelTargetObjectImpl {
    private Map<LocalVariable, Value> values;
    protected final Map<LocalVariable, JdiModelTargetValue> valuesByVariable = new HashMap<LocalVariable, JdiModelTargetValue>();

    public JdiModelTargetValueMap(JdiModelTargetObject parent, Map<LocalVariable, Value> vals) {
        super(parent, "Value Map");
        this.values = vals;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CompletableFuture<Void> updateUsingValues(Map<LocalVariable, Value> byName) {
        HashMap<String, JdiModelTargetValue> vals = new HashMap<String, JdiModelTargetValue>();
        JdiModelTargetValueMap jdiModelTargetValueMap = this;
        synchronized (jdiModelTargetValueMap) {
            for (LocalVariable key : byName.keySet()) {
                Value val = byName.get(key);
                if (val == null) continue;
                JdiModelTargetValue targetValue = this.getTargetValue(key, val);
                vals.put(key.name(), targetValue);
            }
        }
        AsyncFence fence = new AsyncFence();
        for (JdiModelTargetValue var : vals.values()) {
            fence.include(var.init());
        }
        return fence.ready().thenAccept(__ -> this.setAttributes(List.of(), vals, "Refreshed"));
    }

    public CompletableFuture<Void> requestAttributes(boolean refresh) {
        return this.updateUsingValues(this.values);
    }

    protected synchronized JdiModelTargetValue getTargetValue(LocalVariable var, Value val) {
        return this.valuesByVariable.computeIfAbsent(var, n -> new JdiModelTargetValue(this, val, false));
    }

    public synchronized JdiModelTargetValue getTargetValueIfPresent(LocalVariable var) {
        return this.valuesByVariable.get(var);
    }
}

