/*
 * Decompiled with CFR 0.152.
 */
package resources;

import generic.Images;
import generic.util.image.ImageUtils;
import ghidra.util.Msg;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.ImageIcon;
import resources.ResourceManager;

public class IconProvider {
    private ImageIcon icon;
    private URL url;
    private URL tempUrl;
    private boolean tempFileFailed;

    public IconProvider(ImageIcon icon, URL url) {
        this.icon = icon;
        this.url = url;
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public boolean isInvalid() {
        return this.icon == null;
    }

    public URL getUrl() {
        return this.url;
    }

    public URL getOrCreateUrl() {
        if (this.url != null) {
            return this.url;
        }
        this.createTempUrlAsNeeded();
        return this.tempUrl;
    }

    private void createTempUrlAsNeeded() {
        if (this.testUrl(this.tempUrl)) {
            return;
        }
        this.tempUrl = this.createTempUrl();
        if (this.tempUrl == null) {
            this.tempUrl = this.getDefaultUrl();
        }
    }

    private URL createTempUrl() {
        if (this.tempFileFailed) {
            return null;
        }
        try {
            File imageFile = File.createTempFile("temp.help.icon", null);
            imageFile.deleteOnExit();
            ImageUtils.writeFile(this.icon.getImage(), imageFile);
            return imageFile.toURI().toURL();
        }
        catch (IOException e) {
            this.tempFileFailed = true;
            Msg.error((Object)this, (Object)("Unable to write temp image to display in help for " + ResourceManager.getIconName(this.icon)));
            return null;
        }
    }

    private boolean testUrl(URL testUrl) {
        if (testUrl == null) {
            return false;
        }
        try {
            return new File(testUrl.toURI()).exists();
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    private URL getDefaultUrl() {
        return ResourceManager.getResource(Images.BOMB);
    }
}

