/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.exec.trace;

import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.pcode.exec.BytesPcodeArithmetic;
import ghidra.pcode.exec.PairedPcodeArithmetic;
import ghidra.pcode.exec.PcodeArithmetic;
import ghidra.pcode.exec.PcodeExecutor;
import ghidra.pcode.exec.PcodeExecutorState;
import ghidra.pcode.exec.PcodeExecutorStatePiece;
import ghidra.pcode.exec.SleighExpression;
import ghidra.pcode.exec.SleighProgramCompiler;
import ghidra.pcode.exec.trace.TraceBytesPcodeExecutorState;
import ghidra.pcode.exec.trace.TraceMemoryStatePcodeArithmetic;
import ghidra.pcode.utils.Utils;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.trace.model.Trace;
import ghidra.trace.model.memory.TraceMemorySpace;
import ghidra.trace.model.memory.TraceMemoryState;
import ghidra.trace.model.thread.TraceThread;
import java.math.BigInteger;
import java.util.Map;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public enum TraceSleighUtils {


    public static TraceMemorySpace getSpaceForExecution(AddressSpace space, Trace trace, TraceThread thread, int frame, boolean toWrite) {
        if (space.isRegisterSpace()) {
            if (thread == null) {
                throw new IllegalArgumentException("Cannot access register unless a thread is given.");
            }
            return trace.getMemoryManager().getMemoryRegisterSpace(thread, frame, toWrite);
        }
        return trace.getMemoryManager().getMemorySpace(space, toWrite);
    }

    public static PcodeExecutor<byte[]> buildByteExecutor(Trace trace, long snap, TraceThread thread, int frame) {
        TraceBytesPcodeExecutorState state = new TraceBytesPcodeExecutorState(trace, snap, thread, frame);
        Language language = trace.getBaseLanguage();
        if (!(language instanceof SleighLanguage)) {
            throw new IllegalArgumentException("Trace must use a SLEIGH language");
        }
        return new PcodeExecutor((SleighLanguage)language, (PcodeArithmetic)BytesPcodeArithmetic.forLanguage((Language)language), (PcodeExecutorStatePiece)state);
    }

    public static PcodeExecutor<Pair<byte[], TraceMemoryState>> buildByteWithStateExecutor(Trace trace, long snap, TraceThread thread, int frame) {
        TraceBytesPcodeExecutorState state = new TraceBytesPcodeExecutorState(trace, snap, thread, frame);
        PcodeExecutorState<Pair<byte[], TraceMemoryState>> paired = state.withMemoryState();
        Language language = trace.getBaseLanguage();
        if (!(language instanceof SleighLanguage)) {
            throw new IllegalArgumentException("Trace must use a SLEIGH language");
        }
        return new PcodeExecutor((SleighLanguage)language, (PcodeArithmetic)new PairedPcodeArithmetic((PcodeArithmetic)BytesPcodeArithmetic.forLanguage((Language)language), (PcodeArithmetic)TraceMemoryStatePcodeArithmetic.INSTANCE), paired);
    }

    public static byte[] evaluateBytes(SleighExpression expr, Trace trace, long snap, TraceThread thread, int frame) {
        SleighLanguage language = expr.getLanguage();
        if (trace.getBaseLanguage() != language) {
            throw new IllegalArgumentException("This expression can only be evaulated on traces with language " + language);
        }
        PcodeExecutor<byte[]> executor = TraceSleighUtils.buildByteExecutor(trace, snap, thread, frame);
        return (byte[])expr.evaluate(executor);
    }

    public static BigInteger evaluate(SleighExpression expr, Trace trace, long snap, TraceThread thread, int frame) {
        byte[] bytes = TraceSleighUtils.evaluateBytes(expr, trace, snap, thread, frame);
        return Utils.bytesToBigInteger((byte[])bytes, (int)bytes.length, (boolean)expr.getLanguage().isBigEndian(), (boolean)false);
    }

    public static Pair<byte[], TraceMemoryState> evaluateBytesWithState(SleighExpression expr, Trace trace, long snap, TraceThread thread, int frame) {
        SleighLanguage language = expr.getLanguage();
        if (trace.getBaseLanguage() != language) {
            throw new IllegalArgumentException("This expression can only be evaulated on traces with language " + language);
        }
        PcodeExecutor<Pair<byte[], TraceMemoryState>> executor = TraceSleighUtils.buildByteWithStateExecutor(trace, snap, thread, frame);
        return (Pair)expr.evaluate(executor);
    }

    public static Pair<BigInteger, TraceMemoryState> evaluateWithState(SleighExpression expr, Trace trace, long snap, TraceThread thread, int frame) {
        Pair<byte[], TraceMemoryState> bytesPair = TraceSleighUtils.evaluateBytesWithState(expr, trace, snap, thread, frame);
        byte[] bytes = (byte[])bytesPair.getLeft();
        return new ImmutablePair((Object)Utils.bytesToBigInteger((byte[])bytes, (int)bytes.length, (boolean)expr.getLanguage().isBigEndian(), (boolean)false), (Object)((TraceMemoryState)((Object)bytesPair.getRight())));
    }

    public static byte[] evaluateBytes(String expr, Trace trace, long snap, TraceThread thread, int frame) {
        Language language = trace.getBaseLanguage();
        if (!(language instanceof SleighLanguage)) {
            throw new IllegalArgumentException("Trace must use a sleigh-based language");
        }
        return TraceSleighUtils.evaluateBytes(SleighProgramCompiler.compileExpression((SleighLanguage)((SleighLanguage)language), (String)expr), trace, snap, thread, frame);
    }

    public static BigInteger evaluate(String expr, Trace trace, long snap, TraceThread thread, int frame) {
        Language language = trace.getBaseLanguage();
        if (!(language instanceof SleighLanguage)) {
            throw new IllegalArgumentException("Trace must use a sleigh-based language");
        }
        return TraceSleighUtils.evaluate(SleighProgramCompiler.compileExpression((SleighLanguage)((SleighLanguage)language), (String)expr), trace, snap, thread, frame);
    }

    public static Map.Entry<byte[], TraceMemoryState> evaluateBytesWithState(String expr, Trace trace, long snap, TraceThread thread, int frame) {
        Language language = trace.getBaseLanguage();
        if (!(language instanceof SleighLanguage)) {
            throw new IllegalArgumentException("Trace must use a sleigh-based language");
        }
        return TraceSleighUtils.evaluateBytesWithState(SleighProgramCompiler.compileExpression((SleighLanguage)((SleighLanguage)language), (String)expr), trace, snap, thread, frame);
    }

    public static Map.Entry<BigInteger, TraceMemoryState> evaluateWithState(String expr, Trace trace, long snap, TraceThread thread, int frame) {
        Language language = trace.getBaseLanguage();
        if (!(language instanceof SleighLanguage)) {
            throw new IllegalArgumentException("Trace must use a sleigh-based language");
        }
        return TraceSleighUtils.evaluateWithState(SleighProgramCompiler.compileExpression((SleighLanguage)((SleighLanguage)language), (String)expr), trace, snap, thread, frame);
    }
}

