/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.memory;

import com.google.common.collect.Range;
import db.DBHandle;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSpace;
import ghidra.trace.database.listing.DBTraceCodeRegisterSpace;
import ghidra.trace.database.memory.DBTraceMemoryManager;
import ghidra.trace.database.memory.DBTraceMemoryRegion;
import ghidra.trace.database.memory.DBTraceMemorySpace;
import ghidra.trace.database.space.AbstractDBTraceSpaceBasedManager;
import ghidra.trace.database.thread.DBTraceThread;
import ghidra.trace.model.memory.TraceMemoryFlag;
import ghidra.trace.model.memory.TraceMemoryRegisterSpace;
import ghidra.trace.model.memory.TraceOverlappedRegionException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.VersionException;
import java.io.IOException;
import javax.help.UnsupportedOperationException;

public class DBTraceMemoryRegisterSpace
extends DBTraceMemorySpace
implements TraceMemoryRegisterSpace {
    protected final DBTraceThread thread;
    private final int frameLevel;

    public DBTraceMemoryRegisterSpace(DBTraceMemoryManager manager, DBHandle dbh, AddressSpace space, AbstractDBTraceSpaceBasedManager.DBTraceSpaceEntry ent, DBTraceThread thread) throws IOException, VersionException {
        super(manager, dbh, space, ent);
        this.thread = thread;
        this.frameLevel = ent.getFrameLevel();
    }

    @Override
    public DBTraceThread getThread() {
        return this.thread;
    }

    @Override
    public int getFrameLevel() {
        return this.frameLevel;
    }

    @Override
    public DBTraceCodeRegisterSpace getCodeSpace(boolean createIfAbsent) {
        return this.trace.getCodeManager().getCodeRegisterSpace(this.thread, this.frameLevel, createIfAbsent);
    }

    @Override
    public DBTraceMemoryRegion addRegion(String name, Range<Long> lifespan, AddressRange range, TraceMemoryFlag ... flags) throws TraceOverlappedRegionException, DuplicateNameException {
        throw new UnsupportedOperationException();
    }
}

