/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.module;

import com.google.common.collect.Range;
import db.DBRecord;
import ghidra.program.model.address.AddressSpace;
import ghidra.trace.database.DBTraceUtils;
import ghidra.trace.database.map.DBTraceAddressSnapRangePropertyMapTree;
import ghidra.trace.database.module.DBTraceModule;
import ghidra.trace.database.module.DBTraceModuleSpace;
import ghidra.trace.model.Trace;
import ghidra.trace.model.modules.TraceSection;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.util.LockHold;
import ghidra.util.database.DBCachedObjectStore;
import ghidra.util.database.DBObjectColumn;
import ghidra.util.database.annot.DBAnnotatedColumn;
import ghidra.util.database.annot.DBAnnotatedField;
import ghidra.util.database.annot.DBAnnotatedObjectInfo;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.locks.Lock;

@DBAnnotatedObjectInfo(version=0)
public class DBTraceSection
extends DBTraceAddressSnapRangePropertyMapTree.AbstractDBTraceAddressSnapRangePropertyMapData<DBTraceSection>
implements TraceSection {
    private static final String TABLE_NAME = "Sections";
    static final String MODULE_COLUMN_NAME = "Module";
    static final String PATH_COLUMN_NAME = "Path";
    static final String NAME_COLUMN_NAME = "Name";
    @DBAnnotatedColumn(value="Module")
    static DBObjectColumn MODULE_COLUMN;
    @DBAnnotatedColumn(value="Path")
    static DBObjectColumn PATH_COLUMN;
    @DBAnnotatedColumn(value="Name")
    static DBObjectColumn NAME_COLUMN;
    @DBAnnotatedField(column="Module", indexed=true)
    private long moduleKey;
    @DBAnnotatedField(column="Path", indexed=true)
    private String path;
    @DBAnnotatedField(column="Name")
    private String name;
    final DBTraceModuleSpace space;
    private DBTraceModule module;

    static String tableName(AddressSpace space) {
        return DBTraceUtils.tableName(TABLE_NAME, space, -1L, 0);
    }

    public DBTraceSection(DBTraceModuleSpace space, DBTraceAddressSnapRangePropertyMapTree<DBTraceSection, ?> tree, DBCachedObjectStore<?> store, DBRecord record) {
        super(tree, store, record);
        this.space = space;
    }

    protected void setRecordValue(DBTraceSection value) {
    }

    protected DBTraceSection getRecordValue() {
        return this;
    }

    @Override
    protected void fresh(boolean created) throws IOException {
        super.fresh(created);
        if (created) {
            return;
        }
        this.module = this.space.doGetModuleById(this.moduleKey);
    }

    void set(DBTraceModule module, String path, String name) {
        this.moduleKey = module.getKey();
        this.path = path;
        this.name = name;
        this.update(MODULE_COLUMN, PATH_COLUMN, NAME_COLUMN);
        this.module = module;
    }

    @Override
    public Trace getTrace() {
        return this.space.trace;
    }

    @Override
    public DBTraceModule getModule() {
        return this.module;
    }

    @Override
    protected void doSetLifespan(Range<Long> lifespan) {
        super.doSetLifespan(lifespan);
    }

    @Override
    public String getPath() {
        try (LockHold hold = LockHold.lock((Lock)this.space.lock.readLock());){
            String string = this.path;
            return string;
        }
    }

    @Override
    public void setName(String name) throws DuplicateNameException {
        try (LockHold hold = LockHold.lock((Lock)this.space.lock.writeLock());){
            if (Objects.equals(this.name, name)) {
                return;
            }
            DBTraceSection exists = this.space.manager.doGetSectionByName(this.moduleKey, name);
            if (exists != null) {
                throw new DuplicateNameException(name + " (in " + this.module + ")");
            }
            this.name = name;
            this.update(NAME_COLUMN);
            this.module.space.trace.setChanged(new TraceChangeRecord(Trace.TraceSectionChangeType.CHANGED, null, this));
        }
    }

    @Override
    public String getName() {
        try (LockHold hold = LockHold.lock((Lock)this.space.lock.readLock());){
            String string = this.name;
            return string;
        }
    }

    @Override
    public void delete() {
        this.space.sectionMapSpace.deleteData(this);
        this.space.trace.setChanged(new TraceChangeRecord(Trace.TraceSectionChangeType.DELETED, null, this));
    }
}

