/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.datatree;

import docking.DockingUtils;
import docking.actions.KeyBindingUtils;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import ghidra.framework.main.FrontEndTool;
import ghidra.framework.main.datatree.DataTreeDragNDropHandler;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.tree.TreePath;

public class DataTree
extends GTree {
    private boolean isActive;
    private DataTreeDragNDropHandler dragNDropHandler;

    DataTree(FrontEndTool tool, GTreeNode root) {
        super(root);
        this.setName("Data Tree");
        this.setShowsRootHandles(true);
        ToolTipManager.sharedInstance().registerComponent((JComponent)((Object)this));
        if (tool != null) {
            this.dragNDropHandler = new DataTreeDragNDropHandler(tool, this, this.isActive);
            this.setDragNDropHandler(this.dragNDropHandler);
        }
        this.initializeKeyEvents();
    }

    private void initializeKeyEvents() {
        KeyBindingUtils.clearKeyBinding((JComponent)this.getJTree(), (KeyStroke)KeyStroke.getKeyStroke(67, DockingUtils.CONTROL_KEY_MODIFIER_MASK));
        KeyBindingUtils.clearKeyBinding((JComponent)this.getJTree(), (KeyStroke)KeyStroke.getKeyStroke(86, DockingUtils.CONTROL_KEY_MODIFIER_MASK));
        KeyBindingUtils.clearKeyBinding((JComponent)this.getJTree(), (KeyStroke)KeyStroke.getKeyStroke(88, DockingUtils.CONTROL_KEY_MODIFIER_MASK));
    }

    void setProjectActive(boolean isActive) {
        if (this.dragNDropHandler != null) {
            this.dragNDropHandler.setProjectActive(isActive);
        }
    }

    public void clearSelection() {
        this.getJTree().clearSelection();
    }

    public int getSelectionCount() {
        return this.getJTree().getSelectionCount();
    }

    public GTreeNode getLastSelectedPathComponent() {
        return (GTreeNode)this.getJTree().getLastSelectedPathComponent();
    }

    public void removeSelectionPath(TreePath path) {
        this.getJTree().removeSelectionPath(path);
    }

    public void stopEditing() {
        this.getJTree().stopEditing();
    }
}

