/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.plugintool.dialog;

import docking.DockingUtils;
import docking.KeyEntryTextField;
import docking.Tool;
import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import docking.actions.KeyBindingUtils;
import docking.help.Help;
import docking.help.HelpService;
import docking.widgets.EmptyBorderButton;
import docking.widgets.MultiLineLabel;
import docking.widgets.OptionDialog;
import docking.widgets.label.GIconLabel;
import docking.widgets.table.AbstractSortedTableModel;
import docking.widgets.table.GTable;
import docking.widgets.table.GTableFilterPanel;
import docking.widgets.table.RowObjectTableModel;
import ghidra.framework.options.Options;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.HTMLUtilities;
import ghidra.util.ReservedKeyBindings;
import ghidra.util.Swing;
import ghidra.util.exception.AssertException;
import ghidra.util.layout.PairLayout;
import ghidra.util.layout.VerticalLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import resources.Icons;
import resources.ResourceManager;

public class KeyBindingsPanel
extends JPanel {
    private static final int STATUS_LABEL_HEIGHT = 60;
    private static final int ACTION_NAME = 0;
    private static final int KEY_BINDING = 1;
    private static final int PLUGIN_NAME = 2;
    private static final int FONT_SIZE = 11;
    private JTextPane statusLabel;
    private GTable actionTable;
    private JPanel infoPanel;
    private MultiLineLabel collisionLabel;
    private KeyBindingsTableModel tableModel;
    private ListSelectionModel selectionModel;
    private Options options;
    private Map<String, List<DockingActionIf>> actionsByFullName;
    private Map<String, List<String>> actionNamesByKeyStroke = new HashMap<String, List<String>>();
    private Map<String, KeyStroke> keyStrokesByFullName = new HashMap<String, KeyStroke>();
    private Map<String, KeyStroke> originalValues = new HashMap<String, KeyStroke>();
    private List<DockingActionIf> tableActions = new ArrayList<DockingActionIf>();
    private KeyEntryTextField ksField;
    private boolean unappliedChanges;
    private PluginTool tool;
    private boolean firingTableDataChanged;
    private PropertyChangeListener propertyChangeListener;
    private GTableFilterPanel<DockingActionIf> tableFilterPanel;
    private EmptyBorderButton helpButton;

    public KeyBindingsPanel(PluginTool tool, Options options) {
        this.tool = tool;
        this.options = options;
        this.createPanelComponents();
        this.createActionMap();
        this.addListeners();
    }

    public void setOptionsPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeListener = listener;
    }

    public void dispose() {
        this.tableFilterPanel.dispose();
        this.propertyChangeListener = null;
    }

    public void apply() {
        for (String actionName : this.keyStrokesByFullName.keySet()) {
            KeyStroke currentKeyStroke = this.keyStrokesByFullName.get(actionName);
            KeyStroke originalKeyStroke = this.originalValues.get(actionName);
            this.updateOptions(actionName, originalKeyStroke, currentKeyStroke);
        }
        this.changesMade(false);
    }

    private void updateOptions(String fullActionName, KeyStroke currentKeyStroke, KeyStroke newKeyStroke) {
        if (Objects.equals(currentKeyStroke, newKeyStroke)) {
            return;
        }
        this.options.setKeyStroke(fullActionName, newKeyStroke);
        this.originalValues.put(fullActionName, newKeyStroke);
        this.keyStrokesByFullName.put(fullActionName, newKeyStroke);
        List<DockingActionIf> actions = this.actionsByFullName.get(fullActionName);
        for (DockingActionIf action : actions) {
            action.setUnvalidatedKeyBindingData(new KeyBindingData(newKeyStroke));
        }
    }

    public void cancel() {
        for (String actionName : this.originalValues.keySet()) {
            KeyStroke originalKS = this.originalValues.get(actionName);
            KeyStroke modifiedKS = this.keyStrokesByFullName.get(actionName);
            if (modifiedKS == null || modifiedKS.equals(originalKS)) continue;
            this.keyStrokesByFullName.put(actionName, originalKS);
        }
        this.tableModel.fireTableDataChanged();
    }

    public void reload() {
        Swing.runLater(() -> {
            this.actionTable.clearSelection();
            this.restoreDefaultKeybindings();
        });
    }

    private void createActionMap() {
        String longestName = "";
        this.actionsByFullName = KeyBindingUtils.getAllActionsByFullName((Tool)this.tool);
        Set<Map.Entry<String, List<DockingActionIf>>> entries = this.actionsByFullName.entrySet();
        for (Map.Entry<String, List<DockingActionIf>> entry : entries) {
            List<DockingActionIf> actions = entry.getValue();
            DockingActionIf action = actions.get(0);
            this.tableActions.add(action);
            String actionName = entry.getKey();
            KeyStroke ks = this.options.getKeyStroke(actionName, null);
            this.keyStrokesByFullName.put(actionName, ks);
            this.addToKeyMap(ks, actionName);
            this.originalValues.put(actionName, ks);
            String shortName = action.getName();
            if (shortName.length() <= longestName.length()) continue;
            longestName = shortName;
        }
        Font f = this.actionTable.getFont();
        FontMetrics fm = this.actionTable.getFontMetrics(f);
        int maxWidth = 0;
        for (int i = 0; i < longestName.length(); ++i) {
            char c = longestName.charAt(i);
            maxWidth += fm.charWidth(c);
        }
        TableColumn col = this.actionTable.getColumnModel().getColumn(0);
        col.setPreferredWidth(maxWidth);
        this.tableModel.fireTableDataChanged();
    }

    private void createPanelComponents() {
        this.setLayout(new BorderLayout(10, 10));
        this.tableModel = new KeyBindingsTableModel();
        this.actionTable = new GTable((TableModel)((Object)this.tableModel));
        JScrollPane sp = new JScrollPane((Component)this.actionTable);
        this.actionTable.setPreferredScrollableViewportSize(new Dimension(400, 100));
        this.actionTable.setSelectionMode(0);
        this.actionTable.setHTMLRenderingEnabled(true);
        this.adjustTableColumns();
        JPanel importExportPanel = this.createImportExportPanel();
        this.tableFilterPanel = new GTableFilterPanel((JTable)this.actionTable, (RowObjectTableModel)this.tableModel);
        JPanel middlePanel = new JPanel(new BorderLayout());
        middlePanel.add((Component)this.tableFilterPanel, "North");
        middlePanel.add((Component)importExportPanel, "South");
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.add((Component)sp, "Center");
        centerPanel.add((Component)middlePanel, "South");
        JPanel keyPanel = this.createKeyEntryPanel();
        JPanel statusPanel = this.createStatusPanel(keyPanel);
        this.add((Component)centerPanel, "Center");
        this.add((Component)statusPanel, "South");
    }

    private JPanel createStatusPanel(JPanel keyPanel) {
        this.statusLabel = new JTextPane();
        this.statusLabel.setEnabled(false);
        DockingUtils.setTransparent((JComponent)this.statusLabel);
        this.statusLabel.setBorder(BorderFactory.createEmptyBorder(5, 10, 0, 5));
        this.statusLabel.setContentType("text/html");
        this.statusLabel.setPreferredSize(new Dimension(0, 60));
        Font f = new Font("SansSerif", 0, 11);
        this.statusLabel.setFont(f);
        this.helpButton = new EmptyBorderButton((Icon)Icons.HELP_ICON);
        this.helpButton.setEnabled(false);
        this.helpButton.addActionListener(e -> {
            DockingActionIf action = this.getSelectedAction();
            HelpService hs = Help.getHelpService();
            hs.showHelp((Object)action, false, (Component)this);
        });
        JPanel helpButtonPanel = new JPanel();
        helpButtonPanel.setLayout(new BoxLayout(helpButtonPanel, 3));
        helpButtonPanel.add((Component)this.helpButton);
        helpButtonPanel.add(Box.createVerticalGlue());
        JPanel lowerStatusPanel = new JPanel();
        lowerStatusPanel.setLayout(new BoxLayout(lowerStatusPanel, 0));
        lowerStatusPanel.add(helpButtonPanel);
        lowerStatusPanel.add(this.statusLabel);
        JPanel panel = new JPanel((LayoutManager)new VerticalLayout(5));
        panel.add(keyPanel);
        panel.add(lowerStatusPanel);
        return panel;
    }

    private JPanel createKeyEntryPanel() {
        this.ksField = new KeyEntryTextField(20, keyStroke -> this.processKeyStrokeEntry(keyStroke));
        JPanel p = new JPanel(new FlowLayout(0));
        p.add((Component)this.ksField);
        JPanel keyPanel = new JPanel(new BorderLayout());
        JPanel defaultPanel = new JPanel(new BorderLayout());
        MultiLineLabel mlabel = new MultiLineLabel("To add or change a key binding, select an action\nand type any key combination\n \nTo remove a key binding, select an action and\npress <Enter> or <Backspace>");
        JPanel labelPanel = new JPanel();
        labelPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 0));
        BoxLayout bl = new BoxLayout(labelPanel, 0);
        labelPanel.setLayout(bl);
        labelPanel.add(Box.createHorizontalStrut(5));
        labelPanel.add((Component)new GIconLabel((Icon)ResourceManager.loadImage((String)"images/information.png")));
        labelPanel.add(Box.createHorizontalStrut(5));
        labelPanel.add((Component)mlabel);
        defaultPanel.add((Component)labelPanel, "North");
        defaultPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.infoPanel = new JPanel(new FlowLayout(1));
        this.collisionLabel = new MultiLineLabel(" ");
        this.collisionLabel.setName("CollisionLabel");
        this.infoPanel.add((Component)this.collisionLabel);
        JScrollPane sp = new JScrollPane(this.infoPanel);
        sp.setPreferredSize(defaultPanel.getPreferredSize());
        JPanel innerPanel = new JPanel((LayoutManager)new PairLayout(2, 6));
        innerPanel.add(defaultPanel);
        innerPanel.add(sp);
        keyPanel.add((Component)innerPanel, "Center");
        keyPanel.add((Component)p, "South");
        return keyPanel;
    }

    private JPanel createImportExportPanel() {
        JButton importButton = new JButton("Import...");
        importButton.setToolTipText("Load key binding settings from a file");
        importButton.addActionListener(event -> {
            boolean continueImport = this.showImportPrompt();
            if (!continueImport) {
                return;
            }
            Swing.runLater(() -> {
                this.actionTable.clearSelection();
                this.processKeyBindingsFromOptions((Options)KeyBindingUtils.importKeyBindings());
            });
        });
        JButton exportButton = new JButton("Export...");
        exportButton.setToolTipText("Save key binding settings to a file");
        exportButton.addActionListener(event -> {
            boolean continueExport = this.showExportPrompt();
            if (!continueExport) {
                return;
            }
            Swing.runLater(() -> {
                ToolOptions keyBindingOptions = this.tool.getOptions("Key Bindings");
                KeyBindingUtils.exportKeyBindings((ToolOptions)keyBindingOptions);
            });
        });
        JPanel containerPanel = new JPanel(new FlowLayout(2));
        containerPanel.add(importButton);
        containerPanel.add(exportButton);
        return containerPanel;
    }

    private boolean showExportPrompt() {
        boolean continueOperation = true;
        if (this.unappliedChanges) {
            int userChoice = OptionDialog.showYesNoCancelDialog((Component)this, (String)"Apply Changes?", (String)"Apply current key binding changes?");
            if (userChoice == 1) {
                this.apply();
            } else if (userChoice == 0) {
                continueOperation = false;
            }
        }
        return continueOperation;
    }

    private boolean showImportPrompt() {
        int userChoice = OptionDialog.showYesNoDialog((Component)this, (String)"Continue Import?", (String)"Importing key bindings will overwrite the current settings.\nDo you want to continue?");
        return userChoice == 1;
    }

    private Map<String, KeyStroke> createActionNameToKeyStrokeMap(Options keyBindingOptions) {
        HashMap<String, KeyStroke> localActionMap = new HashMap<String, KeyStroke>();
        List optionNames = keyBindingOptions.getOptionNames();
        for (String element : optionNames) {
            KeyStroke newKeyStroke = keyBindingOptions.getKeyStroke(element, null);
            localActionMap.put(element, newKeyStroke);
        }
        return localActionMap;
    }

    private void adjustTableColumns() {
        this.actionTable.doLayout();
        TableColumn column = this.actionTable.getColumn((Object)this.actionTable.getColumnName(0));
        column.setPreferredWidth(250);
        column = this.actionTable.getColumn((Object)this.actionTable.getColumnName(1));
        column.setPreferredWidth(100);
        column = this.actionTable.getColumn((Object)this.actionTable.getColumnName(2));
        column.setPreferredWidth(150);
    }

    private void restoreDefaultKeybindings() {
        for (String actionName : this.keyStrokesByFullName.keySet()) {
            List<DockingActionIf> actions = this.actionsByFullName.get(actionName);
            if (actions.isEmpty()) {
                throw new AssertException("No actions defined for " + actionName);
            }
            DockingActionIf action = actions.get(0);
            KeyStroke currentKeyStroke = this.keyStrokesByFullName.get(actionName);
            KeyBindingData defaultBinding = action.getDefaultKeyBindingData();
            KeyStroke newKeyStroke = defaultBinding == null ? null : defaultBinding.getKeyBinding();
            this.updateOptions(actionName, currentKeyStroke, newKeyStroke);
        }
        this.tableModel.fireTableDataChanged();
    }

    private void addListeners() {
        this.selectionModel = this.actionTable.getSelectionModel();
        this.selectionModel.addListSelectionListener(new TableSelectionListener());
    }

    private boolean checkAction(String actionName, KeyStroke keyStroke) {
        String ksName = KeyEntryTextField.parseKeyStroke((KeyStroke)keyStroke);
        KeyStroke oldKs = this.keyStrokesByFullName.get(actionName);
        if (oldKs != null) {
            String oldName = KeyEntryTextField.parseKeyStroke((KeyStroke)oldKs);
            if (oldName.equals(ksName)) {
                return false;
            }
            this.removeFromKeyMap(oldKs, actionName);
        }
        this.addToKeyMap(keyStroke, actionName);
        this.keyStrokesByFullName.put(actionName, keyStroke);
        this.changesMade(true);
        return true;
    }

    private void changesMade(boolean changes) {
        this.propertyChangeListener.propertyChange(new PropertyChangeEvent(this, "apply.enabled", this.unappliedChanges, changes));
        this.unappliedChanges = changes;
    }

    private DockingActionIf getSelectedAction() {
        if (this.selectionModel.isSelectionEmpty()) {
            return null;
        }
        int selectedRow = this.actionTable.getSelectedRow();
        int modelRow = this.tableFilterPanel.getModelRow(selectedRow);
        return this.tableActions.get(modelRow);
    }

    private String getSelectedActionName() {
        DockingActionIf action = this.getSelectedAction();
        if (action == null) {
            return null;
        }
        return action.getFullName();
    }

    private void addToKeyMap(KeyStroke ks, String actionName) {
        if (ks == null) {
            return;
        }
        String ksName = KeyEntryTextField.parseKeyStroke((KeyStroke)ks);
        List<String> list = this.actionNamesByKeyStroke.get(ksName);
        if (list == null) {
            list = new ArrayList<String>();
            this.actionNamesByKeyStroke.put(ksName, list);
        }
        if (!list.contains(actionName)) {
            list.add(actionName);
        }
    }

    private void removeFromKeyMap(KeyStroke ks, String actionName) {
        if (ks == null) {
            return;
        }
        String ksName = KeyEntryTextField.parseKeyStroke((KeyStroke)ks);
        List<String> list = this.actionNamesByKeyStroke.get(ksName);
        if (list != null) {
            list.remove(actionName);
            if (list.isEmpty()) {
                this.actionNamesByKeyStroke.remove(ksName);
            }
        }
    }

    private void showActionsMappedToKeyStroke(String ksName) {
        List<String> list = this.actionNamesByKeyStroke.get(ksName);
        if (list == null) {
            return;
        }
        if (list.size() > 0) {
            StringBuffer sb = new StringBuffer();
            sb.append("Actions mapped to key " + ksName + ":\n");
            for (int i = 0; i < list.size(); ++i) {
                sb.append("  ");
                sb.append(list.get(i));
                if (i >= list.size() - 1) continue;
                sb.append("\n");
            }
            this.updateInfoPanel(sb.toString());
        } else {
            this.clearInfoPanel();
        }
    }

    private void clearInfoPanel() {
        this.updateInfoPanel(" ");
    }

    private void updateInfoPanel(String text) {
        this.infoPanel.removeAll();
        this.infoPanel.repaint();
        this.collisionLabel = new MultiLineLabel(text);
        this.collisionLabel.setName("CollisionLabel");
        this.infoPanel.add((Component)this.collisionLabel);
        this.infoPanel.invalidate();
        this.validate();
    }

    private void processKeyBindingsFromOptions(Options keyBindingOptions) {
        if (keyBindingOptions == null) {
            return;
        }
        Map<String, KeyStroke> keyBindingsMap = this.createActionNameToKeyStrokeMap(keyBindingOptions);
        if (keyBindingsMap == null) {
            return;
        }
        boolean changes = false;
        for (String name : keyBindingsMap.keySet()) {
            KeyStroke keyStroke = keyBindingsMap.get(name);
            keyStroke = KeyBindingUtils.validateKeyStroke((KeyStroke)keyStroke);
            if (!this.keyStrokesByFullName.containsKey(name)) continue;
            changes |= this.processKeyStroke(name, keyStroke);
        }
        if (changes) {
            this.changesMade(true);
        }
    }

    private void processKeyStrokeEntry(KeyStroke ks) {
        this.clearInfoPanel();
        if (this.selectionModel.isSelectionEmpty()) {
            this.statusLabel.setText("No action is selected.");
            return;
        }
        if (ks != null && ReservedKeyBindings.isReservedKeystroke((KeyStroke)ks)) {
            this.statusLabel.setText(KeyEntryTextField.parseKeyStroke((KeyStroke)ks) + " is a reserved keystroke");
            this.ksField.clearField();
            return;
        }
        String selectedActionName = this.getSelectedActionName();
        if (selectedActionName != null && this.processKeyStroke(selectedActionName, ks)) {
            String keyStrokeText = KeyEntryTextField.parseKeyStroke((KeyStroke)ks);
            this.showActionsMappedToKeyStroke(keyStrokeText);
            this.tableModel.fireTableDataChanged();
        }
    }

    private boolean processKeyStroke(String actionName, KeyStroke keyStroke) {
        if (keyStroke == null) {
            this.removeKeystroke(actionName);
        } else {
            char keyChar = keyStroke.getKeyChar();
            if (Character.isWhitespace(keyChar) || Character.getType(keyChar) == 15) {
                this.removeKeystroke(actionName);
            } else {
                return this.checkAction(actionName, keyStroke);
            }
        }
        return false;
    }

    private void removeKeystroke(String selectedActionName) {
        this.ksField.setText("");
        if (this.keyStrokesByFullName.containsKey(selectedActionName)) {
            KeyStroke stroke = this.keyStrokesByFullName.get(selectedActionName);
            if (stroke == null) {
                return;
            }
            this.removeFromKeyMap(stroke, selectedActionName);
            this.keyStrokesByFullName.put(selectedActionName, null);
            this.tableModel.fireTableDataChanged();
            this.changesMade(true);
        }
    }

    Map<String, KeyStroke> getKeyStrokeMap() {
        return this.keyStrokesByFullName;
    }

    private class KeyBindingsTableModel
    extends AbstractSortedTableModel<DockingActionIf> {
        private final String[] columnNames;

        KeyBindingsTableModel() {
            super(0);
            this.columnNames = new String[]{"Action Name", "KeyBinding", "Plugin Name"};
        }

        public String getName() {
            return "Keybindings";
        }

        public Object getColumnValueForRow(DockingActionIf action, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return action.getName();
                }
                case 1: {
                    KeyStroke ks = KeyBindingsPanel.this.keyStrokesByFullName.get(action.getFullName());
                    if (ks != null) {
                        return KeyEntryTextField.parseKeyStroke((KeyStroke)ks);
                    }
                    return "";
                }
                case 2: {
                    return action.getOwnerDescription();
                }
            }
            return "Unknown Column!";
        }

        public List<DockingActionIf> getModelData() {
            return KeyBindingsPanel.this.tableActions;
        }

        public boolean isSortable(int columnIndex) {
            return true;
        }

        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return KeyBindingsPanel.this.tableActions.size();
        }

        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }
    }

    private class TableSelectionListener
    implements ListSelectionListener {
        private TableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting() || KeyBindingsPanel.this.firingTableDataChanged) {
                return;
            }
            KeyBindingsPanel.this.helpButton.setEnabled(false);
            String fullActionName = KeyBindingsPanel.this.getSelectedActionName();
            if (fullActionName == null) {
                KeyBindingsPanel.this.statusLabel.setText("");
                return;
            }
            KeyBindingsPanel.this.helpButton.setEnabled(true);
            KeyStroke ks = KeyBindingsPanel.this.keyStrokesByFullName.get(fullActionName);
            String ksName = "";
            KeyBindingsPanel.this.clearInfoPanel();
            if (ks != null) {
                ksName = KeyEntryTextField.parseKeyStroke((KeyStroke)ks);
                KeyBindingsPanel.this.showActionsMappedToKeyStroke(ksName);
            }
            KeyBindingsPanel.this.ksField.setText(ksName);
            KeyBindingsPanel.this.statusLabel.setPreferredSize(new Dimension(KeyBindingsPanel.this.statusLabel.getPreferredSize().width, 60));
            List<DockingActionIf> actions = KeyBindingsPanel.this.actionsByFullName.get(fullActionName);
            DockingActionIf action = actions.get(0);
            String description = action.getDescription();
            if (description == null || description.trim().isEmpty()) {
                description = action.getName();
            }
            KeyBindingsPanel.this.statusLabel.setText("<html>" + HTMLUtilities.escapeHTML((String)description));
        }
    }
}

