/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.plugintool.dialog;

import docking.ActionContext;
import docking.DialogComponentProvider;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.action.ToolBarData;
import docking.widgets.OptionDialog;
import ghidra.framework.main.AppInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.dialog.PluginManagerComponent;
import ghidra.util.HelpLocation;
import ghidra.util.classfinder.ClassSearcher;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import resources.ResourceManager;

public class ManagePluginsDialog
extends DialogComponentProvider
implements ChangeListener {
    private PluginTool tool;
    private boolean isNewTool;
    private DockingAction saveAction;
    private DockingAction saveAsAction;
    private DockingAction configureAllPluginsAction;
    private PluginManagerComponent comp;

    public ManagePluginsDialog(PluginTool tool, boolean addSaveActions, boolean isNewTool) {
        super("Configure Tool", false, true, true, true);
        this.tool = tool;
        this.isNewTool = isNewTool;
        ClassSearcher.addChangeListener((ChangeListener)this);
        this.comp = new PluginManagerComponent(tool);
        JScrollPane scrollPane = new JScrollPane(this.comp);
        scrollPane.getViewport().setBackground(Color.white);
        scrollPane.getViewport().setViewPosition(new Point(0, 0));
        this.addWorkPanel(scrollPane);
        this.createActions(addSaveActions);
        if (tool == AppInfo.getFrontEndTool()) {
            this.setHelpLocation(new HelpLocation("FrontEndPlugin", "Configure"));
        } else {
            this.setHelpLocation(new HelpLocation("Tool", "Configure_Tool"));
        }
        this.setRememberSize(false);
        JButton doneButton = new JButton("Close");
        doneButton.addActionListener(e -> this.close());
        this.addButton(doneButton);
    }

    DockingAction getSaveAction() {
        return this.saveAction;
    }

    DockingAction getSaveAsAction() {
        return this.saveAsAction;
    }

    protected void escapeCallback() {
        if (this.isNewTool && this.tool.hasConfigChanged()) {
            String title = "New Tool Not Saved";
            String message = "New Tool has not been saved to your Tool Chest.";
            int result = OptionDialog.showOptionDialog((Component)this.rootPanel, (String)title, (String)(message + "\nDo you want to save it now?"), (String)"&Yes", (String)"&No", (int)3);
            if (result == 0) {
                return;
            }
            if (result == 1) {
                this.save();
            }
        }
        ClassSearcher.removeChangeListener((ChangeListener)this);
        this.close();
    }

    private void createActions(boolean addSaveActions) {
        this.configureAllPluginsAction = new DockingAction("Configure All Plugins", "Tool"){

            public void actionPerformed(ActionContext context) {
                ManagePluginsDialog.this.comp.manageAllPlugins();
            }
        };
        ImageIcon icon = ResourceManager.loadImage((String)"images/plugin.png");
        this.configureAllPluginsAction.setToolBarData(new ToolBarData((Icon)icon, "aaa"));
        this.configureAllPluginsAction.setDescription("Configure All Plugins");
        this.configureAllPluginsAction.setHelpLocation(new HelpLocation("Tool", "ConfigureAllPlugins"));
        this.addAction((DockingActionIf)this.configureAllPluginsAction);
        if (addSaveActions) {
            this.saveAction = new DockingAction("Save New Tool", "Tool"){

                public void actionPerformed(ActionContext context) {
                    ManagePluginsDialog.this.save();
                }
            };
            this.saveAction.setEnabled(this.tool.hasConfigChanged());
            icon = ResourceManager.loadImage((String)"images/disk.png");
            String saveGroup = "save";
            this.saveAction.setMenuBarData(new MenuData(new String[]{"Save"}, (Icon)icon, saveGroup));
            this.saveAction.setToolBarData(new ToolBarData((Icon)icon, saveGroup));
            this.saveAction.setHelpLocation(new HelpLocation("Tool", "SaveTool"));
            this.saveAction.setDescription("Save tool to tool chest");
            this.addAction((DockingActionIf)this.saveAction);
            this.saveAsAction = new DockingAction("Save New Tool As", "Tool"){

                public void actionPerformed(ActionContext context) {
                    ManagePluginsDialog.this.saveAs();
                }
            };
            this.saveAsAction.setEnabled(true);
            icon = ResourceManager.loadImage((String)"images/disk_save_as.png");
            this.saveAsAction.setMenuBarData(new MenuData(new String[]{"Save As..."}, (Icon)icon, saveGroup));
            this.saveAsAction.setToolBarData(new ToolBarData((Icon)icon, saveGroup));
            this.saveAsAction.setHelpLocation(new HelpLocation("Tool", "SaveTool"));
            this.saveAsAction.setDescription("Save tool to new name in tool chest");
            this.addAction((DockingActionIf)this.saveAsAction);
        }
    }

    private void save() {
        if (this.isNewTool) {
            this.saveAs();
        } else {
            this.tool.getToolServices().saveTool(this.tool);
            this.saveAction.setEnabled(false);
        }
    }

    private void saveAs() {
        this.tool.saveToolAs();
        this.saveAction.setEnabled(this.tool.hasConfigChanged());
        this.isNewTool = false;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
    }

    public void stateChanged() {
        if (this.saveAction != null) {
            this.saveAction.setEnabled(this.tool.hasConfigChanged());
        }
    }
}

