/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.plugintool.mgr;

import db.TerminatedTransactionException;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.model.AbortedTransactionListener;
import ghidra.framework.model.DomainObjectException;
import ghidra.framework.model.DomainObjectLockedException;
import ghidra.framework.model.UndoableDomainObject;
import ghidra.framework.plugintool.mgr.ToolTaskManager;
import ghidra.util.Msg;
import ghidra.util.TaskUtilities;
import ghidra.util.exception.ClosedException;
import ghidra.util.exception.RollbackException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.rmi.ConnectException;

class BackgroundCommandTask
extends Task
implements AbortedTransactionListener {
    private BackgroundCommand cmd;
    private ToolTaskManager taskMgr;
    private UndoableDomainObject obj;
    private TaskMonitor taskMonitor;
    private boolean doneQueueProcessing;

    public BackgroundCommandTask(ToolTaskManager taskMgr, UndoableDomainObject obj, BackgroundCommand cmd) {
        super(cmd.getName(), cmd.canCancel(), cmd.hasProgress(), cmd.isModal());
        this.cmd = cmd;
        this.taskMgr = taskMgr;
        this.obj = obj;
    }

    public UndoableDomainObject getDomainObject() {
        return this.obj;
    }

    public BackgroundCommand getCommand() {
        return this.cmd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(TaskMonitor monitor) {
        int id;
        TaskUtilities.addTrackedTask((Task)this, (TaskMonitor)monitor);
        this.taskMonitor = monitor;
        try {
            id = this.obj.startTransaction(this.cmd.getName(), this);
        }
        catch (Throwable t) {
            Msg.error((Object)this, (Object)"Transaction error", (Throwable)t);
            monitor.cancel();
            ToolTaskManager toolTaskManager = this.taskMgr;
            synchronized (toolTaskManager) {
                this.doneQueueProcessing = true;
                this.taskMgr.clearTasks(this.obj);
                this.taskMgr.taskFailed(this.obj, this.cmd, monitor);
            }
            return;
        }
        finally {
            ToolTaskManager toolTaskManager = this.taskMgr;
            synchronized (toolTaskManager) {
                this.taskMgr.notifyAll();
            }
        }
        boolean success = false;
        boolean commit = true;
        try {
            success = this.cmd.applyTo(this.obj, monitor);
            if (success) {
                this.taskMgr.taskCompleted(this.obj, this, monitor);
            }
        }
        catch (Throwable t) {
            ToolTaskManager cause = this.taskMgr;
            synchronized (cause) {
                this.doneQueueProcessing = true;
                this.taskMgr.clearQueuedCommands(this.obj);
            }
            if (t instanceof DomainObjectException) {
                t = t.getCause();
            }
            commit = this.shouldKeepData(t);
            if (this.isUnrecoverableException(t)) {
                monitor.cancel();
                this.taskMgr.clearTasks(this.obj);
                return;
            }
            if (!(t instanceof RollbackException)) {
                String message = "An unexpected error occurred while processing the command: " + this.cmd.getName();
                Msg.showError((Object)this, null, (String)"Command Failure", (Object)message, (Throwable)t);
            }
        }
        finally {
            block41: {
                TaskUtilities.removeTrackedTask((Task)this);
                try {
                    this.obj.endTransaction(id, commit);
                }
                catch (DomainObjectException e) {
                    Throwable cause = e.getCause();
                    if (!commit || cause instanceof ClosedException) break block41;
                    Msg.error((Object)this, (Object)"Transaction error", (Throwable)cause);
                    success = false;
                }
            }
        }
        if (!success) {
            this.taskMgr.taskFailed(this.obj, this.cmd, monitor);
        }
    }

    private boolean shouldKeepData(Throwable t) {
        boolean reallyBad = this.isUnrecoverableException(t) || t instanceof RollbackException;
        return !reallyBad;
    }

    private boolean isUnrecoverableException(Throwable t) {
        return t instanceof ConnectException || t instanceof TerminatedTransactionException || t instanceof DomainObjectLockedException || t instanceof ClosedException;
    }

    @Override
    public void transactionAborted(long transactionID) {
        this.taskMonitor.cancel();
    }

    void setDoneQueueProcessing() {
        this.doneQueueProcessing = true;
    }

    boolean isDoneQueueProcessing() {
        return this.doneQueueProcessing;
    }
}

