/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.Buffer;
import db.Field;
import db.IllegalFieldAccessException;
import db.PrimitiveField;
import db.buffers.DataBuffer;
import java.io.IOException;

public final class ByteField
extends PrimitiveField {
    public static final ByteField MIN_VALUE = new ByteField(-128, true);
    public static final ByteField MAX_VALUE = new ByteField(127, true);
    public static final ByteField ZERO_VALUE;
    public static final ByteField INSTANCE;
    private byte value;

    public ByteField() {
    }

    public ByteField(byte b) {
        this(b, false);
    }

    ByteField(byte b, boolean immutable) {
        super(immutable);
        this.value = b;
    }

    @Override
    void setNull() {
        super.setNull();
        this.value = 0;
    }

    @Override
    public byte getByteValue() {
        return this.value;
    }

    @Override
    public void setByteValue(byte value) {
        this.updatingPrimitiveValue();
        this.value = value;
    }

    @Override
    int length() {
        return 1;
    }

    @Override
    int write(Buffer buf, int offset) throws IOException {
        return buf.putByte(offset, this.value);
    }

    @Override
    int read(Buffer buf, int offset) throws IOException {
        this.updatingPrimitiveValue();
        this.value = buf.getByte(offset);
        return offset + 1;
    }

    @Override
    int readLength(Buffer buf, int offset) throws IOException {
        return 1;
    }

    @Override
    byte getFieldType() {
        return 0;
    }

    @Override
    public String getValueAsString() {
        return "0x" + Integer.toHexString(this.value & 0xFF);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ByteField)) {
            return false;
        }
        return ((ByteField)obj).value == this.value;
    }

    @Override
    public int compareTo(Field o) {
        ByteField f = (ByteField)o;
        if (this.value == f.value) {
            return 0;
        }
        if (this.value < f.value) {
            return -1;
        }
        return 1;
    }

    @Override
    int compareTo(DataBuffer buffer, int offset) {
        byte otherValue = buffer.getByte(offset);
        if (this.value == otherValue) {
            return 0;
        }
        if (this.value < otherValue) {
            return -1;
        }
        return 1;
    }

    @Override
    public ByteField copyField() {
        if (this.isNull()) {
            ByteField copy = new ByteField();
            copy.setNull();
            return copy;
        }
        return new ByteField((byte)this.getLongValue());
    }

    @Override
    public ByteField newField() {
        return new ByteField();
    }

    @Override
    public long getLongValue() {
        return this.value;
    }

    @Override
    public void setLongValue(long value) {
        this.setByteValue((byte)value);
    }

    @Override
    public byte[] getBinaryData() {
        return new byte[]{this.value};
    }

    @Override
    public void setBinaryData(byte[] bytes) {
        if (bytes.length != 1) {
            throw new IllegalFieldAccessException();
        }
        this.updatingPrimitiveValue();
        this.value = bytes[0];
    }

    @Override
    public int hashCode() {
        return this.value;
    }

    @Override
    ByteField getMinValue() {
        return MIN_VALUE;
    }

    @Override
    ByteField getMaxValue() {
        return MAX_VALUE;
    }

    static {
        INSTANCE = ZERO_VALUE = new ByteField(0, true);
    }
}

