/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.Field;
import db.InteriorNode;
import db.LongKeyNode;
import db.LongKeyRecordNode;
import db.NodeMgr;
import db.buffers.DataBuffer;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

class LongKeyInteriorNode
extends LongKeyNode
implements InteriorNode {
    private static final int BASE = 5;
    private static final int KEY_SIZE = 8;
    private static final int ID_SIZE = 4;
    private static final int ENTRY_SIZE = 12;
    private int maxKeyCount;

    LongKeyInteriorNode(NodeMgr nodeMgr, DataBuffer buf) {
        super(nodeMgr, buf);
        this.maxKeyCount = (this.buffer.length() - 5) / 12;
    }

    LongKeyInteriorNode(NodeMgr nodeMgr, long key1, int id1, long key2, int id2) throws IOException {
        super(nodeMgr, (byte)0);
        this.maxKeyCount = (this.buffer.length() - 5) / 12;
        this.setKeyCount(2);
        this.putEntry(0, key1, id1);
        this.putEntry(1, key2, id2);
    }

    @Override
    public LongKeyInteriorNode getParent() {
        return this.parent;
    }

    private LongKeyInteriorNode(NodeMgr nodeMgr) throws IOException {
        super(nodeMgr, (byte)0);
        this.maxKeyCount = (this.buffer.length() - 5) / 12;
    }

    void logConsistencyError(String tableName, String msg, Throwable t) {
        Msg.debug((Object)this, (Object)("Consistency Error (" + tableName + "): " + msg));
        Msg.debug((Object)this, (Object)("  parent.key[0]=" + Long.toHexString(this.getKey(0)) + " bufferID=" + this.getBufferId()));
        if (t != null) {
            Msg.error((Object)this, (Object)("Consistency Error (" + tableName + ")"), (Throwable)t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConsistent(String tableName, TaskMonitor monitor) throws IOException, CancelledException {
        boolean consistent = true;
        long lastMinKey = 0L;
        long lastMaxKey = 0L;
        for (int i = 0; i < this.keyCount; ++i) {
            long key = this.getKey(i);
            if (i != 0) {
                if (key <= lastMinKey) {
                    consistent = false;
                    this.logConsistencyError(tableName, "child[" + i + "].minKey <= child[" + (i - 1) + "].minKey", null);
                    Msg.debug((Object)this, (Object)("  child[" + i + "].minKey = 0x" + Long.toHexString(key) + " bufferID=" + this.getBufferId(i)));
                    Msg.debug((Object)this, (Object)("  child[" + (i - 1) + "].minKey = 0x" + Long.toHexString(lastMinKey) + " bufferID=" + this.getBufferId(i - 1)));
                } else if (key <= lastMaxKey) {
                    consistent = false;
                    this.logConsistencyError(tableName, "child[" + i + "].minKey <= child[" + (i - 1) + "].maxKey", null);
                    Msg.debug((Object)this, (Object)("  child[" + i + "].minKey = 0x" + Long.toHexString(key) + " bufferID=" + this.getBufferId(i)));
                    Msg.debug((Object)this, (Object)("  child[" + (i - 1) + "].maxKey = 0x" + Long.toHexString(lastMaxKey) + " bufferID=" + this.getBufferId(i - 1)));
                }
            }
            lastMinKey = key;
            LongKeyNode node = null;
            try {
                try {
                    node = this.nodeMgr.getLongKeyNode(this.getBufferId(i));
                    node.parent = this;
                }
                catch (IOException e) {
                    this.logConsistencyError(tableName, "failed to fetch child node: " + e.getMessage(), e);
                }
                catch (RuntimeException e) {
                    this.logConsistencyError(tableName, "failed to fetch child node: " + e.getMessage(), e);
                }
                if (node == null) {
                    consistent = false;
                    lastMaxKey = key;
                    continue;
                }
                lastMaxKey = node.getKey(node.getKeyCount() - 1);
                long childKey0 = node.getKey(0);
                if (key != childKey0) {
                    consistent = false;
                    this.logConsistencyError(tableName, "parent key entry mismatch with child[" + i + "].minKey", null);
                    Msg.debug((Object)this, (Object)("  child[" + i + "].minKey = 0x" + Long.toHexString(childKey0) + " bufferID=" + this.getBufferId(i - 1)));
                    Msg.debug((Object)this, (Object)("  parent key entry = 0x" + Long.toHexString(key)));
                }
                consistent &= node.isConsistent(tableName, monitor);
                monitor.checkCanceled();
                continue;
            }
            finally {
                if (node != null) {
                    this.nodeMgr.releaseReadOnlyNode(node.getBufferId());
                }
            }
        }
        monitor.checkCanceled();
        return consistent;
    }

    int getIdIndex(long key) {
        int min = 1;
        int max = this.keyCount - 1;
        while (min <= max) {
            int i = (min + max) / 2;
            long k = this.getKey(i);
            if (k == key) {
                return i;
            }
            if (k < key) {
                min = i + 1;
                continue;
            }
            max = i - 1;
        }
        return max;
    }

    @Override
    public int getKeyIndex(Field key) throws IOException {
        return this.getKeyIndex(key.getLongValue());
    }

    private int getKeyIndex(long key) {
        int min = 0;
        int max = this.keyCount - 1;
        while (min <= max) {
            int i = (min + max) / 2;
            long k = this.getKey(i);
            if (k == key) {
                return i;
            }
            if (k < key) {
                min = i + 1;
                continue;
            }
            max = i - 1;
        }
        return -(min + 1);
    }

    @Override
    long getKey(int index) {
        return this.buffer.getLong(5 + index * 12);
    }

    private void putKey(int index, long key) {
        this.buffer.putLong(5 + index * 12, key);
    }

    private int getBufferId(int index) {
        return this.buffer.getInt(5 + index * 12 + 8);
    }

    private void putEntry(int index, long key, int bufferId) {
        int offset = 5 + index * 12;
        this.buffer.putLong(offset, key);
        this.buffer.putInt(offset + 8, bufferId);
    }

    private void insertEntry(int index, long key, int bufferId) {
        int start = 5 + index * 12;
        int end = 5 + this.keyCount * 12;
        this.buffer.move(start, start + 12, end - start);
        this.buffer.putLong(start, key);
        this.buffer.putInt(start + 8, bufferId);
        this.setKeyCount(this.keyCount + 1);
    }

    private void deleteEntry(int index) {
        if (this.keyCount < 3 || index >= this.keyCount) {
            throw new AssertException();
        }
        if (++index < this.keyCount) {
            int start = 5 + index * 12;
            int end = 5 + this.keyCount * 12;
            this.buffer.move(start, start - 12, end - start);
        }
        this.setKeyCount(this.keyCount - 1);
    }

    void keyChanged(long oldKey, long newKey) {
        int index = this.getKeyIndex(oldKey);
        if (index < 0) {
            throw new AssertException();
        }
        this.putKey(index, newKey);
        if (index == 0 && this.parent != null) {
            this.parent.keyChanged(oldKey, newKey);
        }
    }

    LongKeyNode insert(int id, long key) throws IOException {
        if (this.keyCount == this.maxKeyCount) {
            return this.split(key, id);
        }
        int index = -(this.getKeyIndex(key) + 1);
        if (index < 0 || id == 0) {
            throw new AssertException();
        }
        this.insertEntry(index, key, id);
        if (index == 0 && this.parent != null) {
            this.parent.keyChanged(this.getKey(1), key);
        }
        return this.getRoot();
    }

    private LongKeyNode split(long newKey, int newId) throws IOException {
        LongKeyInteriorNode newNode = new LongKeyInteriorNode(this.nodeMgr);
        LongKeyInteriorNode.moveKeysRight(this, newNode, this.keyCount / 2);
        long rightKey = newNode.getKey(0);
        if (newKey < rightKey) {
            this.insert(newId, newKey);
        } else {
            newNode.insert(newId, newKey);
        }
        if (this.parent != null) {
            return this.parent.insert(newNode.getBufferId(), rightKey);
        }
        return new LongKeyInteriorNode(this.nodeMgr, this.getKey(0), this.buffer.getId(), rightKey, newNode.getBufferId());
    }

    @Override
    LongKeyRecordNode getLeafNode(long key) throws IOException {
        LongKeyNode node = this.nodeMgr.getLongKeyNode(this.getBufferId(this.getIdIndex(key)));
        node.parent = this;
        return node.getLeafNode(key);
    }

    LongKeyNode deleteChild(long key) throws IOException {
        int index = this.getKeyIndex(key);
        if (index < 0) {
            throw new AssertException();
        }
        if (this.keyCount == 2) {
            if (this.parent != null) {
                throw new AssertException();
            }
            LongKeyNode rootNode = this.nodeMgr.getLongKeyNode(this.getBufferId(1 - index));
            rootNode.parent = null;
            this.nodeMgr.deleteNode(this);
            return rootNode;
        }
        this.deleteEntry(index);
        if (index == 0 && this.parent != null) {
            this.parent.keyChanged(key, this.getKey(0));
        }
        return this.parent != null ? this.parent.balanceChild(this) : this;
    }

    private LongKeyNode balanceChild(LongKeyInteriorNode node) throws IOException {
        if (node.keyCount > this.maxKeyCount / 2) {
            return this.getRoot();
        }
        int index = this.getIdIndex(node.getKey(0));
        if (index == this.keyCount - 1) {
            return this.balanceChild((LongKeyInteriorNode)this.nodeMgr.getLongKeyNode(this.getBufferId(index - 1)), node);
        }
        return this.balanceChild(node, (LongKeyInteriorNode)this.nodeMgr.getLongKeyNode(this.getBufferId(index + 1)));
    }

    private LongKeyNode balanceChild(LongKeyInteriorNode leftNode, LongKeyInteriorNode rightNode) throws IOException {
        long rightKey = rightNode.getKey(0);
        int leftKeyCount = leftNode.keyCount;
        int rightKeyCount = rightNode.keyCount;
        int newLeftKeyCount = leftKeyCount + rightKeyCount;
        if (newLeftKeyCount <= this.maxKeyCount) {
            LongKeyInteriorNode.moveKeysLeft(leftNode, rightNode, rightKeyCount);
            this.nodeMgr.deleteNode(rightNode);
            return this.deleteChild(rightKey);
        }
        if ((newLeftKeyCount /= 2) < leftKeyCount) {
            LongKeyInteriorNode.moveKeysRight(leftNode, rightNode, leftKeyCount - newLeftKeyCount);
        } else if (newLeftKeyCount > leftKeyCount) {
            LongKeyInteriorNode.moveKeysLeft(leftNode, rightNode, newLeftKeyCount - leftKeyCount);
        }
        this.keyChanged(rightKey, rightNode.getKey(0));
        return this.getRoot();
    }

    private static void moveKeysRight(LongKeyInteriorNode leftNode, LongKeyInteriorNode rightNode, int count) {
        int leftKeyCount = leftNode.keyCount;
        int rightKeyCount = rightNode.keyCount;
        int leftOffset = 5 + (leftKeyCount - count) * 12;
        int len = count * 12;
        rightNode.buffer.move(5, 5 + len, rightKeyCount * 12);
        rightNode.buffer.copy(5, leftNode.buffer, leftOffset, len);
        leftNode.setKeyCount(leftKeyCount - count);
        rightNode.setKeyCount(rightKeyCount + count);
    }

    private static void moveKeysLeft(LongKeyInteriorNode leftNode, LongKeyInteriorNode rightNode, int count) {
        int leftKeyCount = leftNode.keyCount;
        int rightKeyCount = rightNode.keyCount;
        int leftOffset = 5 + leftKeyCount * 12;
        int len = count * 12;
        leftNode.buffer.copy(leftOffset, rightNode.buffer, 5, len);
        leftNode.setKeyCount(leftKeyCount + count);
        if (count < rightKeyCount) {
            rightNode.buffer.move(5 + len, 5, (rightKeyCount -= count) * 12);
            rightNode.setKeyCount(rightKeyCount);
        }
    }

    @Override
    public void delete() throws IOException {
        for (int index = 0; index < this.keyCount; ++index) {
            this.nodeMgr.getLongKeyNode(this.getBufferId(index)).delete();
        }
        this.nodeMgr.deleteNode(this);
    }

    @Override
    public int[] getBufferReferences() {
        int[] ids = new int[this.keyCount];
        for (int i = 0; i < this.keyCount; ++i) {
            ids[i] = this.getBufferId(i);
        }
        return ids;
    }

    public boolean isLeftmostKey(long key) {
        if (this.getIdIndex(key) == 0) {
            if (this.parent != null) {
                return this.parent.isLeftmostKey(key);
            }
            return true;
        }
        return false;
    }

    public boolean isRightmostKey(long key) {
        if (this.getIdIndex(key) == this.keyCount - 1) {
            if (this.parent != null) {
                return this.parent.isRightmostKey(this.getKey(0));
            }
            return true;
        }
        return false;
    }
}

