/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.manager.cmd;

import agent.dbgeng.dbgeng.DebugControl;
import agent.dbgeng.manager.DbgEvent;
import agent.dbgeng.manager.cmd.AbstractDbgCommand;
import agent.dbgeng.manager.cmd.DbgPendingCommand;
import agent.dbgeng.manager.evt.AbstractDbgCompletedCommandEvent;
import agent.dbgeng.manager.evt.DbgConsoleOutputEvent;
import agent.dbgeng.manager.evt.DbgPromptChangedEvent;
import agent.dbgeng.manager.impl.DbgManagerImpl;

public class DbgConsoleExecCommand
extends AbstractDbgCommand<String> {
    private String command;
    private Output to;

    public DbgConsoleExecCommand(DbgManagerImpl manager, String command, Output to) {
        super(manager);
        this.command = command;
        this.to = to;
    }

    @Override
    public boolean handle(DbgEvent<?> evt, DbgPendingCommand<?> pending) {
        if (evt instanceof AbstractDbgCompletedCommandEvent && pending.getCommand().equals(this)) {
            return true;
        }
        if (evt instanceof DbgConsoleOutputEvent && this.to == Output.CAPTURE) {
            pending.steal(evt);
        }
        return false;
    }

    @Override
    public String complete(DbgPendingCommand<?> pending) {
        if (this.to == Output.CONSOLE) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (DbgConsoleOutputEvent out : pending.findAllOf(DbgConsoleOutputEvent.class)) {
            builder.append(out.getOutput());
        }
        return builder.toString();
    }

    @Override
    public void invoke() {
        DebugControl control = this.manager.getControl();
        control.execute(this.command);
        this.manager.processEvent(new DbgPromptChangedEvent(control.getPromptText()));
    }

    public static enum Output {
        CONSOLE,
        CAPTURE;

    }
}

