/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.manager.cmd;

import agent.dbgeng.dbgeng.DebugControl;
import agent.dbgeng.dbgeng.DebugThreadId;
import agent.dbgeng.manager.DbgEvent;
import agent.dbgeng.manager.DbgManager;
import agent.dbgeng.manager.cmd.AbstractDbgCommand;
import agent.dbgeng.manager.cmd.DbgPendingCommand;
import agent.dbgeng.manager.evt.AbstractDbgCompletedCommandEvent;
import agent.dbgeng.manager.evt.DbgCommandErrorEvent;
import agent.dbgeng.manager.evt.DbgRunningEvent;
import agent.dbgeng.manager.impl.DbgManagerImpl;
import agent.dbgeng.manager.impl.DbgThreadImpl;
import ghidra.util.Msg;
import java.util.Map;

public class DbgStepCommand
extends AbstractDbgCommand<Void> {
    private DebugThreadId id;
    protected final DbgManager.ExecSuffix suffix;
    private String lastCommand = "tct";

    public DbgStepCommand(DbgManagerImpl manager, DebugThreadId id, DbgManager.ExecSuffix suffix) {
        super(manager);
        this.id = id;
        this.suffix = suffix;
    }

    public DbgStepCommand(DbgManagerImpl manager, DebugThreadId id, Map<String, ?> args) {
        super(manager);
        this.id = id;
        this.suffix = DbgManager.ExecSuffix.EXTENDED;
        this.lastCommand = (String)args.get("Command");
    }

    @Override
    public boolean handle(DbgEvent<?> evt, DbgPendingCommand<?> pending) {
        if (evt instanceof AbstractDbgCompletedCommandEvent && pending.getCommand().equals(this)) {
            return evt instanceof DbgCommandErrorEvent || !pending.findAllOf(DbgRunningEvent.class).isEmpty();
        }
        if (evt instanceof DbgRunningEvent) {
            pending.claim(evt);
            return !pending.findAllOf(AbstractDbgCompletedCommandEvent.class).isEmpty();
        }
        return false;
    }

    @Override
    public void invoke() {
        String cmd = "";
        String prefix = this.id == null ? "" : "~" + this.id.id + " ";
        DebugControl control = this.manager.getControl();
        if (this.suffix.equals((Object)DbgManager.ExecSuffix.STEP_INSTRUCTION)) {
            cmd = "t";
        } else if (this.suffix.equals((Object)DbgManager.ExecSuffix.NEXT_INSTRUCTION)) {
            cmd = "p";
        } else if (this.suffix.equals((Object)DbgManager.ExecSuffix.FINISH)) {
            cmd = "gu";
        } else if (this.suffix.equals((Object)DbgManager.ExecSuffix.EXTENDED)) {
            cmd = this.getLastCommand();
        }
        DbgThreadImpl eventThread = this.manager.getEventThread();
        if (eventThread != null && eventThread.getId().equals(this.id)) {
            control.execute(cmd);
        } else if (this.manager.isKernelMode()) {
            Msg.info((Object)this, (Object)"Thread-specific stepping ignored in kernel-mode");
            control.execute(cmd);
        } else {
            control.execute(prefix + cmd);
        }
    }

    public String getLastCommand() {
        return this.lastCommand;
    }

    public void setLastCommand(String lastCommand) {
        this.lastCommand = lastCommand;
    }
}

