/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.manager.impl;

import agent.dbgeng.manager.impl.DbgRegister;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class DbgRegisterSet
extends AbstractSet<DbgRegister> {
    private final Map<String, DbgRegister> byName = new HashMap<String, DbgRegister>();
    private final Map<Integer, DbgRegister> byNumber = new TreeMap<Integer, DbgRegister>();

    public DbgRegisterSet(Collection<DbgRegister> regs) {
        for (DbgRegister r : regs) {
            this.byName.put(r.getName(), r);
            this.byNumber.put(r.getNumber(), r);
        }
    }

    public DbgRegister get(String name) {
        return this.byName.get(name);
    }

    public DbgRegister get(int number) {
        return this.byNumber.get(number);
    }

    @Override
    public Iterator<DbgRegister> iterator() {
        return this.byNumber.values().iterator();
    }

    @Override
    public int size() {
        return this.byNumber.size();
    }
}

