/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.manager.impl;

import agent.dbgeng.dbgeng.DebugProcessId;
import agent.dbgeng.dbgeng.DebugSessionId;
import agent.dbgeng.manager.DbgCause;
import agent.dbgeng.manager.DbgEventsListener;
import agent.dbgeng.manager.DbgProcess;
import agent.dbgeng.manager.DbgSession;
import agent.dbgeng.manager.cmd.DbgListProcessesCommand;
import agent.dbgeng.manager.impl.DbgManagerImpl;
import agent.dbgeng.manager.impl.DbgProcessImpl;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class DbgSessionImpl
implements DbgSession {
    private final Map<DebugProcessId, DbgProcessImpl> processes = new LinkedHashMap<DebugProcessId, DbgProcessImpl>();
    private final Map<DebugProcessId, DbgProcess> unmodifiableProcesses = Collections.unmodifiableMap(this.processes);
    private DbgManagerImpl manager;
    private DebugSessionId id;
    private Long exitCode;

    public DbgSessionImpl(DbgManagerImpl manager, DebugSessionId id) {
        this.manager = manager;
        this.id = id;
    }

    public DbgSessionImpl(DbgManagerImpl manager) {
        this.manager = manager;
    }

    public String toString() {
        return "<DbgSession id=" + this.id + ",exitCode=" + this.exitCode + ">";
    }

    @Override
    public DebugSessionId getId() {
        return this.id;
    }

    public void setId(DebugSessionId id) {
        this.id = id;
    }

    public void setExitCode(Long exitCode) {
        this.exitCode = exitCode;
    }

    @Override
    public Long getExitCode() {
        return this.exitCode;
    }

    public void add() {
        this.manager.sessions.put(this.id, this);
        ((DbgEventsListener)this.manager.getEventListeners().fire).sessionAdded(this, DbgCause.Causes.UNCLAIMED);
    }

    public void remove(DbgCause cause) {
        this.manager.removeSession(this.id, cause);
    }

    public void addProcess(DbgProcessImpl process) {
        DbgProcessImpl exists = this.processes.get(process.getId());
        if (exists != null) {
            throw new IllegalArgumentException("There is already process " + exists);
        }
        this.processes.put(process.getId(), process);
    }

    @Override
    public DbgProcessImpl getProcess(DebugProcessId tid) {
        DbgProcessImpl result = this.processes.get(tid);
        if (result == null) {
            throw new IllegalArgumentException("There is no thread with id " + tid);
        }
        return result;
    }

    public void removeProcess(DebugProcessId pid) {
        if (this.processes.remove(pid) == null) {
            throw new IllegalArgumentException("There is no process with id " + pid);
        }
    }

    @Override
    public Map<DebugProcessId, DbgProcess> getKnownProcesses() {
        return this.unmodifiableProcesses;
    }

    public Map<DebugProcessId, DbgProcessImpl> getKnownProcessImpl() {
        return this.processes;
    }

    @Override
    public CompletableFuture<Map<DebugProcessId, DbgProcess>> listProcesses() {
        return this.manager.execute(new DbgListProcessesCommand(this.manager));
    }

    protected void processCreated(DbgProcessImpl process) {
        this.processes.put(process.getId(), process);
    }

    public void processExited(DebugProcessId id) {
        this.processes.remove(id);
    }
}

