/*
 * Decompiled with CFR 0.152.
 */
package help.validator;

import help.validator.DuplicateAnchorCollection;
import help.validator.model.AnchorDefinition;
import help.validator.model.HelpTopic;
import java.nio.file.Path;
import java.util.List;

public class DuplicateAnchorCollectionByHelpTopic
implements DuplicateAnchorCollection,
Comparable<DuplicateAnchorCollectionByHelpTopic> {
    private final HelpTopic topic;
    private final List<AnchorDefinition> definitions;

    DuplicateAnchorCollectionByHelpTopic(HelpTopic topic, List<AnchorDefinition> definitions) {
        this.topic = topic;
        this.definitions = definitions;
    }

    public String toString() {
        return "Duplicate anchors for topic\n\ttopic file:  " + this.topic.getTopicFile() + "\n" + this.getAnchorsAsString();
    }

    private String getAnchorsAsString() {
        StringBuilder buildy = new StringBuilder();
        for (AnchorDefinition definition : this.definitions) {
            buildy.append('\t').append('\t').append(definition).append('\n');
        }
        return buildy.toString();
    }

    @Override
    public int compareTo(DuplicateAnchorCollectionByHelpTopic o) {
        Path topicFile1 = this.topic.getTopicFile();
        Path topicFile2 = o.topic.getTopicFile();
        return topicFile1.compareTo(topicFile2);
    }
}

