/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgmodel.impl.dbgmodel.debughost;

import agent.dbgmodel.dbgmodel.DbgModel;
import agent.dbgmodel.dbgmodel.debughost.DebugHostSymbol1;
import agent.dbgmodel.impl.dbgmodel.debughost.DebugHostSymbolEnumeratorInternal;
import agent.dbgmodel.impl.dbgmodel.debughost.DebugHostSymbolInternal;
import agent.dbgmodel.jna.dbgmodel.debughost.IDebugHostSymbolEnumerator;
import agent.dbgmodel.jna.dbgmodel.debughost.WrapIDebugHostSymbol1;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.PointerByReference;

public class DebugHostSymbolEnumeratorImpl
implements DebugHostSymbolEnumeratorInternal {
    private final DbgModel.OpaqueCleanable cleanable;
    private final IDebugHostSymbolEnumerator jnaData;

    public DebugHostSymbolEnumeratorImpl(IDebugHostSymbolEnumerator jnaData) {
        this.cleanable = DbgModel.releaseWhenPhantom((Object)this, jnaData);
        this.jnaData = jnaData;
    }

    @Override
    public Pointer getPointer() {
        return this.jnaData.getPointer();
    }

    @Override
    public void reset() {
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.Reset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DebugHostSymbol1 getNext() {
        PointerByReference ppSymbol = new PointerByReference();
        WinNT.HRESULT hr = this.jnaData.GetNext(ppSymbol);
        if (hr.longValue() != 0L) {
            return null;
        }
        WrapIDebugHostSymbol1 wrap = new WrapIDebugHostSymbol1(ppSymbol.getValue());
        try {
            DebugHostSymbolInternal debugHostSymbolInternal = DebugHostSymbolInternal.tryPreferredInterfaces(wrap::QueryInterface);
            return debugHostSymbolInternal;
        }
        finally {
            wrap.Release();
        }
    }
}

