/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgmodel.impl.dbgmodel.main;

import agent.dbgmodel.dbgmodel.DbgModel;
import agent.dbgmodel.dbgmodel.main.KeyStore;
import agent.dbgmodel.dbgmodel.main.ModelObject;
import agent.dbgmodel.impl.dbgmodel.main.ModelKeyReferenceInternal;
import agent.dbgmodel.impl.dbgmodel.main.ModelObjectImpl;
import agent.dbgmodel.impl.dbgmodel.main.ModelObjectInternal;
import agent.dbgmodel.jna.dbgmodel.main.IModelKeyReference;
import agent.dbgmodel.jna.dbgmodel.main.WrapIModelObject;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.OleAuto;
import com.sun.jna.platform.win32.WTypes;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.PointerByReference;

public class ModelKeyReferenceImpl1
implements ModelKeyReferenceInternal {
    private final DbgModel.OpaqueCleanable cleanable;
    private final IModelKeyReference jnaData;

    public ModelKeyReferenceImpl1(IModelKeyReference jnaData) {
        this.cleanable = DbgModel.releaseWhenPhantom((Object)this, jnaData);
        this.jnaData = jnaData;
    }

    @Override
    public Pointer getPointer() {
        return this.jnaData.getPointer();
    }

    @Override
    public String getKeyName() {
        WTypes.BSTRByReference bref = new WTypes.BSTRByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.GetKeyName(bref));
        WTypes.BSTR bstr = bref.getValue();
        String keyName = bstr.getValue();
        OleAuto.INSTANCE.SysFreeString(bstr);
        return keyName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelObject getOriginalObject() {
        PointerByReference ppOriginalObject = new PointerByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.GetOriginalObject(ppOriginalObject));
        WrapIModelObject wrap = new WrapIModelObject(ppOriginalObject.getValue());
        try {
            ModelObjectInternal modelObjectInternal = ModelObjectInternal.tryPreferredInterfaces(wrap::QueryInterface);
            return modelObjectInternal;
        }
        finally {
            wrap.Release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelObject getContextObject() {
        PointerByReference ppContainingObject = new PointerByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.GetContextObject(ppContainingObject));
        WrapIModelObject wrap = new WrapIModelObject(ppContainingObject.getValue());
        try {
            ModelObjectInternal modelObjectInternal = ModelObjectInternal.tryPreferredInterfaces(wrap::QueryInterface);
            return modelObjectInternal;
        }
        finally {
            wrap.Release();
        }
    }

    @Override
    public ModelObject getKey() {
        PointerByReference ppObject = new PointerByReference();
        PointerByReference ppMetadata = new PointerByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.GetKey(ppObject, ppMetadata));
        return ModelObjectImpl.getObjectWithMetadata(ppObject, ppMetadata);
    }

    @Override
    public ModelObject getKeyValue() {
        PointerByReference ppObject = new PointerByReference();
        PointerByReference ppMetadata = new PointerByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.GetKeyValue(ppObject, ppMetadata));
        return ModelObjectImpl.getObjectWithMetadata(ppObject, ppMetadata);
    }

    @Override
    public void setKey(ModelObject object, KeyStore metadata) {
        Pointer pObject = object.getPointer();
        Pointer pMetadata = metadata.getPointer();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.SetKey(pObject, pMetadata));
    }

    @Override
    public void setKeyValue(ModelObject object, KeyStore metadata) {
        Pointer pObject = object.getPointer();
        Pointer pMetadata = metadata.getPointer();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.SetKey(pObject, pMetadata));
    }
}

