/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractModuleInformation;
import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractSectionContribution;
import ghidra.app.util.bin.format.pdb2.pdbreader.GlobalSymbolInformation;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbLog;
import ghidra.app.util.bin.format.pdb2.pdbreader.PublicSymbolInformation;
import ghidra.app.util.bin.format.pdb2.pdbreader.SectionContribution1400;
import ghidra.app.util.bin.format.pdb2.pdbreader.SectionContribution400;
import ghidra.app.util.bin.format.pdb2.pdbreader.SectionContribution600;
import ghidra.app.util.bin.format.pdb2.pdbreader.SegmentMapDescription;
import ghidra.app.util.bin.format.pdb2.pdbreader.SymbolRecords;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public abstract class PdbDebugInfo {
    protected static final int VERSION_NUMBER_SIZE = 4;
    public static final int STREAM_NUMBER_SIZE = 2;
    public static final int LENGTH_SIZE = 4;
    private static final long SCV600 = 4046371373L;
    private static final long SCV1400 = 4046541284L;
    protected AbstractPdb pdb;
    protected int streamNumber;
    protected long versionNumber = 0L;
    protected int streamNumberGlobalStaticSymbolsHashMaybe = 0;
    protected int streamNumberPublicStaticSymbolsHashMaybe = 0;
    protected int streamNumberSymbolRecords = 0;
    protected int lengthModuleInformationSubstream = 0;
    protected int lengthSectionContributionSubstream = 0;
    protected int lengthSectionMap = 0;
    protected int lengthFileInformation = 0;
    protected List<AbstractModuleInformation> moduleInformationList = new ArrayList<AbstractModuleInformation>();
    protected List<AbstractSectionContribution> sectionContributionList = new ArrayList<AbstractSectionContribution>();
    protected List<SegmentMapDescription> segmentMapList = new ArrayList<SegmentMapDescription>();
    protected SymbolRecords symbolRecords;
    protected GlobalSymbolInformation globalSymbolInformation;
    protected PublicSymbolInformation publicSymbolInformation;

    public PdbDebugInfo(AbstractPdb pdb, int streamNumber) {
        Objects.requireNonNull(pdb, "pdb cannot be null");
        this.pdb = pdb;
        this.streamNumber = streamNumber;
        this.globalSymbolInformation = new GlobalSymbolInformation(pdb);
        this.publicSymbolInformation = new PublicSymbolInformation(pdb);
        this.symbolRecords = new SymbolRecords(pdb);
    }

    public static int getVersionNumberSize() {
        return 4;
    }

    public long deserialize(boolean headerOnly, TaskMonitor monitor) throws IOException, PdbException, CancelledException {
        if (headerOnly) {
            PdbByteReader reader = this.pdb.getReaderForStreamNumber(this.streamNumber, 0, this.getHeaderLength(), monitor);
            this.deserializeHeader(reader);
        } else {
            PdbByteReader reader = this.pdb.getReaderForStreamNumber(this.streamNumber, monitor);
            this.deserializeHeader(reader);
            this.deserializeInternalSubstreams(reader, monitor);
            this.deserializeAdditionalSubstreams(monitor);
        }
        return this.versionNumber;
    }

    public int getNumModules() {
        return this.moduleInformationList.size();
    }

    public List<AbstractModuleInformation> getModuleInformationList() {
        return this.moduleInformationList;
    }

    public AbstractModuleInformation getModuleInformation(int moduleNumber) throws PdbException {
        if (moduleNumber < 1 || moduleNumber > this.moduleInformationList.size()) {
            throw new PdbException("ModuleNumber out of range: " + moduleNumber);
        }
        AbstractModuleInformation moduleInfo = this.moduleInformationList.get(moduleNumber - 1);
        if (moduleInfo == null) {
            throw new PdbException("Null AbstractModuleInformation");
        }
        return moduleInfo;
    }

    public Map<Long, AbstractMsSymbol> getSymbolsByOffset() {
        return this.symbolRecords.getSymbolsByOffset();
    }

    public Map<Long, AbstractMsSymbol> getModuleSymbolsByOffset(int moduleNumber) throws PdbException {
        if (moduleNumber < 0 || moduleNumber > this.moduleInformationList.size()) {
            throw new PdbException("ModuleNumber out of range: " + moduleNumber);
        }
        if (moduleNumber == 0) {
            return this.getSymbolsByOffset();
        }
        return this.symbolRecords.getModuleSymbolsByOffset(moduleNumber - 1);
    }

    public AbstractMsSymbol getSymbolForOffsetOfRecord(long offset) {
        return this.getSymbolsByOffset().get(offset - 4L);
    }

    public AbstractMsSymbol getSymbolForModuleAndOffsetOfRecord(int moduleNumber, long offset) throws PdbException {
        Map<Long, AbstractMsSymbol> symbols = this.getModuleSymbolsByOffset(moduleNumber);
        if (symbols == null) {
            return null;
        }
        return symbols.get(offset - 4L);
    }

    public List<AbstractSectionContribution> getSectionContributionList() {
        return this.sectionContributionList;
    }

    public List<SegmentMapDescription> getSegmentMapList() {
        return this.segmentMapList;
    }

    public SymbolRecords getSymbolRecords() {
        return this.symbolRecords;
    }

    public GlobalSymbolInformation getGlobalSymbolInformation() {
        return this.globalSymbolInformation;
    }

    public PublicSymbolInformation getPublicSymbolInformation() {
        return this.publicSymbolInformation;
    }

    int getGlobalSymbolsHashMaybeStreamNumber() {
        return this.streamNumberGlobalStaticSymbolsHashMaybe;
    }

    int getPublicStaticSymbolsHashMaybeStreamNumber() {
        return this.streamNumberPublicStaticSymbolsHashMaybe;
    }

    int getSymbolRecordsStreamNumber() {
        return this.streamNumberSymbolRecords;
    }

    protected abstract void deserializeHeader(PdbByteReader var1) throws PdbException;

    protected abstract int getHeaderLength();

    protected abstract void deserializeInternalSubstreams(PdbByteReader var1, TaskMonitor var2) throws PdbException, CancelledException;

    protected abstract void deserializeAdditionalSubstreams(TaskMonitor var1) throws IOException, PdbException, CancelledException;

    protected abstract void processModuleInformation(PdbByteReader var1, TaskMonitor var2, boolean var3) throws PdbException, CancelledException;

    protected abstract void dumpHeader(Writer var1) throws IOException;

    protected abstract void dumpInternalSubstreams(Writer var1) throws IOException;

    protected void processSectionContributions(PdbByteReader reader, TaskMonitor monitor, boolean skip) throws PdbException, CancelledException {
        if (this.lengthSectionContributionSubstream == 0) {
            return;
        }
        if (skip) {
            reader.skip(this.lengthSectionContributionSubstream);
            return;
        }
        PdbByteReader substreamReader = reader.getSubPdbByteReader(this.lengthSectionContributionSubstream);
        long version = substreamReader.parseUnsignedIntVal();
        if (version == 4046541284L) {
            while (substreamReader.hasMore()) {
                monitor.checkCanceled();
                SectionContribution1400 sectionContribution = new SectionContribution1400();
                ((AbstractSectionContribution)sectionContribution).deserialize(substreamReader);
                this.sectionContributionList.add(sectionContribution);
            }
        } else if (version == 4046371373L) {
            while (substreamReader.hasMore()) {
                monitor.checkCanceled();
                SectionContribution600 sectionContribution = new SectionContribution600();
                ((AbstractSectionContribution)sectionContribution).deserialize(substreamReader);
                this.sectionContributionList.add(sectionContribution);
            }
        } else {
            while (substreamReader.hasMore()) {
                monitor.checkCanceled();
                SectionContribution400 sectionContribution = new SectionContribution400();
                ((AbstractSectionContribution)sectionContribution).deserialize(substreamReader);
                this.sectionContributionList.add(sectionContribution);
            }
        }
    }

    protected void processSegmentMap(PdbByteReader reader, TaskMonitor monitor, boolean skip) throws PdbException, CancelledException {
        if (this.lengthSectionMap == 0) {
            return;
        }
        if (skip) {
            reader.skip(this.lengthSectionMap);
            return;
        }
        PdbByteReader substreamReader = reader.getSubPdbByteReader(this.lengthSectionMap);
        int numSegments = substreamReader.parseUnsignedShortVal();
        int numSegLog = substreamReader.parseUnsignedShortVal();
        while (substreamReader.hasMore()) {
            monitor.checkCanceled();
            SegmentMapDescription segment = new SegmentMapDescription();
            segment.deserialize(substreamReader);
            this.segmentMapList.add(segment);
        }
        if (numSegments != this.segmentMapList.size()) {
            throw new PdbException("numSegments != segmentMapList.size()");
        }
    }

    protected void processFileInformation(PdbByteReader reader, TaskMonitor monitor, boolean skip) throws PdbException, CancelledException {
        if (this.lengthFileInformation == 0) {
            return;
        }
        if (skip) {
            reader.skip(this.lengthFileInformation);
            return;
        }
        PdbByteReader fileInfoReader = reader.getSubPdbByteReader(this.lengthFileInformation);
        int numInformationModules = fileInfoReader.parseUnsignedShortVal();
        if (numInformationModules != this.moduleInformationList.size()) {
            throw new PdbException("Corrupt numInformationModules");
        }
        int numRefs = fileInfoReader.parseUnsignedShortVal();
        PdbByteReader indicesReader = fileInfoReader.getSubPdbByteReader(numInformationModules * 2);
        PdbByteReader countsReader = fileInfoReader.getSubPdbByteReader(numInformationModules * 2);
        int[] index = new int[numInformationModules];
        int[] count = new int[numInformationModules];
        int totalCount = 0;
        for (int moduleIndex = 0; moduleIndex < numInformationModules; ++moduleIndex) {
            monitor.checkCanceled();
            index[moduleIndex] = indicesReader.parseUnsignedShortVal();
            count[moduleIndex] = countsReader.parseUnsignedShortVal();
            totalCount += count[moduleIndex];
        }
        if (totalCount != numRefs) {
            PdbLog.message("totalRefs != numRefs, using totalRefs");
        }
        int previousIndex = totalCount;
        for (int moduleIndex = numInformationModules - 1; moduleIndex >= 0; --moduleIndex) {
            monitor.checkCanceled();
            int numFilesContributing = previousIndex - index[moduleIndex];
            previousIndex = index[moduleIndex];
            AbstractModuleInformation module = this.moduleInformationList.get(moduleIndex);
            module.setNumFilesContributing(numFilesContributing);
        }
        PdbByteReader offsetReader = fileInfoReader.getSubPdbByteReader(totalCount * 4);
        int[] offset = new int[totalCount];
        for (int moduleIndex = 0; moduleIndex < totalCount; ++moduleIndex) {
            offset[moduleIndex] = offsetReader.parseInt();
        }
        PdbByteReader namesReader = fileInfoReader.getSubPdbByteReader(fileInfoReader.numRemaining());
        int totalRefs = 0;
        for (int moduleIndex = 0; moduleIndex < numInformationModules; ++moduleIndex) {
            AbstractModuleInformation module = this.moduleInformationList.get(moduleIndex);
            for (int fileIndex = 0; fileIndex < count[moduleIndex]; ++fileIndex) {
                int ref = totalRefs + fileIndex;
                int nameOffset = offset[ref];
                namesReader.setIndex(nameOffset);
                String filename = this.parseFileInfoName(namesReader);
                module.addFilenameByOffset(nameOffset, filename);
            }
            totalRefs += count[moduleIndex];
        }
    }

    protected abstract String parseFileInfoName(PdbByteReader var1) throws PdbException;

    protected void dump(Writer writer) throws IOException {
        writer.write("DebugInfoHeader---------------------------------------------\n");
        this.dumpHeader(writer);
        writer.write("\nEnd DebugInfoHeader-----------------------------------------\n");
        writer.write("DebugInfoInternalSubstreams---------------------------------\n");
        this.dumpInternalSubstreams(writer);
        writer.write("\nEnd DebugInfoInternalSubstreams-----------------------------\n");
        writer.write("DebugInfoAdditionalSubstreams-------------------------------\n");
        this.dumpAdditionalSubstreams(writer);
        writer.write("\nEnd DebugInfoAdditionalSubstreams---------------------------\n");
    }

    protected void dumpAdditionalSubstreams(Writer writer) throws IOException {
        this.symbolRecords.dump(writer);
        writer.write("\n");
        this.globalSymbolInformation.dump(writer);
        writer.write("\n");
        this.publicSymbolInformation.dump(writer);
    }

    protected void dumpModuleInformation(Writer writer) throws IOException {
        for (AbstractModuleInformation information : this.moduleInformationList) {
            writer.write(information.dump());
            writer.write("\n");
        }
    }

    protected void dumpSectionContributions(Writer writer) throws IOException {
        for (AbstractSectionContribution contribution : this.sectionContributionList) {
            writer.write(contribution.dump());
            writer.write("\n");
        }
    }

    protected void dumpSegmentMap(Writer writer) throws IOException {
        for (SegmentMapDescription description : this.segmentMapList) {
            writer.write(description.dump());
            writer.write("\n");
        }
    }
}

