/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractBaseClassMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractIndirectVirtualBaseClassMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractVirtualBaseClassMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.ClassFieldMsAttributes;
import ghidra.app.util.pdb.pdbapplicator.MsTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.PdbApplicator;
import ghidra.util.exception.CancelledException;
import java.math.BigInteger;

public class BaseClassTypeApplier
extends MsTypeApplier {
    public BaseClassTypeApplier(PdbApplicator applicator, AbstractMsType msType) throws IllegalArgumentException {
        super(applicator, BaseClassTypeApplier.validateType(msType));
    }

    @Override
    BigInteger getSize() {
        return BigInteger.ZERO;
    }

    BigInteger getOffset() throws PdbException {
        if (this.msType instanceof AbstractBaseClassMsType) {
            return ((AbstractBaseClassMsType)this.msType).getOffset();
        }
        throw new PdbException("Offset is not a valid field");
    }

    BigInteger getBasePointerOffset() throws PdbException {
        if (this.msType instanceof AbstractBaseClassMsType) {
            throw new PdbException("Base Pointer Offset is not valid field");
        }
        if (this.msType instanceof AbstractVirtualBaseClassMsType) {
            return ((AbstractVirtualBaseClassMsType)this.msType).getBasePointerOffset();
        }
        return ((AbstractIndirectVirtualBaseClassMsType)this.msType).getBasePointerOffset();
    }

    ClassFieldMsAttributes getAttributes() {
        if (this.msType instanceof AbstractBaseClassMsType) {
            return ((AbstractBaseClassMsType)this.msType).getAttributes();
        }
        if (this.msType instanceof AbstractVirtualBaseClassMsType) {
            return ((AbstractVirtualBaseClassMsType)this.msType).getAttributes();
        }
        return ((AbstractIndirectVirtualBaseClassMsType)this.msType).getAttributes();
    }

    RecordNumber getBaseClassRecordNumber() {
        if (this.msType instanceof AbstractBaseClassMsType) {
            return ((AbstractBaseClassMsType)this.msType).getBaseClassRecordNumber();
        }
        if (this.msType instanceof AbstractVirtualBaseClassMsType) {
            return ((AbstractVirtualBaseClassMsType)this.msType).getBaseClassRecordNumber();
        }
        return ((AbstractIndirectVirtualBaseClassMsType)this.msType).getBaseClassRecordNumber();
    }

    boolean hasVirtualBasePointerTypeIndex() {
        return !(this.msType instanceof AbstractBaseClassMsType);
    }

    RecordNumber getVirtualBasePointerRecordNumber() throws PdbException {
        if (this.msType instanceof AbstractVirtualBaseClassMsType) {
            return ((AbstractVirtualBaseClassMsType)this.msType).getVirtualBasePointerRecordNumber();
        }
        if (this.msType instanceof AbstractIndirectVirtualBaseClassMsType) {
            return ((AbstractIndirectVirtualBaseClassMsType)this.msType).getVirtualBasePointerRecordNumber();
        }
        throw new PdbException("Not a virtual base class");
    }

    @Override
    void apply() throws PdbException, CancelledException {
    }

    private static AbstractMsType validateType(AbstractMsType type) throws IllegalArgumentException {
        if (!(type instanceof AbstractBaseClassMsType || type instanceof AbstractVirtualBaseClassMsType || type instanceof AbstractIndirectVirtualBaseClassMsType)) {
            throw new IllegalArgumentException("PDB Incorrectly applying " + type.getClass().getSimpleName() + " to " + BaseClassTypeApplier.class.getSimpleName());
        }
        return type;
    }
}

