/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.cmd.comments.SetCommentCmd;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import java.util.HashMap;
import java.util.Map;

public class BlockCommentsManager {
    private static final String BLOCK_INDENT = "   ";
    private Map<Address, String> blockPreComments = new HashMap<Address, String>();
    private Map<Address, String> blockPostComments = new HashMap<Address, String>();

    BlockCommentsManager() {
    }

    void applyTo(Program program) {
        this.applyTo(program, 0L);
    }

    void applyTo(Program program, long addressDelta) {
        this.finalizeBlockComments(program, addressDelta);
    }

    void addPreComment(Address address, String preComment) {
        String existingPreComment = this.blockPreComments.get(address);
        preComment = existingPreComment == null ? preComment : existingPreComment + "\n" + preComment;
        this.blockPreComments.put(address, preComment);
    }

    void addPostComment(Address address, String postComment) {
        String existingPostComment = this.blockPostComments.get(address);
        postComment = existingPostComment == null ? postComment : postComment + "\n" + existingPostComment;
        this.blockPostComments.put(address, postComment);
    }

    void addBlockComment(Address startAddress, String name, long length, int nestingLevel) {
        Object indent = "";
        for (int i = 1; i < nestingLevel; ++i) {
            indent = (String)indent + BLOCK_INDENT;
        }
        String baseComment = "level " + nestingLevel + ", length " + length;
        String preComment = (String)indent + "PDB: Block Beg, " + baseComment;
        if (!name.isEmpty()) {
            preComment = preComment + " (" + name + ")";
        }
        String postComment = (String)indent + "PDB: Block End, " + baseComment;
        this.addPreComment(startAddress, preComment);
        Address endAddress = startAddress.add(length <= 0L ? 0L : length - 1L);
        this.addPostComment(endAddress, postComment);
    }

    private void finalizeBlockComments(Program program, long addressDelta) {
        for (Map.Entry<Address, String> entry : this.blockPreComments.entrySet()) {
            this.appendBlockComment(program, entry.getKey().add(addressDelta), entry.getValue(), 1);
        }
        for (Map.Entry<Address, String> entry : this.blockPostComments.entrySet()) {
            Address endCodeUnitAddress = program.getListing().getCodeUnitContaining(entry.getKey().add(addressDelta)).getAddress();
            this.appendBlockComment(program, endCodeUnitAddress, entry.getValue(), 2);
        }
    }

    private void appendBlockComment(Program program, Address address, String text, int commentType) {
        String comment = program.getListing().getComment(commentType, address);
        comment = comment == null ? text : comment + "\n" + text;
        SetCommentCmd.createComment((Program)program, (Address)address, (String)comment, (int)commentType);
    }
}

