/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import generic.continues.ContinuesFactory;
import generic.continues.GenericFactory;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.FileBytesProvider;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pe.COMDescriptorDataDirectory;
import ghidra.app.util.bin.format.pe.DataDirectory;
import ghidra.app.util.bin.format.pe.ImageCor20Header;
import ghidra.app.util.bin.format.pe.NTHeader;
import ghidra.app.util.bin.format.pe.OptionalHeader;
import ghidra.app.util.bin.format.pe.PortableExecutable;
import ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTable;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTableRow;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.importer.MessageLogContinuesFactory;
import ghidra.app.util.pdb.pdbapplicator.PdbApplicator;
import ghidra.program.database.mem.FileBytes;
import ghidra.program.model.listing.Program;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

public class PdbCliInfoManager {
    private PdbApplicator applicator;
    private boolean initComplete = false;
    private CliStreamMetadata metadataStream;
    private boolean isDll = false;
    private boolean isAslr = false;

    PdbCliInfoManager(PdbApplicator applicator) {
        Objects.requireNonNull(applicator, "applicator may not be null");
        this.applicator = applicator;
    }

    private synchronized void initialize() {
        if (this.initComplete) {
            return;
        }
        this.initComplete = true;
        this.metadataStream = this.getCliStreamMetadata();
    }

    boolean isDll() {
        this.initialize();
        return this.isDll;
    }

    boolean isAslr() {
        this.initialize();
        return this.isAslr;
    }

    CliAbstractTableRow getCliTableRow(int tableNum, int rowNum) throws PdbException, IndexOutOfBoundsException {
        this.initialize();
        if (this.metadataStream == null) {
            throw new PdbException("CliStreamMetadata is null");
        }
        CliAbstractTable table = this.metadataStream.getTable(tableNum);
        if (table == null) {
            return null;
        }
        return table.getRow(rowNum);
    }

    private CliStreamMetadata getCliStreamMetadata() {
        Program program = this.applicator.getProgram();
        if (program == null) {
            return null;
        }
        List allFileBytes = program.getMemory().getAllFileBytes();
        if (allFileBytes.isEmpty()) {
            this.applicator.pdbLogAndErrorMessage(this, "Unable to retrieve CliStreamMetadata: no FileBytes", null);
            return null;
        }
        FileBytes fileBytes = (FileBytes)allFileBytes.get(0);
        FileBytesProvider provider = new FileBytesProvider(fileBytes);
        try {
            ContinuesFactory factory = MessageLogContinuesFactory.create((MessageLog)this.applicator.getMessageLog());
            PortableExecutable pe = PortableExecutable.createPortableExecutable((GenericFactory)factory, (ByteProvider)provider, (PortableExecutable.SectionLayout)PortableExecutable.SectionLayout.FILE, (boolean)true, (boolean)true);
            NTHeader ntHeader = pe.getNTHeader();
            if (ntHeader == null) {
                this.applicator.pdbLogAndErrorMessage(this, "Unable to retrieve CliStreamMetadata: NTHeader file bytes not found", null);
                return null;
            }
            OptionalHeader optionalHeader = ntHeader.getOptionalHeader();
            int characteristics = ntHeader.getFileHeader().getCharacteristics();
            this.isDll = (characteristics & 0x2000) == 8192;
            DataDirectory[] dataDirectory = optionalHeader.getDataDirectories();
            short optionalHeaderCharaceristics = optionalHeader.getDllCharacteristics();
            boolean bl = this.isAslr = (optionalHeaderCharaceristics & 0x20) == 32;
            if (14 >= dataDirectory.length) {
                this.applicator.pdbLogAndErrorMessage(this, "Unable to retrieve CliStreamMetadata: Bad index (14) for COMDescriptorDataDirectory in DataDirectory array of size " + dataDirectory.length, null);
                return null;
            }
            COMDescriptorDataDirectory comDir = (COMDescriptorDataDirectory)dataDirectory[14];
            ImageCor20Header header = comDir.getHeader();
            if (header == null) {
                this.applicator.pdbLogAndErrorMessage(this, "Unable to retrieve CliStreamMetadata: no COMDir header", null);
                return null;
            }
            return header.getMetadata().getMetadataRoot().getMetadataStream();
        }
        catch (IOException | RuntimeException e) {
            this.applicator.pdbLogAndErrorMessage(this, "Unable to retrieve CliStreamMetadata: " + e.getMessage(), e);
            return null;
        }
    }
}

