/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.console;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.Tool;
import docking.WindowPosition;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.builder.ActionBuilder;
import docking.actions.PopupActionProvider;
import docking.widgets.table.ColumnSortState;
import docking.widgets.table.CustomToStringCellRenderer;
import docking.widgets.table.DefaultEnumeratedColumnTableModel;
import docking.widgets.table.RowObjectTableModel;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.console.ConsoleActionsCellEditor;
import ghidra.app.plugin.core.debug.gui.console.ConsoleActionsCellRenderer;
import ghidra.app.plugin.core.debug.gui.console.DebuggerConsolePlugin;
import ghidra.app.plugin.core.debug.gui.console.LogRowConsoleActionContext;
import ghidra.app.plugin.core.debug.utils.DebouncedRowWrappedEnumeratedColumnTableModel;
import ghidra.framework.options.AutoOptions;
import ghidra.framework.options.annotation.AutoOptionConsumed;
import ghidra.framework.options.annotation.AutoOptionDefined;
import ghidra.framework.options.annotation.HelpInfo;
import ghidra.framework.plugintool.AutoService;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.Plugin;
import ghidra.util.HTMLUtilities;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.table.GhidraTable;
import ghidra.util.table.GhidraTableFilterPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Date;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LogEvent;

public class DebuggerConsoleProvider
extends ComponentProviderAdapter
implements PopupActionProvider {
    static final int ACTION_BUTTON_SIZE = 32;
    static final Dimension ACTION_BUTTON_DIM = new Dimension(32, 32);
    static final int MIN_ROW_HEIGHT = 16;
    private final DebuggerConsolePlugin plugin;
    private final AutoService.Wiring autoServiceWiring;
    @AutoOptionDefined(name={"Log Buffer Size"}, description="The maximum number of entries in the console log (0 or less for unlimited)", help=@HelpInfo(anchor="buffer_limit"))
    private int logBufferLimit = 100;
    private final AutoOptions.Wiring autoOptionsWiring;
    protected final Map<String, Map<String, DockingActionIf>> actionsByOwnerThenName = new LinkedHashMap<String, Map<String, DockingActionIf>>();
    protected final LogTableModel logTableModel = new LogTableModel();
    protected GhidraTable logTable;
    private GhidraTableFilterPanel<LogRow> logFilterPanel;
    private Deque<LogRow> buffer = new ArrayDeque<LogRow>();
    private final JPanel mainPanel = new JPanel(new BorderLayout());
    DockingAction actionClear;
    DockingAction actionSelectNone;

    public DebuggerConsoleProvider(DebuggerConsolePlugin plugin) {
        super(plugin.getTool(), "Debug Console", plugin.getName());
        this.plugin = plugin;
        this.tool.addPopupActionProvider((PopupActionProvider)this);
        this.setIcon(DebuggerResources.ICON_PROVIDER_CONSOLE);
        this.setHelpLocation(DebuggerResources.HELP_PROVIDER_CONSOLE);
        this.setWindowMenuGroup("Debugger");
        this.buildMainPanel();
        this.autoServiceWiring = AutoService.wireServicesConsumed((Plugin)plugin, (Object)((Object)this));
        this.autoOptionsWiring = AutoOptions.wireOptions((Plugin)plugin, (Object)((Object)this));
        this.setDefaultWindowPosition(WindowPosition.BOTTOM);
        this.setVisible(true);
        this.createActions();
    }

    protected void dispose() {
        this.tool.removePopupActionProvider((PopupActionProvider)this);
    }

    protected void buildMainPanel() {
        this.logTable = new LogTable(this.logTableModel);
        this.logTable.setSelectionMode(2);
        this.mainPanel.add(new JScrollPane((Component)this.logTable));
        this.logFilterPanel = new GhidraTableFilterPanel((JTable)this.logTable, (RowObjectTableModel)this.logTableModel);
        this.mainPanel.add((Component)this.logFilterPanel, "North");
        this.logTable.setRowHeight(32);
        TableColumnModel columnModel = this.logTable.getColumnModel();
        TableColumn levelCol = columnModel.getColumn(LogTableColumns.LEVEL.ordinal());
        levelCol.setMaxWidth(24);
        levelCol.setMinWidth(24);
        TableColumn msgCol = columnModel.getColumn(LogTableColumns.MESSAGE.ordinal());
        msgCol.setPreferredWidth(150);
        msgCol.setCellRenderer((TableCellRenderer)CustomToStringCellRenderer.HTML);
        TableColumn actCol = columnModel.getColumn(LogTableColumns.ACTIONS.ordinal());
        actCol.setPreferredWidth(50);
        actCol.setCellRenderer((TableCellRenderer)((Object)new ConsoleActionsCellRenderer()));
        actCol.setCellEditor(new ConsoleActionsCellEditor());
        TableColumn timeCol = columnModel.getColumn(LogTableColumns.TIME.ordinal());
        timeCol.setCellRenderer((TableCellRenderer)CustomToStringCellRenderer.TIME_24HMSms);
        timeCol.setPreferredWidth(15);
    }

    protected void createActions() {
        this.actionClear = (DockingAction)((ActionBuilder)DebuggerResources.ClearAction.builder(this.plugin).onAction(this::activatedClear)).buildAndInstallLocal((ComponentProvider)this);
        this.actionSelectNone = (DockingAction)((ActionBuilder)((ActionBuilder)DebuggerResources.SelectNoneAction.builder(this.plugin).popupWhen(ctx -> ctx.getSourceComponent() == this.logTable)).onAction(this::activatedSelectNone)).buildAndInstallLocal((ComponentProvider)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activatedClear(ActionContext ctx) {
        Deque<LogRow> deque = this.buffer;
        synchronized (deque) {
            this.logTableModel.clear();
            this.buffer.clear();
        }
    }

    private void activatedSelectNone(ActionContext ctx) {
        this.logTable.clearSelection();
    }

    public ActionContext getActionContext(MouseEvent event) {
        if (this.logTable.getSelectedRowCount() != 1) {
            return super.getActionContext(event);
        }
        LogRow sel = (LogRow)this.logFilterPanel.getSelectedItem();
        if (sel == null) {
            return super.getActionContext(event);
        }
        return sel.getActionContext();
    }

    @AutoOptionConsumed(name={"Log Buffer Size"})
    private void setLogBufferLimit(int logBufferLimit) {
        this.truncateLog();
    }

    public JComponent getComponent() {
        return this.mainPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void truncateLog() {
        Deque<LogRow> deque = this.buffer;
        synchronized (deque) {
            while (this.logBufferLimit > 0 && this.buffer.size() > this.logBufferLimit) {
                this.logTableModel.deleteItem(this.buffer.removeFirst());
            }
        }
    }

    protected void log(Icon icon, String message) {
        this.log(icon, message, new LogRowConsoleActionContext());
    }

    protected void log(Icon icon, String message, ActionContext context) {
        this.logRow(new LogRow(icon, message, new Date(), context, this.computeToolbarActions(context)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void logRow(LogRow row) {
        Deque<LogRow> deque = this.buffer;
        synchronized (deque) {
            LogRow old = (LogRow)this.logTableModel.deleteKey(row.getActionContext());
            if (old != null) {
                this.buffer.remove(old);
            }
            this.logTableModel.addItem(row);
            this.buffer.addLast(row);
            this.truncateLog();
        }
    }

    protected Icon iconForLevel(Level level) {
        if (level == Level.FATAL) {
            return DebuggerResources.ICON_LOG_FATAL;
        }
        if (level == Level.ERROR) {
            return DebuggerResources.ICON_LOG_ERROR;
        }
        if (level == Level.WARN) {
            return DebuggerResources.ICON_LOG_WARN;
        }
        return null;
    }

    protected void logEvent(LogEvent event) {
        LogRowConsoleActionContext context = new LogRowConsoleActionContext();
        this.logRow(new LogRow(this.iconForLevel(event.getLevel()), "<html>" + HTMLUtilities.escapeHTML((String)event.getMessage().getFormattedMessage()), new Date(event.getTimeMillis()), context, this.computeToolbarActions(context)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeFromLog(ActionContext context) {
        Deque<LogRow> deque = this.buffer;
        synchronized (deque) {
            LogRow r = (LogRow)this.logTableModel.deleteKey(context);
            this.buffer.remove(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean logContains(ActionContext context) {
        Deque<LogRow> deque = this.buffer;
        synchronized (deque) {
            return this.logTableModel.getMap().containsKey(context);
        }
    }

    protected void addResolutionAction(DockingActionIf action) {
        DockingActionIf replaced = this.actionsByOwnerThenName.computeIfAbsent(action.getOwner(), o -> new LinkedHashMap()).put(action.getName(), action);
        if (replaced != null) {
            Msg.warn((Object)((Object)this), (Object)("Duplicate resolution action registered: " + action.getFullName()));
        }
    }

    protected void removeResolutionAction(DockingActionIf action) {
        Map<String, DockingActionIf> byName = this.actionsByOwnerThenName.get(action.getOwner());
        if (byName == null) {
            Msg.warn((Object)((Object)this), (Object)("Action to remove was never added: " + action.getFullName()));
            return;
        }
        DockingActionIf removed = byName.get(action.getName());
        if (removed != action) {
            if (removed != null) {
                Msg.warn((Object)((Object)this), (Object)("Action to remove did not match that added: " + action.getFullName()));
            } else {
                Msg.warn((Object)((Object)this), (Object)("Action to removed was never added: " + action.getFullName()));
            }
            return;
        }
        if (byName.isEmpty()) {
            this.actionsByOwnerThenName.remove(action.getOwner());
        }
    }

    protected Stream<DockingActionIf> streamActions(ActionContext context) {
        return this.actionsByOwnerThenName.values().stream().flatMap(m -> m.values().stream()).filter(a -> a.isValidContext(context));
    }

    protected ActionList computeToolbarActions(ActionContext context) {
        return this.streamActions(context).filter(a -> a.getToolBarData() != null).map(a -> new BoundAction((DockingActionIf)a, context)).collect(Collectors.toCollection(ActionList::new));
    }

    public List<DockingActionIf> getPopupActions(Tool tool, ActionContext context) {
        return this.streamActions(context).filter(a -> a.isAddToPopup(context)).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getRowCount(Class<? extends ActionContext> ctxCls) {
        Deque<LogRow> deque = this.buffer;
        synchronized (deque) {
            return this.logTableModel.getModelData().stream().filter(r -> ctxCls.isInstance(r.context)).count();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogRow getLogRow(ActionContext ctx) {
        Deque<LogRow> deque = this.buffer;
        synchronized (deque) {
            return (LogRow)this.logTableModel.getMap().get(ctx);
        }
    }

    protected static class LogTable
    extends GhidraTable {
        public LogTable(LogTableModel model) {
            super((TableModel)((Object)model));
        }

        public void tableChanged(TableModelEvent e) {
            super.tableChanged(e);
            Swing.runIfSwingOrRunLater(() -> this.updateRowHeights());
        }

        public void columnMarginChanged(ChangeEvent e) {
            super.columnMarginChanged(e);
            Swing.runIfSwingOrRunLater(() -> this.updateRowHeights());
        }

        protected void updateRowHeights() {
            TableModel model = this.getModel();
            int rows = model.getRowCount();
            int cols = this.getColumnCount();
            for (int r = 0; r < rows; ++r) {
                int height = 16;
                for (int c = 0; c < cols; ++c) {
                    height = Math.max(height, this.computePreferredHeight(r, c));
                }
                this.setRowHeight(r, height);
            }
        }

        protected int computePreferredHeight(int r, int c) {
            TableCellRenderer renderer = this.getCellRenderer(r, c);
            if (renderer instanceof ConsoleActionsCellRenderer) {
                ActionList actions = (ActionList)this.getModel().getValueAt(r, this.convertColumnIndexToModel(c));
                if (!actions.isEmpty()) {
                    return 32;
                }
                return 0;
            }
            if (renderer instanceof CustomToStringCellRenderer) {
                CustomToStringCellRenderer custom = (CustomToStringCellRenderer)renderer;
                int colWidth = this.getColumnModel().getColumn(c).getWidth();
                this.prepareRenderer(renderer, r, c);
                return custom.getRowHeight(colWidth);
            }
            return 0;
        }
    }

    protected static class LogTableModel
    extends DebouncedRowWrappedEnumeratedColumnTableModel<LogTableColumns, ActionContext, LogRow, LogRow> {
        public LogTableModel() {
            super("Log", LogTableColumns.class, r -> r.getActionContext(), r -> r);
        }

        public List<LogTableColumns> defaultSortOrder() {
            return List.of(LogTableColumns.ACTIONS, LogTableColumns.TIME);
        }
    }

    public static class LogRow {
        private final Icon icon;
        private final String message;
        private final Date date;
        private final ActionContext context;
        private final ActionList actions;

        public LogRow(Icon icon, String message, Date date, ActionContext context, ActionList actions) {
            this.icon = icon;
            this.message = message;
            this.date = date;
            this.context = context;
            this.actions = actions;
        }

        public Icon getIcon() {
            return this.icon;
        }

        public String getMessage() {
            return this.message;
        }

        public Date getDate() {
            return this.date;
        }

        public ActionContext getActionContext() {
            return this.context;
        }

        public ActionList getActions() {
            return this.actions;
        }
    }

    public static class ActionList
    extends ArrayList<BoundAction> {
    }

    public static class BoundAction {
        public final DockingActionIf action;
        public final ActionContext context;

        public BoundAction(DockingActionIf action, ActionContext context) {
            this.action = action;
            this.context = context;
        }

        public String toString() {
            return this.getName();
        }

        public String getName() {
            return this.action.getName();
        }

        public Icon getIcon() {
            return this.action.getToolBarData().getIcon();
        }

        public boolean isEnabled() {
            return this.action.isEnabledForContext(this.context);
        }

        public String getTooltipText() {
            return this.action.getDescription();
        }

        public void perform() {
            this.action.actionPerformed(this.context);
        }
    }

    protected static enum LogTableColumns implements DefaultEnumeratedColumnTableModel.EnumeratedTableColumn<LogTableColumns, LogRow>
    {
        LEVEL("Level", Icon.class, LogRow::getIcon, ColumnSortState.SortDirection.ASCENDING, false),
        MESSAGE("Message", String.class, LogRow::getMessage, ColumnSortState.SortDirection.ASCENDING, false),
        ACTIONS("Actions", ActionList.class, LogRow::getActions, ColumnSortState.SortDirection.DESCENDING, true),
        TIME("Time", Date.class, LogRow::getDate, ColumnSortState.SortDirection.DESCENDING, false);

        private final String header;
        private final Function<LogRow, ?> getter;
        private final Class<?> cls;
        private final ColumnSortState.SortDirection defaultSortDirection;
        private final boolean editable;

        private <T> LogTableColumns(String header, Class<T> cls, Function<LogRow, T> getter, ColumnSortState.SortDirection defaultSortDirection, boolean editable) {
            this.header = header;
            this.cls = cls;
            this.getter = getter;
            this.defaultSortDirection = defaultSortDirection;
            this.editable = editable;
        }

        public String getHeader() {
            return this.header;
        }

        public Class<?> getValueClass() {
            return this.cls;
        }

        public Object getValueOf(LogRow row) {
            return this.getter.apply(row);
        }

        public boolean isEditable(LogRow row) {
            return this.editable;
        }

        public void setValueOf(LogRow row, Object value) {
        }

        public ColumnSortState.SortDirection defaultSortDirection() {
            return this.defaultSortDirection;
        }
    }
}

