/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.objects;

import ghidra.app.plugin.core.debug.gui.objects.DebuggerObjectsProvider;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.util.PathUtils;
import ghidra.util.xml.XmlUtilities;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import org.jdom.Content;
import org.jdom.Element;

public class ObjectContainer
implements Comparable<ObjectContainer> {
    private DebuggerObjectsProvider provider;
    protected TargetObject targetObject;
    private final Map<String, TargetObject> elementMap = new LinkedHashMap<String, TargetObject>();
    private final Map<String, Object> attributeMap = new LinkedHashMap<String, Object>();
    private Set<ObjectContainer> currentChildren = new TreeSet<ObjectContainer>();
    private boolean immutable;
    private boolean visible = true;
    private boolean isSubscribed = false;
    private boolean isLink = false;
    private boolean useSort = true;
    private String treePath;
    public String linkKey;

    public ObjectContainer(TargetObject to, String linkKey) {
        this.linkKey = linkKey;
        boolean bl = this.isLink = linkKey != null;
        if (to != null) {
            this.targetObject = to;
            if (!this.isLink) {
                this.rebuildContainers(this.targetObject.getCachedElements(), this.targetObject.getCachedAttributes());
            }
            this.visible = ObjectContainer.visibleByDefault(this.getName());
        }
    }

    public static boolean visibleByDefault(String key) {
        return key == null || !PathUtils.isHidden((String)key);
    }

    public static ObjectContainer clone(ObjectContainer container) {
        ObjectContainer nc = new ObjectContainer(container.getTargetObject(), container.linkKey);
        nc.rebuildContainers(container.getElementMap(), container.getAttributeMap());
        nc.propagateProvider(container.getProvider());
        return nc;
    }

    public void updateUsing(ObjectContainer container) {
        this.attributeMap.clear();
        this.attributeMap.putAll(container.getAttributeMap());
        this.elementMap.clear();
        this.elementMap.putAll(container.getElementMap());
        this.targetObject = container.targetObject;
    }

    public boolean hasElements() {
        return !this.elementMap.isEmpty();
    }

    public String getName() {
        String hint;
        if (this.targetObject == null) {
            return "Objects";
        }
        if (this.isLink) {
            return this.linkKey;
        }
        boolean noTarget = this.targetObject == null;
        String name = noTarget ? this.targetObject.getName() : this.targetObject.getName();
        String string = hint = noTarget ? null : this.targetObject.getTypeHint();
        if (name == null) {
            return hint;
        }
        return name;
    }

    public String getDecoratedName() {
        if (this.targetObject == null) {
            return "Objects";
        }
        if (this.isLink) {
            String refname = this.targetObject.getName();
            if (this.linkKey.equals(refname)) {
                return "->" + this.linkKey;
            }
            return this.linkKey + ":" + refname;
        }
        String name = this.targetObject.getName();
        if (this.targetObject.getCachedAttributes().containsKey("_display") && name != null) {
            return this.targetObject.getDisplay();
        }
        String hint = this.targetObject.getTypeHint();
        return name == null ? hint : name;
    }

    public String getPrefixedName() {
        if (this.targetObject == null) {
            return "Objects";
        }
        List path = this.targetObject.getPath();
        int index = path.size() - 1;
        if (index < 0) {
            return this.targetObject.getName();
        }
        String parent = (String)path.get(index);
        if (parent.contains("(")) {
            while (parent.contains("(")) {
                parent = (String)path.get(--index);
            }
            String initVal = (String)path.get(path.size() - 1);
            return parent + initVal.substring(initVal.indexOf(")") + 1);
        }
        return parent;
    }

    public String getShortName() {
        if (this.targetObject == null) {
            return "Objects";
        }
        return this.targetObject == null ? this.targetObject.getName() : this.targetObject.getName();
    }

    public ObjectContainer getParent() {
        return this.provider.getParent(this);
    }

    public CompletableFuture<ObjectContainer> getOffspring() {
        if (this.targetObject == null) {
            return CompletableFuture.completedFuture(null);
        }
        return this.targetObject.resync(true, true).thenApplyAsync(__ -> {
            this.rebuildContainers(this.targetObject.getCachedElements(), this.targetObject.getCachedAttributes());
            this.propagateProvider(this.provider);
            return this;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void augmentElements(Collection<String> elementsRemoved, Map<String, ? extends TargetObject> elementsAdded) {
        TreeSet<ObjectContainer> result = new TreeSet<ObjectContainer>();
        HashMap<String, TargetObject> newAdds = new HashMap<String, TargetObject>();
        for (Map.Entry<String, ? extends TargetObject> entry : elementsAdded.entrySet()) {
            newAdds.put(entry.getKey(), entry.getValue());
        }
        boolean structureChanged = false;
        Map<String, TargetObject> map = this.elementMap;
        synchronized (map) {
            for (ObjectContainer child : this.currentChildren) {
                String key = child.getName();
                if (key.startsWith("[")) {
                    key = key.substring(1, key.length() - 1);
                }
                if (elementsRemoved.contains(key) && !elementsAdded.containsKey(key)) {
                    this.elementMap.remove(key);
                    structureChanged = true;
                    continue;
                }
                if (elementsAdded.containsKey(key)) {
                    TargetObject val = elementsAdded.get(key);
                    ObjectContainer newChild = DebuggerObjectsProvider.buildContainerFromObject(this.targetObject, key, val, true);
                    child.updateUsing(newChild);
                    newAdds.remove(key);
                    this.provider.signalDataChanged(child);
                }
                result.add(child);
            }
            for (String key : elementsAdded.keySet()) {
                TargetObject val = elementsAdded.get(key);
                ObjectContainer child = DebuggerObjectsProvider.buildContainerFromObject(this.targetObject, key, val, false);
                this.elementMap.put(key, val);
                result.add(child);
                structureChanged = true;
            }
        }
        this.currentChildren = result;
        if (structureChanged) {
            this.provider.signalContentsChanged(this);
        }
        this.provider.fireObjectUpdated(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void augmentAttributes(Collection<String> attributesRemoved, Map<String, ?> attributesAdded) {
        TreeSet<ObjectContainer> result = new TreeSet<ObjectContainer>();
        HashMap newAdds = new HashMap();
        for (Map.Entry<String, ?> entry : attributesAdded.entrySet()) {
            newAdds.put(entry.getKey(), entry.getValue());
        }
        boolean structureChanged = false;
        Map<String, Object> map = this.attributeMap;
        synchronized (map) {
            for (ObjectContainer child : this.currentChildren) {
                String key = child.getName();
                if (attributesRemoved.contains(key) && !attributesAdded.containsKey(key)) {
                    this.attributeMap.remove(key);
                    structureChanged = true;
                    continue;
                }
                if (attributesAdded.containsKey(key)) {
                    Object val = attributesAdded.get(key);
                    ObjectContainer newChild = DebuggerObjectsProvider.buildContainerFromObject(this.targetObject, key, val, true);
                    child.updateUsing(newChild);
                    newAdds.remove(key);
                    this.provider.signalDataChanged(child);
                }
                result.add(child);
            }
            for (String key : newAdds.keySet()) {
                Object val;
                ObjectContainer child = DebuggerObjectsProvider.buildContainerFromObject(this.targetObject, key, val = newAdds.get(key), true);
                if (child == null) continue;
                this.attributeMap.put(key, val);
                result.add(child);
                structureChanged = true;
            }
        }
        this.currentChildren = result;
        if (structureChanged) {
            this.provider.signalContentsChanged(this);
        }
        this.provider.fireObjectUpdated(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuildContainers(Map<String, ? extends TargetObject> elements, Map<String, ?> attributes) {
        Map<String, Object> map = this.elementMap;
        synchronized (map) {
            this.elementMap.clear();
            if (elements != null) {
                this.elementMap.putAll(elements);
            }
        }
        map = this.attributeMap;
        synchronized (map) {
            this.attributeMap.clear();
            if (attributes != null) {
                this.attributeMap.putAll(attributes);
            }
        }
        TreeSet<ObjectContainer> result = new TreeSet<ObjectContainer>();
        List<ObjectContainer> nodeFromElements = DebuggerObjectsProvider.getContainersFromObjects(this.elementMap, this.targetObject, false);
        result.addAll(nodeFromElements);
        List<ObjectContainer> nodeFromAttributes = DebuggerObjectsProvider.getContainersFromObjects(this.attributeMap, this.targetObject, true);
        result.addAll(nodeFromAttributes);
        this.currentChildren = result;
    }

    public Set<ObjectContainer> getCurrentChildren() {
        return this.currentChildren;
    }

    public void setCurrentChildren(Set<ObjectContainer> children) {
        this.currentChildren = children;
    }

    public Map<String, Object> updateMap(Map<String, Object> map, List<String> removed, Map<String, ?> added) {
        if (removed != null) {
            for (String key : removed) {
                map.remove(key);
            }
        }
        if (added != null) {
            for (String key : added.keySet()) {
                Object object = added.get(key);
                map.put(key, object);
            }
        }
        return map;
    }

    public Map<String, Object> getAttributeMap() {
        return this.attributeMap;
    }

    public Map<String, TargetObject> getElementMap() {
        return this.elementMap;
    }

    public TargetObject getTargetObject() {
        return this.targetObject;
    }

    public ObjectContainer getSubContainer(TargetObject object) {
        for (ObjectContainer c1 : this.currentChildren) {
            if (c1.getTargetObject().equals((Object)object)) {
                return c1;
            }
            for (ObjectContainer c2 : c1.getCurrentChildren()) {
                if (!c2.getTargetObject().equals((Object)object)) continue;
                return c2;
            }
        }
        return null;
    }

    public DebuggerObjectsProvider getProvider() {
        return this.provider;
    }

    public void propagateProvider(DebuggerObjectsProvider newProvider) {
        if (newProvider == null) {
            throw new RuntimeException("Provider reset to null");
        }
        if (!newProvider.equals(this.provider)) {
            this.provider = newProvider;
            this.provider.addTargetToMap(this);
        }
        for (ObjectContainer c : this.currentChildren) {
            c.propagateProvider(this.provider);
        }
        this.provider.fireObjectUpdated(this);
    }

    public void setTargetObject(TargetObject rootObject) {
        this.targetObject = rootObject;
        this.rebuildContainers(rootObject.getCachedElements(), rootObject.getCachedAttributes());
        if (this.provider != null) {
            this.provider.addTargetToMap(this);
            this.provider.update(this);
        }
    }

    public Element toXml() {
        String name = this.getPrefixedName();
        if ((name = name.replaceAll(" ", "_")).contains("[")) {
            name = name.replaceAll("\\[", "_");
            name = name.replaceAll("\\]", "");
            name = name.replaceAll("/", "_");
        }
        Element result = new Element(name);
        for (ObjectContainer child : this.getCurrentChildren()) {
            String key = child.getShortName();
            if (this.elementMap.containsKey(key)) {
                result.addContent((Content)child.toXml());
                continue;
            }
            result.addContent((Content)child.toXml());
        }
        if (this.targetObject != null) {
            if (!this.targetObject.getTypeHint().equals("")) {
                XmlUtilities.setStringAttr((Element)result, (String)"Type", (String)this.targetObject.getTypeHint());
            }
            if (!this.targetObject.getDisplay().equals("")) {
                XmlUtilities.setStringAttr((Element)result, (String)"Value", (String)this.targetObject.getDisplay());
            }
        }
        return result;
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    public void setImmutable(boolean immutable) {
        this.immutable = immutable;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public String toString() {
        return this.targetObject == null ? super.toString() : this.targetObject.toString();
    }

    public boolean isSubscribed() {
        return this.isSubscribed;
    }

    public void subscribe() {
        this.isSubscribed = true;
    }

    public void unsubscribe() {
        this.isSubscribed = false;
    }

    public boolean isModified() {
        Object object = this.targetObject == null ? null : this.targetObject.getCachedAttributes().get("_modified");
        return object != null && (Boolean)object != false;
    }

    public boolean isLink() {
        return this.isLink;
    }

    public String getOrder() {
        Integer order = (Integer)this.attributeMap.get("_order");
        return order == null ? this.getName() : Integer.toString(order);
    }

    public boolean useSort() {
        return this.useSort;
    }

    public void setUseSort(boolean useSort) {
        this.useSort = useSort;
    }

    public String getTreePath() {
        return this.treePath;
    }

    public void setTreePath(String treePath) {
        this.treePath = treePath;
    }

    @Override
    public int compareTo(ObjectContainer that) {
        String thisTreePath = this.toString();
        String thatTreePath = that.toString();
        if (thisTreePath != null && thatTreePath != null) {
            return thisTreePath.compareTo(thatTreePath);
        }
        return this.hashCode() - that.hashCode();
    }
}

