/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.objects.components;

import docking.DialogComponentProvider;
import ghidra.app.plugin.core.debug.utils.MiscellaneousUtils;
import ghidra.dbg.target.TargetMethod;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.AutoConfigState;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.Msg;
import ghidra.util.layout.PairLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualLinkedHashBidiMap;
import org.apache.commons.lang3.tuple.MutablePair;
import org.jdom.Element;

public class DebuggerMethodInvocationDialog
extends DialogComponentProvider
implements PropertyChangeListener {
    private static final String KEY_MEMORIZED_ARGUMENTS = "memorizedArguments";
    private final BidiMap<TargetMethod.ParameterDescription<?>, PropertyEditor> paramEditors = new DualLinkedHashBidiMap();
    private JPanel panel;
    private JPanel pairPanel;
    private PairLayout layout;
    protected JButton invokeButton;
    private final PluginTool tool;
    private Map<String, TargetMethod.ParameterDescription<?>> parameters;
    private Map<NameTypePair, Object> memorized = new HashMap<NameTypePair, Object>();
    private Map<String, ?> arguments;

    public DebuggerMethodInvocationDialog(PluginTool tool, String title, String buttonText, Icon buttonIcon) {
        super(title, true, false, true, false);
        this.tool = tool;
        this.populateComponents(buttonText, buttonIcon);
        this.setRememberSize(false);
    }

    protected Object computeMemorizedValue(TargetMethod.ParameterDescription<?> parameter) {
        return this.memorized.computeIfAbsent(NameTypePair.fromParameter(parameter), ntp -> parameter.defaultValue);
    }

    public Map<String, ?> promptArguments(Map<String, TargetMethod.ParameterDescription<?>> parameterMap) {
        this.setParameters(parameterMap);
        this.tool.showDialog((DialogComponentProvider)this);
        return this.getArguments();
    }

    public void setParameters(Map<String, TargetMethod.ParameterDescription<?>> parameterMap) {
        this.parameters = parameterMap;
        this.populateOptions();
    }

    private void populateComponents(String buttonText, Icon buttonIcon) {
        this.panel = new JPanel(new BorderLayout());
        this.panel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.layout = new PairLayout(5, 5);
        this.pairPanel = new JPanel((LayoutManager)this.layout);
        JPanel centering = new JPanel(new FlowLayout(1));
        JScrollPane scrolling = new JScrollPane(centering, 20, 31);
        this.panel.add((Component)scrolling, "Center");
        centering.add(this.pairPanel);
        this.addWorkPanel(this.panel);
        this.invokeButton = new JButton(buttonText, buttonIcon);
        this.addButton(this.invokeButton);
        this.addCancelButton();
        this.invokeButton.addActionListener(this::invoke);
    }

    protected void cancelCallback() {
        this.arguments = null;
        this.close();
    }

    private void invoke(ActionEvent evt) {
        this.arguments = TargetMethod.validateArguments(this.parameters, this.collectArguments(), (boolean)false);
        this.close();
    }

    void populateOptions() {
        this.pairPanel.removeAll();
        this.paramEditors.clear();
        for (TargetMethod.ParameterDescription<?> param : this.parameters.values()) {
            JLabel label = new JLabel(param.display);
            label.setToolTipText(param.description);
            this.pairPanel.add(label);
            Class type = param.type;
            PropertyEditor editor = PropertyEditorManager.findEditor(type);
            if (editor == null) {
                Msg.warn((Object)this, (Object)("No editor for " + type + "? Trying String instead"));
                editor = PropertyEditorManager.findEditor(String.class);
            }
            editor.setValue(this.computeMemorizedValue(param));
            editor.addPropertyChangeListener(this);
            this.pairPanel.add(MiscellaneousUtils.getEditorComponent(editor));
            this.paramEditors.put(param, (Object)editor);
        }
    }

    protected Map<String, ?> collectArguments() {
        return this.paramEditors.keySet().stream().collect(Collectors.toMap(param -> param.name, param -> this.memorized.get((Object)NameTypePair.fromParameter(param))));
    }

    public Map<String, ?> getArguments() {
        return this.arguments;
    }

    public <T> void setMemorizedArgument(String name, Class<T> type, T value) {
        this.memorized.put(new NameTypePair(name, type), value);
    }

    public <T> T getMemorizedArgument(String name, Class<T> type) {
        return type.cast(this.memorized.get((Object)new NameTypePair(name, type)));
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        PropertyEditor editor = (PropertyEditor)evt.getSource();
        TargetMethod.ParameterDescription param = (TargetMethod.ParameterDescription)this.paramEditors.getKey((Object)editor);
        this.memorized.put(NameTypePair.fromParameter(param), editor.getValue());
    }

    public void writeConfigState(SaveState saveState) {
        SaveState subState = new SaveState();
        for (Map.Entry<NameTypePair, Object> ent : this.memorized.entrySet()) {
            NameTypePair ntp = ent.getKey();
            AutoConfigState.ConfigStateField.putState((SaveState)subState, ntp.getType().asSubclass(Object.class), (String)ntp.getName(), (Object)ent.getValue());
        }
        saveState.putXmlElement(KEY_MEMORIZED_ARGUMENTS, subState.saveToXml());
    }

    public void readConfigState(SaveState saveState) {
        Element element = saveState.getXmlElement(KEY_MEMORIZED_ARGUMENTS);
        if (element == null) {
            return;
        }
        SaveState subState = new SaveState(element);
        for (String name : subState.getNames()) {
            try {
                NameTypePair ntp = NameTypePair.fromString(name);
                this.memorized.put(ntp, AutoConfigState.ConfigStateField.getState((SaveState)subState, ntp.getType(), (String)ntp.getName()));
            }
            catch (Exception e) {
                Msg.error((Object)this, (Object)("Error restoring memorized parameter " + name), (Throwable)e);
            }
        }
    }

    static final class NameTypePair
    extends MutablePair<String, Class<?>> {
        public static NameTypePair fromParameter(TargetMethod.ParameterDescription<?> parameter) {
            return new NameTypePair(parameter.name, parameter.type);
        }

        public static NameTypePair fromString(String name) throws ClassNotFoundException {
            String[] parts = name.split(",", 2);
            if (parts.length != 2) {
                return new NameTypePair(parts[0], String.class);
            }
            return new NameTypePair(parts[0], Class.forName(parts[1]));
        }

        public NameTypePair(String name, Class<?> type) {
            super((Object)name, type);
        }

        public String toString() {
            return this.getName() + "," + this.getType().getName();
        }

        public Class<?> setValue(Class<?> value) {
            throw new UnsupportedOperationException();
        }

        public String getName() {
            return (String)this.getLeft();
        }

        public Class<?> getType() {
            return (Class)this.getRight();
        }
    }
}

