/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.objects.components;

import ghidra.app.plugin.core.debug.gui.objects.components.ObjectElementRow;
import ghidra.app.plugin.core.debug.gui.objects.components.ObjectEnumeratedColumnTableModel;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;

public class ObjectElementColumn
implements ObjectEnumeratedColumnTableModel.ObjectsEnumeratedTableColumn<ObjectElementColumn, ObjectElementRow> {
    private final String header;
    private final Function<ObjectElementRow, ?> getter;

    public ObjectElementColumn(String header, Function<ObjectElementRow, Object> getter) {
        this.header = header;
        this.getter = getter;
    }

    @Override
    public String getHeader() {
        return this.header;
    }

    @Override
    public Object getValueOf(ObjectElementRow row) {
        row.setCurrentKey(this.header);
        return this.getter.apply(row);
    }

    public static ObjectEnumeratedColumnTableModel.ObjectsEnumeratedTableColumn<ObjectElementColumn, ? super ObjectElementRow>[] generateColumns(List<String> keys) {
        keys.sort(Comparator.comparing(String::toString));
        ObjectElementColumn[] array = new ObjectElementColumn[keys.size()];
        int i = 0;
        for (String k : keys) {
            ObjectElementColumn col = new ObjectElementColumn(k, ObjectElementRow::getValue);
            array[i++] = col;
        }
        return array;
    }
}

