/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.register;

import com.google.common.collect.Range;
import docking.ActionContext;
import docking.ComponentProvider;
import docking.DialogComponentProvider;
import docking.Tool;
import docking.WindowPosition;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.ToggleDockingAction;
import docking.action.builder.ActionBuilder;
import docking.action.builder.ToggleActionBuilder;
import docking.actions.PopupActionProvider;
import docking.widgets.table.ColumnSortState;
import docking.widgets.table.DefaultEnumeratedColumnTableModel;
import docking.widgets.table.GTable;
import docking.widgets.table.GTableCellRenderingData;
import docking.widgets.table.HexBigIntegerTableCellEditor;
import docking.widgets.table.HexBigIntegerTableCellRenderer;
import docking.widgets.table.RowObjectTableModel;
import ghidra.app.plugin.core.debug.DebuggerCoordinates;
import ghidra.app.plugin.core.debug.gui.DebuggerProvider;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.register.DebuggerAvailableRegistersDialog;
import ghidra.app.plugin.core.debug.gui.register.DebuggerRegisterActionContext;
import ghidra.app.plugin.core.debug.gui.register.DebuggerRegistersPlugin;
import ghidra.app.plugin.core.debug.gui.register.RegisterRow;
import ghidra.app.plugin.core.debug.mapping.DebuggerRegisterMapper;
import ghidra.app.services.DebuggerListingService;
import ghidra.app.services.DebuggerModelService;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.app.services.MarkerService;
import ghidra.app.services.TraceRecorder;
import ghidra.app.services.TraceRecorderListener;
import ghidra.async.AsyncLazyValue;
import ghidra.async.AsyncUtils;
import ghidra.base.widgets.table.DataTypeTableCellEditor;
import ghidra.dbg.error.DebuggerModelAccessException;
import ghidra.dbg.target.TargetRegisterBank;
import ghidra.dbg.target.TargetThread;
import ghidra.framework.model.DomainObjectChangeRecord;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.model.UndoableDomainObject;
import ghidra.framework.options.AutoOptions;
import ghidra.framework.options.SaveState;
import ghidra.framework.options.annotation.AutoOptionConsumed;
import ghidra.framework.options.annotation.AutoOptionDefined;
import ghidra.framework.options.annotation.HelpInfo;
import ghidra.framework.plugintool.AutoService;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.annotation.AutoServiceConsumed;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeConflictException;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageCompilerSpecPair;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceAddressSnapRange;
import ghidra.trace.model.TraceDomainObjectListener;
import ghidra.trace.model.listing.TraceCodeRegisterSpace;
import ghidra.trace.model.listing.TraceCodeUnit;
import ghidra.trace.model.listing.TraceData;
import ghidra.trace.model.memory.TraceMemoryRegisterSpace;
import ghidra.trace.model.memory.TraceMemoryState;
import ghidra.trace.model.program.TraceProgramView;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.model.time.schedule.TraceSchedule;
import ghidra.trace.util.TraceAddressSpace;
import ghidra.trace.util.TraceChangeType;
import ghidra.trace.util.TraceRegisterUtils;
import ghidra.trace.util.TraceTimeViewport;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.data.DataTypeParser;
import ghidra.util.database.UndoableTransaction;
import ghidra.util.exception.CancelledException;
import ghidra.util.table.GhidraTable;
import ghidra.util.table.GhidraTableFilterPanel;
import ghidra.util.task.TaskMonitor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class DebuggerRegistersProvider
extends ComponentProviderAdapter
implements DebuggerProvider,
PopupActionProvider {
    private static final String KEY_DEBUGGER_COORDINATES = "DebuggerCoordinates";
    final DebuggerRegistersPlugin plugin;
    private final Map<LanguageCompilerSpecPair, LinkedHashSet<Register>> selectionByCSpec;
    private final Map<LanguageCompilerSpecPair, LinkedHashSet<Register>> favoritesByCSpec;
    private final boolean isClone;
    DebuggerCoordinates previous = DebuggerCoordinates.NOWHERE;
    DebuggerCoordinates current = DebuggerCoordinates.NOWHERE;
    private AsyncLazyValue<Void> readTheseCoords = new AsyncLazyValue(this::readRegistersIfLiveAndAccessible);
    private Trace currentTrace;
    private TraceRecorder currentRecorder;
    @AutoServiceConsumed
    private DebuggerModelService modelService;
    @AutoServiceConsumed
    private DebuggerTraceManagerService traceManager;
    @AutoServiceConsumed
    private DebuggerListingService listingService;
    @AutoServiceConsumed
    private MarkerService markerService;
    private final AutoService.Wiring autoServiceWiring;
    @AutoOptionDefined(name={"Colors.Stale Registers"}, description="Text color for registers whose value is not known", help=@HelpInfo(anchor="colors"))
    protected Color registerStaleColor = DebuggerResources.DEFAULT_COLOR_REGISTER_STALE;
    @AutoOptionDefined(name={"Colors.Stale Registers (selected)"}, description="Selected text color for registers whose value is not known", help=@HelpInfo(anchor="colors"))
    protected Color registerStaleSelColor = DebuggerResources.DEFAULT_COLOR_REGISTER_STALE_SEL;
    @AutoOptionDefined(name={"Colors.Changed Registers"}, description="Text color for registers whose value just changed", help=@HelpInfo(anchor="colors"))
    protected Color registerChangesColor = DebuggerResources.DEFAULT_COLOR_REGISTER_CHANGED;
    @AutoOptionDefined(name={"Colors.Changed Registers (selected)"}, description="Selected text color for registers whose value just changed", help=@HelpInfo(anchor="colors"))
    protected Color registerChangesSelColor = DebuggerResources.DEFAULT_COLOR_REGISTER_CHANGED_SEL;
    private final AutoOptions.Wiring autoOptionsWiring;
    private final TraceChangeListener traceChangeListener = new TraceChangeListener();
    private final RegAccessListener regAccessListener = new RegAccessListener();
    private JPanel mainPanel = new JPanel(new BorderLayout());
    GhidraTable regsTable;
    RegistersTableModel regsTableModel = new RegistersTableModel();
    private GhidraTableFilterPanel<RegisterRow> regsFilterPanel;
    Map<Register, RegisterRow> regMap = new HashMap<Register, RegisterRow>();
    private final DebuggerAvailableRegistersDialog availableRegsDialog;
    DockingAction actionSelectRegisters;
    DockingAction actionCreateSnapshot;
    ToggleDockingAction actionEnableEdits;
    DockingAction actionClearDataType;
    DebuggerRegisterActionContext myActionContext;
    AddressSetView viewKnown;
    AddressSetView catalog;

    protected static boolean sameCoordinates(DebuggerCoordinates a, DebuggerCoordinates b) {
        if (!Objects.equals(a.getTrace(), b.getTrace())) {
            return false;
        }
        if (!Objects.equals(a.getRecorder(), b.getRecorder())) {
            return false;
        }
        if (!Objects.equals(a.getThread(), b.getThread())) {
            return false;
        }
        if (!Objects.equals(a.getTime(), b.getTime())) {
            return false;
        }
        return Objects.equals(a.getFrame(), b.getFrame());
    }

    protected DebuggerRegistersProvider(DebuggerRegistersPlugin plugin, Map<LanguageCompilerSpecPair, LinkedHashSet<Register>> selectionByCSpec, Map<LanguageCompilerSpecPair, LinkedHashSet<Register>> favoritesByCSpec, boolean isClone) {
        super(plugin.getTool(), "Registers", plugin.getName());
        this.plugin = plugin;
        this.selectionByCSpec = selectionByCSpec;
        this.favoritesByCSpec = favoritesByCSpec;
        this.isClone = isClone;
        this.autoServiceWiring = AutoService.wireServicesConsumed((Plugin)plugin, (Object)this);
        this.autoOptionsWiring = AutoOptions.wireOptions((Plugin)plugin, (Object)this);
        this.setIcon(DebuggerResources.ICON_PROVIDER_REGISTERS);
        this.setHelpLocation(DebuggerResources.HELP_PROVIDER_REGISTERS);
        this.setWindowMenuGroup("Debugger");
        this.buildMainPanel();
        plugin.getTool().addPopupActionProvider((PopupActionProvider)this);
        this.availableRegsDialog = new DebuggerAvailableRegistersDialog(this);
        this.setDefaultWindowPosition(WindowPosition.RIGHT);
        this.createActions();
        if (isClone) {
            this.setTitle("[Registers]");
            this.setWindowGroup("Debugger.Core.disconnected");
            this.setIntraGroupPosition(WindowPosition.STACK);
            this.mainPanel.setBorder(BorderFactory.createLineBorder(Color.ORANGE, 2));
            this.setTransient();
        } else {
            this.setTitle("Registers");
            this.setWindowGroup("Debugger.Core");
        }
        this.setVisible(true);
        this.contextChanged();
    }

    public void removeFromTool() {
        this.plugin.providerRemoved(this);
        this.plugin.getTool().removePopupActionProvider((PopupActionProvider)this);
        super.removeFromTool();
    }

    protected void buildMainPanel() {
        this.regsTable = new GhidraTable((TableModel)((Object)this.regsTableModel));
        this.mainPanel.add(new JScrollPane((Component)this.regsTable));
        this.regsFilterPanel = new GhidraTableFilterPanel((JTable)this.regsTable, (RowObjectTableModel)this.regsTableModel);
        this.mainPanel.add((Component)this.regsFilterPanel, "South");
        this.regsTable.getSelectionModel().addListSelectionListener(evt -> {
            this.myActionContext = new DebuggerRegisterActionContext(this, (RegisterRow)this.regsFilterPanel.getSelectedItem(), (GTable)this.regsTable);
            this.contextChanged();
        });
        this.regsTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    DebuggerRegistersProvider.this.navigateToAddress();
                }
            }
        });
        this.regsTable.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    DebuggerRegistersProvider.this.navigateToAddress();
                }
            }
        });
        TableColumnModel columnModel = this.regsTable.getColumnModel();
        TableColumn favCol = columnModel.getColumn(RegisterTableColumns.FAV.ordinal());
        favCol.setPreferredWidth(1);
        TableColumn numCol = columnModel.getColumn(RegisterTableColumns.NUMBER.ordinal());
        numCol.setPreferredWidth(1);
        TableColumn nameCol = columnModel.getColumn(RegisterTableColumns.NAME.ordinal());
        nameCol.setPreferredWidth(40);
        TableColumn valCol = columnModel.getColumn(RegisterTableColumns.VALUE.ordinal());
        valCol.setCellRenderer((TableCellRenderer)((Object)new RegisterValueCellRenderer()));
        valCol.setCellEditor((TableCellEditor)new HexBigIntegerTableCellEditor());
        valCol.setPreferredWidth(100);
        TableColumn typeCol = columnModel.getColumn(RegisterTableColumns.TYPE.ordinal());
        typeCol.setCellEditor((TableCellEditor)((Object)new RegisterDataTypeEditor()));
        typeCol.setPreferredWidth(50);
        TableColumn reprCol = columnModel.getColumn(RegisterTableColumns.REPR.ordinal());
        reprCol.setPreferredWidth(100);
    }

    public List<DockingActionIf> getPopupActions(Tool t, ActionContext context) {
        if (context != this.myActionContext || context == null || this.listingService == null) {
            return List.of();
        }
        Register register = this.myActionContext.getSelected().getRegister();
        BigInteger value = this.getRegisterValue(register);
        if (value == null) {
            return List.of();
        }
        long lv = value.longValue();
        ArrayList<DockingActionIf> result = new ArrayList<DockingActionIf>();
        String pluginName = this.plugin.getName();
        for (AddressSpace space : this.currentTrace.getBaseAddressFactory().getAddressSpaces()) {
            Address address;
            if (space.isRegisterSpace()) continue;
            try {
                address = space.getAddress(lv, true);
            }
            catch (AddressOutOfBoundsException e) {
                continue;
            }
            if (this.currentTrace.getMemoryManager().getRegionContaining(this.current.getSnap().longValue(), address) == null) continue;
            String name = "Goto " + address.toString(true);
            result.add((DockingActionIf)((ActionBuilder)((ActionBuilder)new ActionBuilder(name, pluginName).popupMenuPath(new String[]{name})).onAction(ctx -> {
                if (this.listingService == null) {
                    return;
                }
                this.listingService.goTo(address, true);
            })).build());
        }
        return result;
    }

    protected void navigateToAddress() {
        if (this.listingService == null || this.myActionContext == null) {
            return;
        }
        RegisterRow row = this.myActionContext.getSelected();
        TraceData data = this.getRegisterData(row.getRegister());
        if (data == null || data.getValueClass() != Address.class) {
            return;
        }
        Address address = (Address)TraceRegisterUtils.getValueHackPointer((TraceData)data);
        if (address == null) {
            return;
        }
        this.listingService.goTo(address, true);
    }

    @Override
    public ActionContext getActionContext(MouseEvent event) {
        if (this.myActionContext == null) {
            return super.getActionContext(event);
        }
        return this.myActionContext;
    }

    protected void createActions() {
        this.actionSelectRegisters = (DockingAction)((ActionBuilder)((ActionBuilder)DebuggerResources.SelectRegistersAction.builder(this.plugin).enabledWhen(c -> this.current.getThread() != null)).onAction(c -> this.selectRegistersActivated())).buildAndInstallLocal((ComponentProvider)this);
        if (!this.isClone) {
            this.actionCreateSnapshot = (DockingAction)((ActionBuilder)((ActionBuilder)DebuggerResources.CreateSnapshotAction.builder(this.plugin).enabledWhen(c -> this.current.getThread() != null)).onAction(c -> this.createSnapshotActivated())).buildAndInstallLocal((ComponentProvider)this);
        }
        this.actionEnableEdits = (ToggleDockingAction)((ToggleActionBuilder)((ToggleActionBuilder)DebuggerResources.EnableEditsAction.builder(this.plugin).enabledWhen(c -> this.current.getThread() != null)).onAction(c -> {})).buildAndInstallLocal((ComponentProvider)this);
        this.actionClearDataType = (DockingAction)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Clear Register Type", this.plugin.getName()).enabledWhen(c -> this.current.getThread() != null)).keyBinding(KeyStroke.getKeyStroke(127, 0))).onAction(c -> this.clearDataTypeActivated())).buildAndInstallLocal((ComponentProvider)this);
    }

    private void selectRegistersActivated() {
        TraceThread curThread = this.current.getThread();
        if (curThread == null) {
            return;
        }
        this.availableRegsDialog.setLanguage(curThread.getTrace().getBaseLanguage());
        LinkedHashSet<Register> viewKnown = this.computeDefaultRegisterSelection(curThread);
        this.availableRegsDialog.setKnown(viewKnown);
        Set<Register> selection = this.getSelectionFor(curThread);
        this.availableRegsDialog.setSelection(selection);
        this.tool.showDialog((DialogComponentProvider)this.availableRegsDialog);
    }

    private void createSnapshotActivated() {
        DebuggerRegistersProvider clone = this.cloneAsDisconnected();
        clone.setIntraGroupPosition(WindowPosition.RIGHT);
        this.tool.showComponentProvider((ComponentProvider)clone, true);
    }

    private void clearDataTypeActivated() {
        if (this.myActionContext == null) {
            return;
        }
        RegisterRow row = this.myActionContext.getSelected();
        row.setDataType(null);
    }

    public JComponent getComponent() {
        return this.mainPanel;
    }

    public boolean isSnapshot() {
        return this.isClone;
    }

    protected String computeSubTitle() {
        TraceThread curThread = this.current.getThread();
        return curThread == null ? "" : curThread.getName();
    }

    protected void updateSubTitle() {
        this.setSubTitle(this.computeSubTitle());
    }

    private void removeOldTraceListener() {
        if (this.currentTrace == null) {
            return;
        }
        this.currentTrace.removeListener((DomainObjectListener)this.traceChangeListener);
    }

    private void addNewTraceListener() {
        if (this.currentTrace == null) {
            return;
        }
        this.currentTrace.addListener((DomainObjectListener)this.traceChangeListener);
    }

    private void doSetTrace(Trace trace) {
        if (this.currentTrace == trace) {
            return;
        }
        this.actionEnableEdits.setSelected(false);
        this.removeOldTraceListener();
        this.currentTrace = trace;
        this.addNewTraceListener();
        this.catalogRegisterAddresses();
    }

    private void catalogRegisterAddresses() {
        this.catalog = null;
        if (this.currentTrace == null) {
            return;
        }
        AddressSet catalog = new AddressSet();
        for (Register reg : this.currentTrace.getBaseLanguage().getRegisters()) {
            catalog.add(TraceRegisterUtils.rangeForRegister((Register)reg));
        }
        this.catalog = catalog;
    }

    private void removeOldRecorderListener() {
        if (this.currentRecorder == null) {
            return;
        }
        this.currentRecorder.removeListener(this.regAccessListener);
    }

    private void addNewRecorderListener() {
        if (this.currentRecorder == null) {
            return;
        }
        this.currentRecorder.addListener(this.regAccessListener);
    }

    private void doSetRecorder(TraceRecorder recorder) {
        if (this.currentRecorder == recorder) {
            return;
        }
        this.removeOldRecorderListener();
        this.currentRecorder = recorder;
        this.addNewRecorderListener();
    }

    public void coordinatesActivated(DebuggerCoordinates coordinates) {
        if (DebuggerRegistersProvider.sameCoordinates(this.current, coordinates)) {
            this.current = coordinates;
            return;
        }
        this.previous = this.current;
        this.current = coordinates;
        this.readTheseCoords = new AsyncLazyValue(this::readRegistersIfLiveAndAccessible);
        this.doSetTrace(this.current.getTrace());
        this.doSetRecorder(this.current.getRecorder());
        this.updateSubTitle();
        this.recomputeViewKnown();
        this.loadRegistersAndValues();
        this.contextChanged();
    }

    protected void traceClosed(Trace trace) {
        if (this.isClone && this.current.getTrace() == trace) {
            this.coordinatesActivated(DebuggerCoordinates.NOWHERE);
            this.removeFromTool();
        }
    }

    boolean canWriteTarget() {
        if (!this.current.isAliveAndPresent()) {
            return false;
        }
        TraceRecorder recorder = this.current.getRecorder();
        TargetRegisterBank targetRegs = recorder.getTargetRegisterBank(this.current.getThread(), this.current.getFrame());
        return targetRegs != null;
    }

    boolean canWriteRegister(Register register) {
        if (!this.isEditsEnabled()) {
            return false;
        }
        return !register.isProcessorContext();
    }

    boolean canWriteTargetRegister(Register register) {
        if (!this.isEditsEnabled()) {
            return false;
        }
        if (!this.canWriteTarget()) {
            return false;
        }
        return this.current.getRecorder().isRegisterOnTarget(this.current.getThread(), register);
    }

    BigInteger getRegisterValue(Register register) {
        TraceMemoryRegisterSpace regs = this.getRegisterMemorySpace(false);
        if (regs == null) {
            return BigInteger.ZERO;
        }
        return regs.getViewValue(this.current.getViewSnap(), register).getUnsignedValue();
    }

    void writeRegisterValue(Register register, BigInteger value) {
        this.writeRegisterValue(new RegisterValue(register, value));
    }

    void writeRegisterValue(RegisterValue rv) {
        if (this.canWriteTargetRegister(rv.getRegister())) {
            rv = this.combineWithTraceBaseRegisterValue(rv);
            CompletableFuture<Void> future = this.current.getRecorder().writeThreadRegisters(this.current.getThread(), this.current.getFrame(), Map.of(rv.getRegister(), rv));
            future.exceptionally(ex -> {
                if ((ex = AsyncUtils.unwrapThrowable((Throwable)ex)) instanceof DebuggerModelAccessException) {
                    Msg.error((Object)this, (Object)"Could not write target register", (Throwable)ex);
                    this.plugin.getTool().setStatusInfo("Could not write target register: " + ex.getMessage());
                } else {
                    Msg.showError((Object)this, (Component)this.getComponent(), (String)"Edit Register", (Object)"Could not write target register", (Throwable)ex);
                }
                return null;
            });
            return;
        }
        TraceSchedule time = this.current.getTime().patched(this.current.getThread(), this.generateSleigh(rv));
        this.traceManager.activateTime(time);
    }

    protected String generateSleigh(RegisterValue rv) {
        return String.format("%s=0x%s", rv.getRegister(), rv.getUnsignedValue().toString(16));
    }

    private RegisterValue combineWithTraceBaseRegisterValue(RegisterValue rv) {
        TraceMemoryRegisterSpace regs = this.getRegisterMemorySpace(false);
        long snap = this.current.getSnap();
        return TraceRegisterUtils.combineWithTraceBaseRegisterValue((RegisterValue)rv, (long)snap, (TraceMemoryRegisterSpace)regs, (boolean)true);
    }

    void writeRegisterDataType(Register register, DataType dataType) {
        try (UndoableTransaction tid = UndoableTransaction.start((UndoableDomainObject)this.current.getTrace(), (String)"Edit Register Type", (boolean)false);){
            TraceCodeRegisterSpace space = this.getRegisterMemorySpace(true).getCodeSpace(true);
            long snap = this.current.getSnap();
            space.definedUnits().clear(Range.closed((Comparable)Long.valueOf(snap), (Comparable)Long.valueOf(snap)), register, TaskMonitor.DUMMY);
            if (dataType != null) {
                space.definedData().create(Range.atLeast((Comparable)Long.valueOf(snap)), register, dataType);
            }
            tid.commit();
        }
        catch (DataTypeConflictException | CodeUnitInsertionException | CancelledException e) {
            throw new AssertionError((Object)e);
        }
    }

    TraceData getRegisterData(Register register) {
        TraceCodeRegisterSpace space = this.getRegisterCodeSpace(false);
        if (space == null) {
            return null;
        }
        long snap = this.current.getSnap();
        return (TraceData)space.definedData().getForRegister(snap, register);
    }

    DataType getRegisterDataType(Register register) {
        TraceData data = this.getRegisterData(register);
        if (data == null) {
            return null;
        }
        return data.getDataType();
    }

    String getRegisterValueRepresentation(Register register) {
        TraceData data = this.getRegisterData(register);
        if (data == null) {
            return null;
        }
        return TraceRegisterUtils.getValueRepresentationHackPointer((TraceData)data);
    }

    void recomputeViewKnown() {
        if (this.catalog == null) {
            this.viewKnown = null;
            return;
        }
        TraceMemoryRegisterSpace regs = this.getRegisterMemorySpace(false);
        TraceProgramView view = this.current.getView();
        if (regs == null || view == null) {
            this.viewKnown = null;
            return;
        }
        this.viewKnown = new AddressSet(view.getViewport().unionedAddresses(snap -> regs.getAddressesWithState(snap.longValue(), this.catalog, state -> state == TraceMemoryState.KNOWN)));
    }

    boolean isRegisterKnown(Register register) {
        if (this.viewKnown == null) {
            return false;
        }
        AddressRange range = TraceRegisterUtils.rangeForRegister((Register)register);
        return this.viewKnown.contains(range.getMinAddress(), range.getMaxAddress());
    }

    boolean isRegisterChanged(Register register) {
        RegisterValue prevRegVal;
        if (this.previous.getThread() == null || this.current.getThread() == null) {
            return false;
        }
        if (this.previous.getTrace().getBaseLanguage() != this.current.getTrace().getBaseLanguage()) {
            return false;
        }
        if (!this.isRegisterKnown(register)) {
            return false;
        }
        TraceMemoryRegisterSpace curSpace = DebuggerRegistersProvider.getRegisterMemorySpace(this.current, false);
        TraceMemoryRegisterSpace prevSpace = DebuggerRegistersProvider.getRegisterMemorySpace(this.previous, false);
        if (prevSpace == null) {
            return false;
        }
        RegisterValue curRegVal = curSpace.getViewValue(this.current.getViewSnap(), register);
        return !Objects.equals(curRegVal, prevRegVal = prevSpace.getViewValue(this.previous.getViewSnap(), register));
    }

    private boolean isEditsEnabled() {
        return this.actionEnableEdits.isSelected();
    }

    public static LinkedHashSet<Register> collectCommonRegisters(CompilerSpec cSpec) {
        Language lang = cSpec.getLanguage();
        LinkedHashSet<Register> result = new LinkedHashSet<Register>();
        result.add(cSpec.getStackPointer());
        result.add(lang.getProgramCounter());
        for (Register reg : lang.getRegisters()) {
            if (reg.isProcessorContext()) continue;
            result.add(reg);
        }
        return result;
    }

    public LinkedHashSet<Register> computeDefaultRegisterSelection(TraceThread thread) {
        return DebuggerRegistersProvider.collectCommonRegisters(thread.getTrace().getBaseCompilerSpec());
    }

    public LinkedHashSet<Register> computeDefaultRegisterFavorites(TraceThread thread) {
        LinkedHashSet<Register> favorites = new LinkedHashSet<Register>();
        CompilerSpec cSpec = thread.getTrace().getBaseCompilerSpec();
        favorites.add(cSpec.getLanguage().getProgramCounter());
        favorites.add(cSpec.getStackPointer());
        return favorites;
    }

    public LinkedHashSet<Register> computeDefaultRegistersOld(TraceThread thread) {
        LinkedHashSet<Register> viewKnown = new LinkedHashSet<Register>();
        viewKnown.addAll(this.collectBaseRegistersWithKnownValues(thread));
        Trace trace = thread.getTrace();
        TraceRecorder recorder = this.modelService.getRecorder(trace);
        if (recorder == null) {
            viewKnown.addAll(DebuggerRegistersProvider.collectCommonRegisters(trace.getBaseCompilerSpec()));
            return viewKnown;
        }
        TargetThread targetThread = recorder.getTargetThread(thread);
        if (targetThread == null || !recorder.isRegisterBankAccessible(thread, 0)) {
            return viewKnown;
        }
        DebuggerRegisterMapper regMapper = recorder.getRegisterMapper(thread);
        if (regMapper == null) {
            return viewKnown;
        }
        for (Register onTarget : regMapper.getRegistersOnTarget()) {
            viewKnown.add(onTarget);
            viewKnown.addAll(onTarget.getChildRegisters());
        }
        return viewKnown;
    }

    protected static TraceMemoryRegisterSpace getRegisterMemorySpace(DebuggerCoordinates coords, boolean createIfAbsent) {
        TraceThread thread = coords.getThread();
        if (thread == null) {
            return null;
        }
        return coords.getTrace().getMemoryManager().getMemoryRegisterSpace(thread, coords.getFrame().intValue(), createIfAbsent);
    }

    protected TraceMemoryRegisterSpace getRegisterMemorySpace(boolean createIfAbsent) {
        return DebuggerRegistersProvider.getRegisterMemorySpace(this.current, createIfAbsent);
    }

    protected TraceCodeRegisterSpace getRegisterCodeSpace(boolean createIfAbsent) {
        TraceThread curThread = this.current.getThread();
        if (curThread == null) {
            return null;
        }
        return this.current.getTrace().getCodeManager().getCodeRegisterSpace(curThread, this.current.getFrame().intValue(), createIfAbsent);
    }

    protected Set<Register> collectBaseRegistersWithKnownValues(TraceThread thread) {
        TraceMemoryRegisterSpace mem = thread.getTrace().getMemoryManager().getMemoryRegisterSpace(thread, false);
        LinkedHashSet<Register> result = new LinkedHashSet<Register>();
        if (mem == null) {
            return result;
        }
        AddressSpace regSpace = thread.getTrace().getBaseLanguage().getAddressFactory().getRegisterSpace();
        AddressSet everKnown = new AddressSet();
        for (Map.Entry entry : mem.getMostRecentStates(thread.getTrace().getTimeManager().getMaxSnap().longValue(), (AddressRange)new AddressRangeImpl(regSpace.getMinAddress(), regSpace.getMaxAddress()))) {
            everKnown.add(((TraceAddressSnapRange)entry.getKey()).getRange());
        }
        for (Register reg : thread.getRegisters()) {
            AddressRange regRange;
            if (!reg.isBaseRegister() || !everKnown.intersects((regRange = TraceRegisterUtils.rangeForRegister((Register)reg)).getMinAddress(), regRange.getMaxAddress()) || !reg.isBaseRegister()) continue;
            result.add(reg);
        }
        return result;
    }

    protected LanguageCompilerSpecPair getLangCSpecPair(Trace trace) {
        return new LanguageCompilerSpecPair(trace.getBaseLanguage().getLanguageID(), trace.getBaseCompilerSpec().getCompilerSpecID());
    }

    protected LanguageCompilerSpecPair getLangCSpecPair(TraceThread thread) {
        return this.getLangCSpecPair(thread.getTrace());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<Register> getSelectionFor(TraceThread thread) {
        Map<LanguageCompilerSpecPair, LinkedHashSet<Register>> map = this.selectionByCSpec;
        synchronized (map) {
            LanguageCompilerSpecPair lcsp = this.getLangCSpecPair(thread);
            return this.selectionByCSpec.computeIfAbsent(lcsp, __ -> this.computeDefaultRegisterSelection(thread));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<Register> getFavoritesFor(TraceThread thread) {
        Map<LanguageCompilerSpecPair, LinkedHashSet<Register>> map = this.favoritesByCSpec;
        synchronized (map) {
            LanguageCompilerSpecPair lcsp = this.getLangCSpecPair(thread);
            return this.favoritesByCSpec.computeIfAbsent(lcsp, __ -> this.computeDefaultRegisterFavorites(thread));
        }
    }

    protected void setFavorite(Register register, boolean favorite) {
        Set<Register> favorites = this.getFavoritesFor(this.current.getThread());
        if (favorite) {
            favorites.add(register);
        } else {
            favorites.remove(register);
        }
    }

    public boolean isFavorite(Register register) {
        Set<Register> favorites = this.getFavoritesFor(this.current.getThread());
        return favorites.contains(register);
    }

    public CompletableFuture<Void> setSelectedRegistersAndLoad(Collection<Register> selectedRegisters) {
        Set<Register> selection = this.getSelectionFor(this.current.getThread());
        selection.clear();
        selection.addAll(new TreeSet<Register>(selectedRegisters));
        return this.loadRegistersAndValues();
    }

    public DebuggerRegistersProvider cloneAsDisconnected() {
        DebuggerRegistersProvider clone = this.plugin.createNewDisconnectedProvider();
        clone.coordinatesActivated(this.current);
        return clone;
    }

    protected void displaySelectedRegisters(Set<Register> selected) {
        List regs = this.currentTrace.getBaseLanguage().getRegisters();
        Iterator<Map.Entry<Register, RegisterRow>> it = this.regMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Register, RegisterRow> ent = it.next();
            if (selected.contains(ent.getKey())) continue;
            this.regsTableModel.delete(ent.getValue());
            it.remove();
        }
        for (Register reg : selected) {
            this.regMap.computeIfAbsent(reg, r -> {
                RegisterRow row = new RegisterRow(this, regs.indexOf(reg), reg);
                this.regsTableModel.add(row);
                return row;
            });
        }
    }

    protected CompletableFuture<Void> loadRegistersAndValues() {
        TraceThread curThread = this.current.getThread();
        if (curThread == null) {
            this.regsTableModel.clear();
            this.regMap.clear();
            return AsyncUtils.NIL;
        }
        Set<Register> selected = this.getSelectionFor(curThread);
        this.displaySelectedRegisters(selected);
        return this.loadValues();
    }

    protected CompletableFuture<Void> loadValues() {
        TraceThread curThread = this.current.getThread();
        if (curThread == null) {
            return AsyncUtils.NIL;
        }
        this.regsTableModel.fireTableDataChanged();
        return this.readTheseCoords.request();
    }

    private Set<Register> baseRegisters(Set<Register> regs) {
        return regs.stream().filter(Register::isBaseRegister).collect(Collectors.toSet());
    }

    protected CompletableFuture<Void> readRegistersIfLiveAndAccessible() {
        TraceRecorder recorder = this.current.getRecorder();
        if (recorder == null) {
            return AsyncUtils.NIL;
        }
        if (recorder.getSnap() != this.current.getSnap().longValue()) {
            return AsyncUtils.NIL;
        }
        if (this.current.getFrame() == 0) {
            return AsyncUtils.NIL;
        }
        TraceThread traceThread = this.current.getThread();
        TargetThread targetThread = recorder.getTargetThread(traceThread);
        if (targetThread == null) {
            return AsyncUtils.NIL;
        }
        HashSet<Register> toRead = new HashSet<Register>(this.baseRegisters(this.getSelectionFor(traceThread)));
        DebuggerRegisterMapper regMapper = recorder.getRegisterMapper(traceThread);
        if (regMapper == null) {
            Msg.error((Object)this, (Object)"Target is live, but we haven't got a register mapper, yet");
            return AsyncUtils.NIL;
        }
        toRead.retainAll(regMapper.getRegistersOnTarget());
        TargetRegisterBank bank = recorder.getTargetRegisterBank(traceThread, this.current.getFrame());
        if (bank == null || !bank.isValid()) {
            Msg.error((Object)this, (Object)"Current frame's bank does not exist");
            return AsyncUtils.NIL;
        }
        CompletableFuture<Map<Register, RegisterValue>> future = recorder.captureThreadRegisters(traceThread, this.current.getFrame(), toRead);
        return ((CompletableFuture)future.exceptionally(ex -> {
            if ((ex = AsyncUtils.unwrapThrowable((Throwable)ex)) instanceof DebuggerModelAccessException) {
                String msg = "Could not read target registers for selected thread: " + ex.getMessage();
                Msg.info((Object)this, (Object)msg);
                this.plugin.getTool().setStatusInfo(msg);
            } else {
                Msg.showError((Object)this, (Component)this.getComponent(), (String)"Read Target Registers", (Object)"Could not read target registers for selected thread", (Throwable)ex);
            }
            return ExceptionUtils.rethrow((Throwable)ex);
        })).thenApply(__ -> null);
    }

    private void repaintTable() {
        if (this.regsTable != null) {
            this.regsTable.repaint();
        }
    }

    @AutoOptionConsumed(name={"Colors.Stale Registers"})
    private void setRegisterStaleColor(Color color) {
        this.repaintTable();
    }

    @AutoOptionConsumed(name={"Colors.Stale Registers (selected)"})
    private void setRegisterStaleSelColor(Color color) {
        this.repaintTable();
    }

    @AutoOptionConsumed(name={"Colors.Changed Registers"})
    private void setRegisterChangesColor(Color color) {
        this.repaintTable();
    }

    @AutoOptionConsumed(name={"Colors.Changed Registers (selected)"})
    private void setRegisterChangesSelColor(Color color) {
        this.repaintTable();
    }

    protected String formatAddressInfo(Address address) {
        return address.toString();
    }

    public void writeDataState(SaveState saveState) {
        if (this.isClone) {
            this.current.writeDataState(this.tool, saveState, KEY_DEBUGGER_COORDINATES);
        }
    }

    public void readDataState(SaveState saveState) {
        if (this.isClone) {
            this.coordinatesActivated(DebuggerCoordinates.readDataState(this.tool, saveState, KEY_DEBUGGER_COORDINATES, true));
        }
    }

    class RegisterDataTypeEditor
    extends DataTypeTableCellEditor {
        public RegisterDataTypeEditor() {
            super(DebuggerRegistersProvider.this.plugin.getTool());
        }

        protected DataTypeParser.AllowedDataTypes getAllowed(int row, int column) {
            return DataTypeParser.AllowedDataTypes.FIXED_LENGTH;
        }

        protected boolean validateSelection(DataType dataType) {
            RegisterRow row = (RegisterRow)DebuggerRegistersProvider.this.regsTableModel.getModelData().get(DebuggerRegistersProvider.this.regsTable.getEditingRow());
            if (row == null) {
                return false;
            }
            return dataType.getLength() == row.getRegister().getMinimumByteSize();
        }

        protected DataType resolveSelection(DataType dataType) {
            if (dataType == null) {
                return null;
            }
            try (UndoableTransaction tid = UndoableTransaction.start((UndoableDomainObject)DebuggerRegistersProvider.this.currentTrace, (String)"Resolve DataType", (boolean)true);){
                DataType dataType2 = DebuggerRegistersProvider.this.currentTrace.getDataTypeManager().resolve(dataType, null);
                return dataType2;
            }
        }
    }

    class RegisterValueCellRenderer
    extends HexBigIntegerTableCellRenderer {
        RegisterValueCellRenderer() {
        }

        public final Component getTableCellRendererComponent(GTableCellRenderingData data) {
            super.getTableCellRendererComponent(data);
            RegisterRow row = (RegisterRow)data.getRowObject();
            if (!row.isKnown()) {
                if (data.isSelected()) {
                    this.setForeground(DebuggerRegistersProvider.this.registerStaleSelColor);
                } else {
                    this.setForeground(DebuggerRegistersProvider.this.registerStaleColor);
                }
            } else if (row.isChanged()) {
                if (data.isSelected()) {
                    this.setForeground(DebuggerRegistersProvider.this.registerChangesSelColor);
                } else {
                    this.setForeground(DebuggerRegistersProvider.this.registerChangesColor);
                }
            }
            return this;
        }
    }

    class RegAccessListener
    implements TraceRecorderListener {
        RegAccessListener() {
        }

        @Override
        public void registerBankMapped(TraceRecorder recorder) {
            Swing.runIfSwingOrRunLater(() -> DebuggerRegistersProvider.this.loadValues());
        }

        @Override
        public void registerAccessibilityChanged(TraceRecorder recorder) {
            Swing.runIfSwingOrRunLater(() -> DebuggerRegistersProvider.this.loadValues());
        }
    }

    class TraceChangeListener
    extends TraceDomainObjectListener {
        public TraceChangeListener() {
            this.listenForUntyped(4, e -> this.objectRestored((DomainObjectChangeRecord)e));
            this.listenFor((TraceChangeType)Trace.TraceMemoryBytesChangeType.CHANGED, this::registerValueChanged);
            this.listenFor((TraceChangeType)Trace.TraceMemoryStateChangeType.CHANGED, this::registerStateChanged);
            this.listenFor((TraceChangeType)Trace.TraceCodeChangeType.ADDED, this::registerTypeAdded);
            this.listenFor((TraceChangeType)Trace.TraceCodeChangeType.DATA_TYPE_REPLACED, this::registerTypeReplaced);
            this.listenFor((TraceChangeType)Trace.TraceCodeChangeType.LIFESPAN_CHANGED, this::registerTypeLifespanChanged);
            this.listenFor((TraceChangeType)Trace.TraceCodeChangeType.REMOVED, this::registerTypeRemoved);
            this.listenFor((TraceChangeType)Trace.TraceThreadChangeType.DELETED, this::threadDeleted);
            this.listenFor((TraceChangeType)Trace.TraceThreadChangeType.LIFESPAN_CHANGED, this::threadDestroyed);
        }

        private boolean isVisible(TraceAddressSpace space) {
            TraceThread curThread = DebuggerRegistersProvider.this.current.getThread();
            if (curThread == null) {
                return false;
            }
            if (space.getThread() != curThread) {
                return false;
            }
            return space.getFrameLevel() == DebuggerRegistersProvider.this.current.getFrame().intValue();
        }

        private boolean isVisible(TraceAddressSpace space, TraceAddressSnapRange range) {
            if (!this.isVisible(space)) {
                return false;
            }
            TraceProgramView view = DebuggerRegistersProvider.this.current.getView();
            return view != null && view.getViewport().containsAnyUpper(range.getLifespan());
        }

        private void refreshRange(AddressRange range) {
            TraceMemoryRegisterSpace space = DebuggerRegistersProvider.this.getRegisterMemorySpace(false);
            assert (space != null);
            DebuggerRegistersProvider.this.regsTableModel.fireTableDataChanged();
        }

        private void objectRestored(DomainObjectChangeRecord rec) {
            DebuggerRegistersProvider.this.coordinatesActivated(DebuggerRegistersProvider.this.current.withReFoundThread());
        }

        private void registerValueChanged(TraceAddressSpace space, TraceAddressSnapRange range, byte[] oldIsNull, byte[] newVal) {
            if (!this.isVisible(space, range)) {
                return;
            }
            this.refreshRange(range.getRange());
        }

        private void registerStateChanged(TraceAddressSpace space, TraceAddressSnapRange range, TraceMemoryState oldState, TraceMemoryState newState) {
            if (!this.isVisible(space, range)) {
                return;
            }
            DebuggerRegistersProvider.this.recomputeViewKnown();
            this.refreshRange(range.getRange());
        }

        private void registerTypeAdded(TraceAddressSpace space, TraceAddressSnapRange range, TraceCodeUnit oldIsNull, TraceCodeUnit newUnit) {
            if (!this.isVisible(space, range)) {
                return;
            }
            this.refreshRange(range.getRange());
        }

        private void registerTypeReplaced(TraceAddressSpace space, TraceAddressSnapRange range, long oldTypeID, long newTypeID) {
            if (!this.isVisible(space, range)) {
                return;
            }
            this.refreshRange(range.getRange());
        }

        private void registerTypeLifespanChanged(TraceAddressSpace space, TraceCodeUnit unit, Range<Long> oldSpan, Range<Long> newSpan) {
            if (!this.isVisible(space)) {
                return;
            }
            TraceProgramView view = DebuggerRegistersProvider.this.current.getView();
            if (view == null) {
                return;
            }
            TraceTimeViewport viewport = view.getViewport();
            if (viewport.containsAnyUpper(oldSpan) == viewport.containsAnyUpper(newSpan)) {
                return;
            }
            AddressRangeImpl range = new AddressRangeImpl(unit.getMinAddress(), unit.getMaxAddress());
            this.refreshRange((AddressRange)range);
        }

        private void registerTypeRemoved(TraceAddressSpace space, TraceAddressSnapRange range, TraceCodeUnit oldUnit, TraceCodeUnit newIsNull) {
            if (!this.isVisible(space)) {
                return;
            }
            this.refreshRange(range.getRange());
        }

        private void threadDeleted(TraceThread thread) {
        }

        private void threadDestroyed(TraceThread thread, Range<Long> oldSpan, Range<Long> newSpan) {
        }
    }

    protected static class RegistersTableModel
    extends DefaultEnumeratedColumnTableModel<RegisterTableColumns, RegisterRow> {
        public RegistersTableModel() {
            super("Registers", RegisterTableColumns.class);
        }

        public List<RegisterTableColumns> defaultSortOrder() {
            return List.of(RegisterTableColumns.FAV, RegisterTableColumns.NUMBER);
        }
    }

    protected static enum RegisterTableColumns implements DefaultEnumeratedColumnTableModel.EnumeratedTableColumn<RegisterTableColumns, RegisterRow>
    {
        FAV("Fav", Boolean.class, RegisterRow::isFavorite, RegisterRow::setFavorite, r -> true, ColumnSortState.SortDirection.DESCENDING),
        NUMBER("#", Integer.class, RegisterRow::getNumber),
        NAME("Name", String.class, RegisterRow::getName),
        VALUE("Value", BigInteger.class, RegisterRow::getValue, RegisterRow::setValue, RegisterRow::isValueEditable, ColumnSortState.SortDirection.ASCENDING),
        TYPE("Type", DataType.class, RegisterRow::getDataType, RegisterRow::setDataType, r -> true, ColumnSortState.SortDirection.ASCENDING),
        REPR("Repr", String.class, RegisterRow::getRepresentation);

        private final String header;
        private final Function<RegisterRow, ?> getter;
        private final BiConsumer<RegisterRow, Object> setter;
        private final Predicate<RegisterRow> editable;
        private final Class<?> cls;
        private final ColumnSortState.SortDirection direction;

        private <T> RegisterTableColumns(String header, Class<T> cls, Function<RegisterRow, T> getter) {
            this(header, cls, getter, null, null, ColumnSortState.SortDirection.ASCENDING);
        }

        private <T> RegisterTableColumns(String header, Class<T> cls, Function<RegisterRow, T> getter, BiConsumer<RegisterRow, T> setter, Predicate<RegisterRow> editable, ColumnSortState.SortDirection direction) {
            this.header = header;
            this.cls = cls;
            this.getter = getter;
            this.setter = setter;
            this.editable = editable;
            this.direction = direction;
        }

        public Class<?> getValueClass() {
            return this.cls;
        }

        public Object getValueOf(RegisterRow row) {
            return this.getter.apply(row);
        }

        public String getHeader() {
            return this.header;
        }

        public boolean isEditable(RegisterRow row) {
            return this.editable != null && this.editable.test(row);
        }

        public void setValueOf(RegisterRow row, Object value) {
            this.setter.accept(row, value);
        }

        public ColumnSortState.SortDirection defaultSortDirection() {
            return this.direction;
        }
    }
}

