/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.stack;

import docking.ComponentProvider;
import ghidra.app.plugin.core.debug.AbstractDebuggerPlugin;
import ghidra.app.plugin.core.debug.event.TraceActivatedPluginEvent;
import ghidra.app.plugin.core.debug.event.TraceClosedPluginEvent;
import ghidra.app.plugin.core.debug.gui.stack.DebuggerStackProvider;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;

@PluginInfo(shortDescription="Debugger stack view", description="GUI to navigate the stack", category="Debugger", packageName="Debugger", status=PluginStatus.RELEASED, eventsConsumed={TraceActivatedPluginEvent.class, TraceClosedPluginEvent.class}, servicesRequired={})
public class DebuggerStackPlugin
extends AbstractDebuggerPlugin {
    protected DebuggerStackProvider provider;

    public DebuggerStackPlugin(PluginTool tool) {
        super(tool);
    }

    @Override
    protected void init() {
        this.provider = new DebuggerStackProvider(this);
        super.init();
    }

    protected void dispose() {
        this.tool.removeComponentProvider((ComponentProvider)this.provider);
    }

    public void processEvent(PluginEvent event) {
        super.processEvent(event);
        if (event instanceof TraceActivatedPluginEvent) {
            TraceActivatedPluginEvent ev = (TraceActivatedPluginEvent)event;
            this.provider.coordinatesActivated(ev.getActiveCoordinates());
        }
    }
}

