/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.stack;

import com.google.common.collect.Range;
import ghidra.app.plugin.core.debug.gui.stack.DebuggerStackProvider;
import ghidra.framework.model.UndoableDomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.util.ProgramLocation;
import ghidra.trace.model.DefaultTraceLocation;
import ghidra.trace.model.TraceLocation;
import ghidra.trace.model.stack.TraceStackFrame;
import ghidra.trace.model.thread.TraceThread;
import ghidra.util.database.UndoableTransaction;

public class StackFrameRow {
    private final DebuggerStackProvider provider;
    final TraceStackFrame frame;
    private int level;
    Address pc;

    public StackFrameRow(DebuggerStackProvider provider, TraceStackFrame frame) {
        this.provider = provider;
        this.frame = frame;
        this.level = frame.getLevel();
        this.pc = frame.getProgramCounter();
    }

    private StackFrameRow(DebuggerStackProvider provider, Address pc) {
        this.provider = provider;
        this.frame = null;
        this.level = 0;
        this.pc = pc;
    }

    public int getFrameLevel() {
        return this.level;
    }

    public Address getProgramCounter() {
        return this.pc;
    }

    public String getComment() {
        return this.frame == null ? "" : this.frame.getComment();
    }

    public void setComment(String comment) {
        try (UndoableTransaction tid = UndoableTransaction.start((UndoableDomainObject)this.frame.getStack().getThread().getTrace(), (String)"Frame comment", (boolean)true);){
            this.frame.setComment(comment);
        }
    }

    public boolean isCommentable() {
        return this.frame != null;
    }

    public Function getFunction() {
        if (this.provider.mappingService == null) {
            return null;
        }
        TraceThread curThread = this.provider.current.getThread();
        if (curThread == null) {
            return null;
        }
        if (this.pc == null) {
            return null;
        }
        DefaultTraceLocation dloc = new DefaultTraceLocation(curThread.getTrace(), curThread, Range.singleton((Comparable)this.provider.current.getSnap()), this.pc);
        ProgramLocation sloc = this.provider.mappingService.getOpenMappedLocation((TraceLocation)dloc);
        if (sloc == null) {
            return null;
        }
        return sloc.getProgram().getFunctionManager().getFunctionContaining(sloc.getAddress());
    }

    protected void update() {
        assert (this.frame != null);
        this.level = this.frame.getLevel();
        this.pc = this.frame.getProgramCounter();
    }

    public static class Synthetic
    extends StackFrameRow {
        public Synthetic(DebuggerStackProvider provider, Address pc) {
            super(provider, pc);
        }

        public void updateProgramCounter(Address pc) {
            this.pc = pc;
        }
    }
}

