/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.watch;

import docking.ComponentProvider;
import ghidra.app.plugin.core.debug.AbstractDebuggerPlugin;
import ghidra.app.plugin.core.debug.event.TraceActivatedPluginEvent;
import ghidra.app.plugin.core.debug.gui.watch.DebuggerWatchesProvider;
import ghidra.app.services.DataTypeManagerService;
import ghidra.app.services.DebuggerModelService;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;

@PluginInfo(shortDescription="Debugger watches manager", description="GUI to watch values of expressions", category="Debugger", packageName="Debugger", status=PluginStatus.RELEASED, eventsConsumed={TraceActivatedPluginEvent.class}, servicesRequired={DebuggerModelService.class, DebuggerTraceManagerService.class, DataTypeManagerService.class})
public class DebuggerWatchesPlugin
extends AbstractDebuggerPlugin {
    private DebuggerWatchesProvider provider;

    public DebuggerWatchesPlugin(PluginTool tool) {
        super(tool);
    }

    @Override
    protected void init() {
        this.provider = new DebuggerWatchesProvider(this);
        super.init();
    }

    protected void dispose() {
        this.tool.removeComponentProvider((ComponentProvider)this.provider);
    }

    public void processEvent(PluginEvent event) {
        super.processEvent(event);
        if (event instanceof TraceActivatedPluginEvent) {
            TraceActivatedPluginEvent ev = (TraceActivatedPluginEvent)event;
            this.provider.coordinatesActivated(ev.getActiveCoordinates());
        }
    }

    public void writeConfigState(SaveState saveState) {
        this.provider.writeConfigState(saveState);
    }

    public void readConfigState(SaveState saveState) {
        this.provider.readConfigState(saveState);
    }
}

