/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.mapping;

import ghidra.app.plugin.core.debug.mapping.DebuggerRegisterMapper;
import ghidra.app.plugin.core.debug.register.RegisterTypeInfo;
import ghidra.dbg.target.TargetRegister;
import ghidra.dbg.target.TargetRegisterContainer;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class DefaultDebuggerRegisterMapper
implements DebuggerRegisterMapper {
    protected final Language language;
    protected final CompilerSpec cspec;
    protected final boolean caseSensitive;
    protected final Map<String, Register> languageRegs = new LinkedHashMap<String, Register>();
    protected final Map<String, Register> filtLanguageRegs = new LinkedHashMap<String, Register>();
    protected final Map<String, TargetRegister> targetRegs = new HashMap<String, TargetRegister>();
    protected final RegisterTypeInfo instrCtrTypeInfo;
    protected final RegisterTypeInfo stackPtrTypeInfo;

    public DefaultDebuggerRegisterMapper(CompilerSpec cSpec, TargetRegisterContainer targetRegContainer, boolean caseSensitive) {
        this.language = cSpec.getLanguage();
        this.cspec = cSpec;
        this.caseSensitive = caseSensitive;
        this.instrCtrTypeInfo = new RegisterTypeInfo((DataType)PointerDataType.dataType, PointerDataType.dataType.getDefaultSettings(), this.language.getDefaultSpace());
        this.stackPtrTypeInfo = new RegisterTypeInfo((DataType)PointerDataType.dataType, PointerDataType.dataType.getDefaultSettings(), cSpec.getStackSpace());
        this.collectFilteredLanguageRegs();
    }

    protected boolean testTraceRegister(Register lReg) {
        return lReg.isBaseRegister();
    }

    protected synchronized void collectFilteredLanguageRegs() {
        for (Register lReg : this.language.getRegisters()) {
            if (!this.testTraceRegister(lReg)) continue;
            this.filtLanguageRegs.put(this.normalizeName(lReg.getName()), lReg);
        }
    }

    protected synchronized Register considerRegister(String index) {
        String name = this.normalizeName(index);
        Register lReg = this.filtLanguageRegs.get(name);
        if (lReg == null) {
            return null;
        }
        this.languageRegs.put(name, lReg);
        return lReg;
    }

    protected synchronized Register considerRegister(TargetRegister tReg) {
        String name = this.normalizeName(tReg.getIndex());
        Register lReg = this.filtLanguageRegs.get(name);
        if (lReg == null) {
            return null;
        }
        this.targetRegs.put(name, tReg);
        this.languageRegs.put(name, lReg);
        return lReg;
    }

    protected synchronized Register removeRegister(TargetRegister tReg) {
        String name = this.normalizeName(tReg.getIndex());
        Register lReg = this.filtLanguageRegs.get(name);
        if (lReg == null) {
            return null;
        }
        this.targetRegs.remove(name);
        this.languageRegs.remove(name);
        return lReg;
    }

    protected String normalizeName(String name) {
        if (this.caseSensitive) {
            return name;
        }
        return name.toLowerCase();
    }

    @Override
    public synchronized TargetRegister getTargetRegister(String name) {
        return this.targetRegs.get(this.normalizeName(name));
    }

    @Override
    public synchronized Register getTraceRegister(String name) {
        return this.languageRegs.get(this.normalizeName(name));
    }

    @Override
    public synchronized TargetRegister traceToTarget(Register lReg) {
        return this.targetRegs.get(this.normalizeName(lReg.getName()));
    }

    @Override
    public synchronized Register targetToTrace(TargetRegister tReg) {
        return this.languageRegs.get(this.normalizeName(tReg.getIndex()));
    }

    @Override
    public RegisterTypeInfo getDefaultTypeInfo(Register register) {
        if (register == this.language.getProgramCounter()) {
            return this.instrCtrTypeInfo;
        }
        if (register == this.cspec.getStackPointer()) {
            return this.stackPtrTypeInfo;
        }
        return null;
    }

    @Override
    public synchronized Set<Register> getRegistersOnTarget() {
        return Set.copyOf(this.languageRegs.values());
    }

    @Override
    public synchronized void targetRegisterAdded(TargetRegister register) {
        this.considerRegister(register);
    }

    @Override
    public synchronized void targetRegisterRemoved(TargetRegister register) {
        this.removeRegister(register);
    }
}

