/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.model;

import ghidra.app.plugin.core.debug.service.model.DefaultTraceRecorder;
import ghidra.app.plugin.core.debug.service.model.interfaces.ManagedThreadRecorder;
import ghidra.async.AsyncFence;
import ghidra.dbg.DebugModelConventions;
import ghidra.dbg.target.TargetBreakpointLocation;
import ghidra.dbg.target.TargetBreakpointSpec;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetProcess;
import ghidra.dbg.target.TargetThread;
import ghidra.dbg.util.PathUtils;
import ghidra.trace.model.thread.TraceThread;
import ghidra.util.Msg;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

public class RecorderBreakpointLocationResolver {
    private DefaultTraceRecorder recorder;
    private final TargetBreakpointLocation bpt;
    private final TargetBreakpointSpec spec;
    private boolean affectsProcess = false;
    private final Set<TraceThread> threadsAffected = new LinkedHashSet<TraceThread>();

    public RecorderBreakpointLocationResolver(DefaultTraceRecorder recorder, TargetBreakpointLocation bpt) {
        this.recorder = recorder;
        this.bpt = bpt;
        this.spec = bpt.getSpecification();
    }

    static Collection<TargetObject> getAffects(TargetBreakpointLocation bpt) {
        TargetBreakpointLocation findProc = bpt;
        while (!(findProc instanceof TargetProcess)) {
            findProc = findProc.getParent();
        }
        return List.of(findProc);
    }

    private CompletableFuture<Void> resolve(TargetObject obj) {
        AsyncFence fence = new AsyncFence();
        if (obj.equals((Object)this.recorder.getTarget())) {
            this.affectsProcess = true;
        } else {
            fence.include(this.resolveThread(obj));
        }
        return fence.ready();
    }

    private CompletableFuture<Void> resolveThread(TargetObject ref) {
        return ((CompletableFuture)DebugModelConventions.findThread((TargetObject)ref).thenAccept(thread -> {
            if (thread == null) {
                Msg.error((Object)this, (Object)("Could not find process or thread from breakpoint-affected object: " + ref));
                return;
            }
            if (!ref.equals(thread)) {
                Msg.warn((Object)this, (Object)("Effective breakpoint should apply to process or threads. Got " + ref + ". Resolved to " + thread));
                return;
            }
            if (!PathUtils.isAncestor((List)this.recorder.getTarget().getPath(), (List)thread.getPath())) {
                return;
            }
            ManagedThreadRecorder rec = this.recorder.getThreadRecorder((TargetThread)thread);
            Set<TraceThread> set = this.threadsAffected;
            synchronized (set) {
                this.threadsAffected.add(rec.getTraceThread());
            }
        })).exceptionally(ex -> {
            Msg.error((Object)this, (Object)("Error resolving thread from breakpoint-affected object: " + ref));
            return null;
        });
    }

    public void updateBreakpoint(TargetObject containerParent, TargetBreakpointLocation loc) {
        ((CompletableFuture)this.resolve(containerParent).thenAccept(__ -> {
            if (this.affectsProcess || !this.threadsAffected.isEmpty()) {
                this.recorder.breakpointRecorder.recordBreakpoint(loc, this.threadsAffected);
            }
        })).exceptionally(ex -> {
            Msg.error((Object)this, (Object)("Could record target breakpoint: " + loc), (Throwable)ex);
            return null;
        });
    }
}

