/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.model;

import ghidra.app.plugin.core.debug.service.model.DefaultTraceRecorder;
import ghidra.app.services.TraceRecorderListener;
import ghidra.async.AsyncLazyMap;
import ghidra.async.AsyncUtils;
import ghidra.dbg.DebugModelConventions;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetRegisterBank;
import ghidra.util.Msg;
import ghidra.util.TriConsumer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class RecorderComposedRegisterSet {
    private DefaultTraceRecorder recorder;
    protected final TriConsumer<Boolean, Boolean, Void> listenerRegAccChanged = this::registerAccessibilityChanged;
    protected final AsyncLazyMap<TargetRegisterBank, DebugModelConventions.AllRequiredAccess> accessibilityByRegBank = new AsyncLazyMap<TargetRegisterBank, DebugModelConventions.AllRequiredAccess>(new HashMap(), this::fetchRegAccessibility){

        public DebugModelConventions.AllRequiredAccess remove(TargetRegisterBank key) {
            DebugModelConventions.AllRequiredAccess acc = (DebugModelConventions.AllRequiredAccess)super.remove((Object)key);
            if (acc != null) {
                acc.removeChangeListener(RecorderComposedRegisterSet.this.listenerRegAccChanged);
            }
            return acc;
        }
    };

    protected void registerAccessibilityChanged(boolean old, boolean acc, Void __) {
        ((TraceRecorderListener)this.recorder.getListeners().fire).registerAccessibilityChanged(this.recorder);
    }

    protected CompletableFuture<DebugModelConventions.AllRequiredAccess> fetchRegAccessibility(TargetRegisterBank bank) {
        return DebugModelConventions.trackAccessibility((TargetObject)bank).thenApply(acc -> {
            acc.addChangeListener(this.listenerRegAccChanged);
            return acc;
        });
    }

    public RecorderComposedRegisterSet(DefaultTraceRecorder recorder) {
        this.recorder = recorder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRegisters(TargetRegisterBank newRegs, TargetRegisterBank oldRegs) {
        AsyncLazyMap<TargetRegisterBank, DebugModelConventions.AllRequiredAccess> asyncLazyMap = this.accessibilityByRegBank;
        synchronized (asyncLazyMap) {
            if (oldRegs != null) {
                this.accessibilityByRegBank.remove((Object)oldRegs);
            }
            this.accessibilityByRegBank.get((Object)newRegs).exceptionally(e -> {
                e = AsyncUtils.unwrapThrowable((Throwable)e);
                Msg.error((Object)this, (Object)("Could not track register accessibility: " + e.getMessage()));
                return null;
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkRegistersRemoved(Map<Integer, TargetRegisterBank> regs, TargetObject invalid) {
        AsyncLazyMap<TargetRegisterBank, DebugModelConventions.AllRequiredAccess> asyncLazyMap = this.accessibilityByRegBank;
        synchronized (asyncLazyMap) {
            if (regs.values().remove(invalid)) {
                this.accessibilityByRegBank.remove((Object)((TargetRegisterBank)invalid));
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRegisterBankAccessible(TargetRegisterBank bank) {
        if (bank == null) {
            return false;
        }
        AsyncLazyMap<TargetRegisterBank, DebugModelConventions.AllRequiredAccess> asyncLazyMap = this.accessibilityByRegBank;
        synchronized (asyncLazyMap) {
            AsyncLazyMap.KeyedFuture future = this.accessibilityByRegBank.get((Object)bank);
            if (future == null) {
                return false;
            }
            DebugModelConventions.AllRequiredAccess acc = (DebugModelConventions.AllRequiredAccess)future.getNow(null);
            if (acc == null) {
                return false;
            }
            return (Boolean)acc.get();
        }
    }
}

