/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.utils;

import ghidra.app.services.ProgramManager;
import ghidra.framework.client.RepositoryAdapter;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.Project;
import ghidra.framework.model.ProjectData;
import ghidra.framework.model.ProjectLocator;
import ghidra.framework.model.ServerInfo;
import ghidra.framework.protocol.ghidra.GhidraURL;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import java.net.MalformedURLException;
import java.net.URL;

public enum ProgramURLUtils {


    public static URL getUrlFromProgram(Program program) {
        RepositoryAdapter repository;
        DomainFile file = program.getDomainFile();
        ProjectLocator projectLocator = file.getProjectLocator();
        if (projectLocator == null) {
            return null;
        }
        DomainFolder parent = file.getParent();
        ProjectData projectData = parent == null ? null : parent.getProjectData();
        RepositoryAdapter repositoryAdapter = repository = projectData == null ? null : projectData.getRepository();
        if (repository != null && file.isVersioned()) {
            ServerInfo server = repository.getServerInfo();
            return GhidraURL.makeURL((String)server.getServerName(), (int)server.getPortNumber(), (String)repository.getName(), (String)file.getPathname());
        }
        return ProgramURLUtils.hackAddLocalDomainFilePath(projectLocator.getURL(), file.getPathname());
    }

    protected static URL hackAddLocalDomainFilePath(URL localProjectURL, String pathname) {
        try {
            return new URL(localProjectURL.toExternalForm() + "!" + pathname);
        }
        catch (MalformedURLException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static DomainFile getFileForHackedUpGhidraURL(Project project, URL ghidraURL) {
        try {
            String asString = ghidraURL.toExternalForm();
            int bangLoc = asString.indexOf(33);
            if (bangLoc == -1) {
                ProjectData projectData = project.getProjectData(ghidraURL);
                if (projectData == null) {
                    return null;
                }
                return projectData.getFile(ghidraURL.getPath());
            }
            URL localProjURL = new URL(asString.substring(0, bangLoc));
            ProjectData projectData = project.getProjectData(localProjURL);
            if (projectData == null) {
                Msg.error(ProgramURLUtils.class, (Object)("The repository containing " + ghidraURL + " is not open in the Project manager."));
                return null;
            }
            return projectData.getFile(asString.substring(bangLoc + 1));
        }
        catch (MalformedURLException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static Program openHackedUpGhidraURL(ProgramManager programManager, Project project, URL ghidraURL, int state) {
        DomainFile file = ProgramURLUtils.getFileForHackedUpGhidraURL(project, ghidraURL);
        return programManager.openProgram(file, -1, state);
    }
}

